/*
 * Decompiled with CFR 0.152.
 */
package net.sf.rej.java;

import java.util.ArrayList;
import java.util.List;
import net.sf.rej.java.JavaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Descriptor {
    private List<JavaType> paramParsed = new ArrayList<JavaType>();
    private JavaType retParsed;
    private boolean hasParamPart = false;
    public static final Descriptor NO_PARAM_VOID = new Descriptor("V");

    public Descriptor(String desc) {
        if (desc.indexOf("(") != -1) {
            this.hasParamPart = true;
            String param = desc.substring(1, desc.indexOf(")"));
            DescriptorParser parser = new DescriptorParser(param);
            while (parser.hasMore()) {
                this.paramParsed.add(new JavaType(parser.getType()));
            }
        }
        String ret = desc.substring(desc.indexOf(")") + 1);
        this.retParsed = new JavaType(new DescriptorParser(ret).getType());
    }

    public String getParams() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.paramParsed.size(); ++i) {
            JavaType jt = this.paramParsed.get(i);
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(jt);
        }
        return sb.toString();
    }

    public void setReturn(JavaType type) {
        this.retParsed = type;
    }

    public JavaType getReturn() {
        return this.retParsed;
    }

    public List<JavaType> getParamList() {
        ArrayList<JavaType> al = new ArrayList<JavaType>();
        al.addAll(this.paramParsed);
        return al;
    }

    public void setParamList(List<JavaType> list) {
        this.paramParsed = list;
        this.hasParamPart = true;
    }

    public String getRawDesc() {
        return this.getRawParams() + this.retParsed.getRaw();
    }

    public String getRawParams() {
        if (this.hasParamPart) {
            StringBuffer sb = new StringBuffer();
            sb.append("(");
            for (int i = 0; i < this.paramParsed.size(); ++i) {
                JavaType jt = this.paramParsed.get(i);
                sb.append(jt.getRaw());
            }
            sb.append(")");
            return sb.toString();
        }
        return "";
    }

    public boolean equals(Object o) {
        if (!(o instanceof Descriptor)) {
            return false;
        }
        return ((Descriptor)o).getRawDesc().equals(this.getRawDesc());
    }

    public int hashCode() {
        return this.getRawDesc().hashCode();
    }

    public static String arrayTypeToRaw(String type) {
        int index;
        StringBuffer raw = new StringBuffer(type);
        StringBuffer array = new StringBuffer();
        while ((index = raw.lastIndexOf("[]")) != -1) {
            raw.delete(index, raw.length());
            array.append('[');
        }
        if (array.length() > 0) {
            return array + "L" + raw.toString().replace('.', '/') + ";";
        }
        return type.replace('.', '/');
    }

    public static class DescriptorParser {
        private String data;
        private int pos = 0;

        public DescriptorParser(String descriptor) {
            this.data = descriptor;
        }

        public String getType() {
            switch (this.data.charAt(this.pos++)) {
                case 'B': {
                    return "byte";
                }
                case 'C': {
                    return "char";
                }
                case 'D': {
                    return "double";
                }
                case 'F': {
                    return "float";
                }
                case 'I': {
                    return "int";
                }
                case 'J': {
                    return "long";
                }
                case 'S': {
                    return "short";
                }
                case 'Z': {
                    return "boolean";
                }
                case 'L': {
                    int end = this.data.indexOf(";", this.pos);
                    String c = this.data.substring(this.pos, end);
                    this.pos = end + 1;
                    return c.replace('/', '.');
                }
                case 'V': {
                    return "void";
                }
                case '[': {
                    return this.getType() + "[]";
                }
            }
            throw new RuntimeException("Error parsing descriptor: " + this.data + " illegal definition: " + this.data.charAt(this.pos - 1));
        }

        public boolean hasMore() {
            return this.pos < this.data.length();
        }
    }
}

