/*
 * Decompiled with CFR 0.152.
 */
package net.sf.rej.java;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.rej.java.AccessFlags;
import net.sf.rej.java.ClassVersion;
import net.sf.rej.java.Field;
import net.sf.rej.java.Interface;
import net.sf.rej.java.Method;
import net.sf.rej.java.attribute.Attributes;
import net.sf.rej.java.constantpool.ConstantPool;
import net.sf.rej.java.constantpool.ConstantPoolInfo;
import net.sf.rej.util.ByteSerializer;
import net.sf.rej.util.ByteToolkit;
import net.sf.rej.util.Range;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassFile {
    private static final byte[] magic = new byte[]{-54, -2, -70, -66};
    private ClassVersion version = new ClassVersion();
    private ConstantPool pool;
    private int accessFlags;
    private int thisClass;
    private int superClass;
    private List<Interface> interfaces = new ArrayList<Interface>();
    private List<Field> fields = new ArrayList<Field>();
    private List<Method> methods = new ArrayList<Method>();
    private Attributes attributes;

    public int getAccessFlags() {
        return this.accessFlags;
    }

    public int getMajorVersion() {
        return this.version.getMajorVersion();
    }

    public int getMinorVersion() {
        return this.version.getMinorVersion();
    }

    public void setMajorVersion(int majorVersion) {
        this.version.setMajorVersion(majorVersion);
    }

    public void setMinorVersion(int minorVersion) {
        this.version.setMinorVersion(minorVersion);
    }

    public ClassVersion getVersion() {
        return this.version;
    }

    public void setVersion(ClassVersion version) {
        this.version = version;
    }

    public List<Method> getMethods() {
        ArrayList<Method> list = new ArrayList<Method>();
        list.addAll(this.methods);
        return list;
    }

    public void add(Method method) {
        this.methods.add(method);
    }

    public void add(Field field) {
        this.fields.add(field);
    }

    public List<Interface> getInterfaces() {
        ArrayList<Interface> list = new ArrayList<Interface>();
        list.addAll(this.interfaces);
        return list;
    }

    public int getThisClass() {
        return this.thisClass;
    }

    public Attributes getAttributes() {
        return this.attributes;
    }

    public int getSuperClass() {
        return this.superClass;
    }

    public List<Field> getFields() {
        ArrayList<Field> list = new ArrayList<Field>();
        list.addAll(this.fields);
        return list;
    }

    public ConstantPool getPool() {
        return this.pool;
    }

    public byte[] getMagic() {
        return magic;
    }

    public void setAccessFlags(int accessFlags) {
        this.accessFlags = accessFlags;
    }

    public void setMethods(List<Method> methods) {
        this.methods.clear();
        this.methods.addAll(methods);
    }

    public void setInterfaces(List<Interface> interfaces) {
        this.interfaces.clear();
        this.interfaces.addAll(interfaces);
    }

    public void setThisClass(int thisClass) {
        this.thisClass = thisClass;
    }

    public void setAttributes(Attributes attributes) {
        this.attributes = attributes;
    }

    public void setSuperClass(int superClass) {
        this.superClass = superClass;
    }

    public void setFields(List<Field> fields) {
        this.fields.clear();
        this.fields.addAll(fields);
    }

    public void setPool(ConstantPool pool) {
        this.pool = pool;
    }

    public void validateMagic(byte[] magic) throws RuntimeException {
        if (!Arrays.equals(magic, ClassFile.magic)) {
            throw new RuntimeException("Invalid magic: " + ByteToolkit.getHexString(magic));
        }
    }

    public byte[] getData() {
        ByteSerializer ser = new ByteSerializer(true);
        ser.addBytes(magic);
        ser.addShort(this.getMinorVersion());
        ser.addShort(this.getMajorVersion());
        ser.addBytes(this.pool.getData());
        ser.addShort(this.accessFlags);
        ser.addShort(this.thisClass);
        ser.addShort(this.superClass);
        ser.addShort(this.interfaces.size());
        for (Interface anInterface : this.interfaces) {
            ser.addShort(anInterface.getNameIndex());
        }
        ser.addShort(this.fields.size());
        for (Field field : this.fields) {
            ser.addBytes(field.getData());
        }
        ser.addShort(this.methods.size());
        for (Method method : this.methods) {
            ser.addBytes(method.getData());
        }
        ser.addBytes(this.attributes.getData());
        return ser.getBytes();
    }

    public Map<Object, Range> getOffsetMap() {
        HashMap<Object, Range> map = new HashMap<Object, Range>();
        int offset = 0;
        map.put((Object)OffsetTag.MAGIC, new Range(offset, 4));
        map.put((Object)OffsetTag.VERSION, new Range(offset += 4, 4));
        map.put((Object)OffsetTag.MINOR_VERSION, new Range(offset, 2));
        map.put((Object)OffsetTag.MAJOR_VERSION, new Range(offset += 2, 2));
        int poolSize = this.pool.getData().length;
        map.put((Object)OffsetTag.CONSTANT_POOL, new Range(offset += 2, poolSize));
        map.put((Object)OffsetTag.ACCESS_FLAGS, new Range(offset += poolSize, 2));
        map.put((Object)OffsetTag.THIS_CLASS, new Range(offset += 2, 2));
        map.put((Object)OffsetTag.SUPER_CLASS, new Range(offset += 2, 2));
        map.put((Object)OffsetTag.INTERFACE_COUNT, new Range(offset += 2, 2));
        map.put((Object)OffsetTag.INTERFACE_DATA, new Range(offset += 2, this.interfaces.size() * 2));
        for (Interface anInterface : this.interfaces) {
            map.put(anInterface, new Range(offset, 2));
            offset += 2;
        }
        map.put((Object)OffsetTag.FIELD_COUNT, new Range(offset, 2));
        int fieldDataTotalSize = 0;
        Range fieldDataOffset = new Range(offset += 2, 0);
        map.put((Object)OffsetTag.FIELD_DATA, fieldDataOffset);
        for (Field field : this.fields) {
            int fieldSize = field.getData().length;
            map.put(field, new Range(offset, fieldSize));
            offset += fieldSize;
            fieldDataTotalSize += fieldSize;
        }
        fieldDataOffset.setSize(fieldDataTotalSize);
        map.put((Object)OffsetTag.METHOD_COUNT, new Range(offset, 2));
        int methodDataTotalSize = 0;
        Range methodDataOffset = new Range(offset += 2, 0);
        map.put((Object)OffsetTag.METHOD_DATA, methodDataOffset);
        for (Method method : this.methods) {
            int methodSize = method.getData().length;
            map.put(method, new Range(offset, methodSize));
            offset += methodSize;
            methodDataTotalSize += methodSize;
        }
        methodDataOffset.setSize(methodDataTotalSize);
        map.put((Object)OffsetTag.ATTRIBUTES, new Range(offset, this.attributes.getData().length));
        return map;
    }

    public String getShortClassName() {
        String cn = this.getFullClassName();
        return cn.substring(cn.lastIndexOf(".") + 1);
    }

    public String getFullClassName() {
        ConstantPool cp = this.pool;
        ConstantPoolInfo cpi = cp.get(this.getThisClass());
        return cpi.getValue();
    }

    public String getSuperClassName() {
        if (this.getSuperClass() == 0) {
            return null;
        }
        ConstantPoolInfo cpi = this.pool.get(this.getSuperClass());
        return cpi.getValue();
    }

    public String getAccessString() {
        StringBuffer sb = new StringBuffer();
        if (AccessFlags.isPublic(this.accessFlags)) {
            sb.append("public ");
        }
        if (AccessFlags.isPrivate(this.accessFlags)) {
            sb.append("private ");
        }
        if (AccessFlags.isProtected(this.accessFlags)) {
            sb.append("protected ");
        }
        if (AccessFlags.isAbstract(this.accessFlags)) {
            sb.append("abstract ");
        }
        if (AccessFlags.isStatic(this.accessFlags)) {
            sb.append("static ");
        }
        if (AccessFlags.isFinal(this.accessFlags)) {
            sb.append("final ");
        }
        if (AccessFlags.isNative(this.accessFlags)) {
            sb.append("native ");
        }
        return sb.toString().trim();
    }

    public String getPackageName() {
        String cn = this.getFullClassName();
        int lastDot = cn.lastIndexOf(".");
        if (lastDot == -1) {
            return "";
        }
        return cn.substring(0, lastDot);
    }

    public void remove(Method method) {
        this.methods.remove(method);
    }

    public void remove(Field field) {
        this.fields.remove(field);
    }

    public String getJavaVersionCompabilityString() {
        return this.version.getJavaVersionCompabilityString();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ClassFile)) {
            return false;
        }
        ClassFile cf = (ClassFile)obj;
        return cf.getFullClassName().equals(this.getFullClassName());
    }

    public int hashCode() {
        return this.getFullClassName().hashCode();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OffsetTag {
        MAGIC,
        VERSION,
        MINOR_VERSION,
        MAJOR_VERSION,
        CONSTANT_POOL,
        ACCESS_FLAGS,
        THIS_CLASS,
        SUPER_CLASS,
        INTERFACE_COUNT,
        INTERFACE_DATA,
        FIELD_COUNT,
        FIELD_DATA,
        METHOD_COUNT,
        METHOD_DATA,
        ATTRIBUTES;

    }
}

