/*
 * Decompiled with CFR 0.152.
 */
package net.sf.rej.java;

import java.util.ArrayList;
import net.sf.rej.java.AccessFlags;
import net.sf.rej.java.ClassFile;
import net.sf.rej.java.Field;
import net.sf.rej.java.Interface;
import net.sf.rej.java.Method;
import net.sf.rej.java.attribute.Attributes;
import net.sf.rej.java.constantpool.ConstantPool;

public class ClassFactory {
    private byte[] magic = new byte[]{-54, -2, -70, -66};
    private int minorVersion = 0;
    private int majorVersion = 46;
    private AccessFlags flags = new AccessFlags();
    private String superClass = "java.lang.Object";

    public ClassFactory() {
        this.flags.setPublic(true);
    }

    public ClassFile createClass(String fullClassName) {
        return this.createClass(fullClassName, this.superClass);
    }

    public ClassFile createClass(String fullClassName, String superClass) {
        ClassFile cf = new ClassFile();
        cf.validateMagic(this.magic);
        cf.setMinorVersion(this.minorVersion);
        cf.setMajorVersion(this.majorVersion);
        ConstantPool pool = new ConstantPool();
        pool.init(1);
        cf.setPool(pool);
        cf.setAccessFlags(this.flags.getValue());
        cf.setThisClass(pool.optionalAddClassRef(fullClassName));
        if (superClass != null) {
            cf.setSuperClass(pool.optionalAddClassRef(superClass));
        } else {
            cf.setSuperClass(0);
        }
        cf.setInterfaces(new ArrayList<Interface>());
        cf.setFields(new ArrayList<Field>());
        cf.setMethods(new ArrayList<Method>());
        cf.setAttributes(new Attributes());
        return cf;
    }
}

