/*
 * Decompiled with CFR 0.152.
 */
package net.sf.rej.java;

public class AccessFlags {
    public static final int PUBLIC = 1;
    public static final int PRIVATE = 2;
    public static final int PROTECTED = 4;
    public static final int STATIC = 8;
    public static final int FINAL = 16;
    public static final int SYNCHRONIZED = 32;
    public static final int SUPER = 32;
    public static final int BRIDGE = 64;
    public static final int VARARGS = 128;
    public static final int NATIVE = 256;
    public static final int INTERFACE = 512;
    public static final int ABSTRACT = 1024;
    public static final int ANNOTATION = 8192;
    public static final int ENUM = 16384;
    private boolean _public = false;
    private boolean _private = false;
    private boolean _protected = false;
    private boolean _static = false;
    private boolean _final = false;
    private boolean _synchronized = false;
    private boolean _native = false;
    private boolean _abstract = false;
    private boolean _interface = false;
    private boolean _super = false;
    private boolean _enum = false;
    private boolean _annotation = false;
    private boolean _varargs = false;
    private boolean _bridge = false;

    public AccessFlags() {
    }

    public AccessFlags(int flags) {
        this._public = AccessFlags.isPublic(flags);
        this._private = AccessFlags.isPrivate(flags);
        this._protected = AccessFlags.isProtected(flags);
        this._static = AccessFlags.isStatic(flags);
        this._final = AccessFlags.isFinal(flags);
        this._synchronized = AccessFlags.isSynchronized(flags);
        this._native = AccessFlags.isNative(flags);
        this._abstract = AccessFlags.isAbstract(flags);
        this._enum = AccessFlags.isEnum(flags);
        this._annotation = AccessFlags.isAnnotation(flags);
        this._varargs = AccessFlags.isVarArgs(flags);
        this._bridge = AccessFlags.isBridge(flags);
    }

    public static boolean isPublic(int flag) {
        return (flag & 1) != 0;
    }

    public static boolean isPrivate(int flag) {
        return (flag & 2) != 0;
    }

    public static boolean isProtected(int flag) {
        return (flag & 4) != 0;
    }

    public static boolean isStatic(int flag) {
        return (flag & 8) != 0;
    }

    public static boolean isFinal(int flag) {
        return (flag & 0x10) != 0;
    }

    public static boolean isSynchronized(int flag) {
        return (flag & 0x20) != 0;
    }

    public static boolean isSuper(int flag) {
        return (flag & 0x20) != 0;
    }

    public static boolean isNative(int flag) {
        return (flag & 0x100) != 0;
    }

    public static boolean isInterface(int flag) {
        return (flag & 0x200) != 0;
    }

    public static boolean isAbstract(int flag) {
        return (flag & 0x400) != 0;
    }

    public static boolean isEnum(int flag) {
        return (flag & 0x4000) != 0;
    }

    public static boolean isAnnotation(int flag) {
        return (flag & 0x2000) != 0;
    }

    public static boolean isVarArgs(int flag) {
        return (flag & 0x80) != 0;
    }

    public static boolean isBridge(int flag) {
        return (flag & 0x40) != 0;
    }

    public void setAbstract(boolean value) {
        this._abstract = value;
    }

    public void setPublic(boolean value) {
        this._public = value;
    }

    public void setPrivate(boolean value) {
        this._private = value;
    }

    public void setNative(boolean value) {
        this._native = value;
    }

    public void setProtected(boolean value) {
        this._protected = value;
    }

    public void setSynchronized(boolean value) {
        this._synchronized = value;
    }

    public void setStatic(boolean value) {
        this._static = value;
    }

    public void setFinal(boolean value) {
        this._final = value;
    }

    public void setSuper(boolean value) {
        this._super = value;
    }

    public void setInterface(boolean value) {
        this._interface = value;
    }

    public void setEnum(boolean value) {
        this._enum = value;
    }

    public void setAnnotation(boolean value) {
        this._annotation = value;
    }

    public void setVarArgs(boolean value) {
        this._varargs = value;
    }

    public void setBridge(boolean value) {
        this._bridge = value;
    }

    public int getValue() {
        int value = 0;
        if (this._abstract) {
            value |= 0x400;
        }
        if (this._final) {
            value |= 0x10;
        }
        if (this._native) {
            value |= 0x100;
        }
        if (this._private) {
            value |= 2;
        }
        if (this._protected) {
            value |= 4;
        }
        if (this._public) {
            value |= 1;
        }
        if (this._static) {
            value |= 8;
        }
        if (this._super) {
            value |= 0x20;
        }
        if (this._synchronized) {
            value |= 0x20;
        }
        if (this._interface) {
            value |= 0x200;
        }
        if (this._enum) {
            value |= 0x4000;
        }
        if (this._annotation) {
            value |= 0x2000;
        }
        if (this._varargs) {
            value |= 0x80;
        }
        if (this._bridge) {
            value |= 0x40;
        }
        return value;
    }
}

