/*
 * Decompiled with CFR 0.152.
 */
package net.sf.rej.gui.tab;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import net.sf.rej.files.FileSet;
import net.sf.rej.files.Project;
import net.sf.rej.gui.Link;
import net.sf.rej.gui.SystemFacade;
import net.sf.rej.gui.editor.CaseInsensitiveMatcher;
import net.sf.rej.gui.event.Event;
import net.sf.rej.gui.event.EventDispatcher;
import net.sf.rej.gui.event.EventObserver;
import net.sf.rej.gui.event.EventType;
import net.sf.rej.gui.tab.Tabbable;
import net.sf.rej.java.ClassFile;
import net.sf.rej.util.Wrapper;

public class FilesTab
extends JPanel
implements Tabbable,
EventObserver {
    DefaultMutableTreeNode root = new DefaultMutableTreeNode();
    DefaultTreeModel model = new DefaultTreeModel(this.root);
    private Project project;
    private String openFile;
    private Cursor normalCursor = null;
    private Cursor busyCursor = new Cursor(3);
    JTree contentsTree = new JTree(this.model);
    TreeCellRenderer renderer = new DefaultTreeCellRenderer(){

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Font f = this.getFont();
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            Object obj = node.getUserObject();
            if (obj instanceof Wrapper) {
                Wrapper wrapper = (Wrapper)obj;
                if (((String)wrapper.getContent()).equals(FilesTab.this.openFile)) {
                    this.setFont(f.deriveFont(1));
                } else {
                    this.setFont(f.deriveFont(0));
                }
            } else if (f != null) {
                this.setFont(f.deriveFont(0));
            }
            return super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        }
    };
    JLabel statusLabel = new JLabel();
    JLabel noFileOpenLabel = new JLabel("No file open.", 0);
    FileSet fileSet = null;
    CaseInsensitiveMatcher lastSearch = null;
    private String lastQueryString = "";
    EventDispatcher dispatcher;

    public FilesTab() {
        try {
            this.contentsTree.setCellRenderer(this.renderer);
            this.noFileOpenLabel.setFont(this.noFileOpenLabel.getFont().deriveFont(16.0f));
            this.setLayout(new BorderLayout());
            this.contentsTree.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2) {
                        FilesTab.this.selectFile();
                    }
                }
            });
            this.contentsTree.addKeyListener(new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 10) {
                        FilesTab.this.selectFile();
                    }
                }
            });
            this.statusLabel.setText("");
            this.add((Component)new JScrollPane(this.contentsTree), "Center");
            this.add((Component)this.statusLabel, "North");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getTabTitle() {
        return "Files";
    }

    public void processEvent(Event event) {
        switch (event.getType()) {
            case INIT: {
                this.dispatcher = event.getDispatcher();
                break;
            }
            case PROJECT_UPDATE: {
                this.project = event.getProject();
                break;
            }
            case CLASS_OPEN: {
                this.openFile = event.getFile();
                this.repaint();
                break;
            }
        }
        if (event.getType() == EventType.CLASS_OPEN) {
            String file = event.getFile();
            if (file == null) {
                this.statusLabel.setText("No file selected.");
            } else {
                this.statusLabel.setText("Selected file: " + file);
            }
        }
        if (event.getType() == EventType.PROJECT_UPDATE && this.project != null) {
            this.fileSet = this.project.getFileSet();
            List<String> list = this.fileSet.getContentsList();
            this.root = new DefaultMutableTreeNode(this.fileSet.getName());
            this.model.setRoot(this.root);
            TreeSet<String> pkgs = new TreeSet<String>();
            for (String contentFile : list) {
                int index = contentFile.lastIndexOf(47);
                if (index == -1) {
                    pkgs.add("");
                    continue;
                }
                pkgs.add(contentFile.substring(0, index));
            }
            HashMap<String, DefaultMutableTreeNode> map = new HashMap<String, DefaultMutableTreeNode>();
            for (String pkg : pkgs) {
                DefaultMutableTreeNode node = new DefaultMutableTreeNode(pkg);
                this.root.add(node);
                map.put(pkg, node);
            }
            TreeSet<String> contentFileSet = new TreeSet<String>(list);
            for (String contentFile : contentFileSet) {
                int index = contentFile.lastIndexOf(47);
                String pkg = "";
                if (index != -1) {
                    pkg = contentFile.substring(0, index);
                }
                DefaultMutableTreeNode pkgNode = (DefaultMutableTreeNode)map.get(pkg);
                Wrapper<String> wrapper = new Wrapper<String>();
                wrapper.setContent(contentFile);
                if (index == -1) {
                    wrapper.setDisplay(contentFile);
                } else {
                    wrapper.setDisplay(contentFile.substring(pkg.length() + 1));
                }
                DefaultMutableTreeNode fileNode = new DefaultMutableTreeNode(wrapper);
                pkgNode.add(fileNode);
            }
            this.contentsTree.expandPath(this.contentsTree.getPathForRow(0));
            if (pkgs.size() == 1) {
                this.contentsTree.expandPath(this.contentsTree.getPathForRow(1));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectFile() {
        try {
            this.normalCursor = this.getCursor();
            this.setCursor(this.busyCursor);
            TreePath path = this.contentsTree.getSelectionPath();
            DefaultMutableTreeNode node = null;
            if (path != null) {
                node = (DefaultMutableTreeNode)path.getLastPathComponent();
            }
            if (node != null && node.getUserObject() instanceof Wrapper) {
                Wrapper wrapper = (Wrapper)node.getUserObject();
                String file = (String)wrapper.getContent();
                try {
                    Event event = new Event(EventType.CLASS_OPEN);
                    ClassFile cf = this.project.getClassFile(file);
                    event.setClassFile(cf);
                    event.setFile(file);
                    this.dispatcher.notifyObservers(event);
                }
                catch (Exception ex) {
                    SystemFacade.getInstance().handleException(ex);
                    this.dispatcher.notifyObservers(new Event(EventType.CLASS_PARSE_ERROR));
                }
            }
        }
        finally {
            this.setCursor(this.normalCursor);
        }
    }

    public void redo() {
        SystemFacade.getInstance().performProjectRedo();
    }

    public void undo() {
        SystemFacade.getInstance().performProjectUndo();
    }

    public void insert() {
    }

    public void remove() {
        TreePath[] tps = this.contentsTree.getSelectionPaths();
        if (tps != null) {
            ArrayList<String> fileList = new ArrayList<String>();
            for (TreePath path : tps) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
                Object obj = node.getUserObject();
                if (obj instanceof String) {
                    Enumeration<TreeNode> en = node.children();
                    while (en.hasMoreElements()) {
                        DefaultMutableTreeNode child = (DefaultMutableTreeNode)en.nextElement();
                        obj = child.getUserObject();
                        if (!(obj instanceof Wrapper)) continue;
                        Wrapper wrapper = (Wrapper)obj;
                        fileList.add((String)wrapper.getContent());
                    }
                    continue;
                }
                Wrapper wrapper = (Wrapper)obj;
                fileList.add((String)wrapper.getContent());
            }
            if (fileList.size() > 0) {
                SystemFacade.getInstance().removeFile(fileList);
            }
        }
    }

    public void goTo(Link link) {
    }

    public void find() {
        String query = (String)JOptionPane.showInputDialog(this, "Search for..", "Search", 3, null, null, this.lastQueryString);
        if (query == null) {
            return;
        }
        this.lastQueryString = query;
        this.lastSearch = new CaseInsensitiveMatcher(query);
        Enumeration<TreeNode> en = this.root.breadthFirstEnumeration();
        while (en.hasMoreElements()) {
            Wrapper wrapper;
            String filename;
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)en.nextElement();
            Object obj = node.getUserObject();
            if (!(obj instanceof Wrapper) || !this.lastSearch.matches(filename = (String)(wrapper = (Wrapper)obj).getContent())) continue;
            Object[] path = new Object[]{this.root, node.getParent(), node};
            TreePath tp = new TreePath(path);
            this.contentsTree.setSelectionPath(tp);
            this.contentsTree.startEditingAtPath(tp);
            SystemFacade.getInstance().setStatus("Found '" + query + "'.");
            return;
        }
        this.lastSearch = null;
        SystemFacade.getInstance().setStatus("No occurances of '" + query + "' found.");
    }

    public void findNext() {
        if (this.lastSearch == null) {
            this.find();
        } else {
            Enumeration<TreeNode> en = this.root.breadthFirstEnumeration();
            boolean startSearching = false;
            while (en.hasMoreElements()) {
                Wrapper wrapper;
                String filename;
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)en.nextElement();
                if (!startSearching) {
                    if (!node.equals(this.contentsTree.getSelectionPath().getLastPathComponent())) continue;
                    startSearching = true;
                    continue;
                }
                Object obj = node.getUserObject();
                if (!(obj instanceof Wrapper) || !this.lastSearch.matches(filename = (String)(wrapper = (Wrapper)obj).getContent())) continue;
                Object[] path = new Object[]{this.root, node.getParent(), node};
                TreePath tp = new TreePath(path);
                this.contentsTree.setSelectionPath(tp);
                this.contentsTree.startEditingAtPath(tp);
                SystemFacade.getInstance().setStatus("Found '" + this.lastQueryString + "'.");
                return;
            }
            SystemFacade.getInstance().setStatus("No more occurances of '" + this.lastQueryString + "' found.");
        }
    }

    public void outline() {
    }

    public void leavingTab() {
    }

    public void enteringTab() {
    }
}

