/*
 * Decompiled with CFR 0.152.
 */
package net.sf.rej.gui.tab;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Map;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import net.sf.rej.gui.EditorFacade;
import net.sf.rej.gui.Link;
import net.sf.rej.gui.MainWindow;
import net.sf.rej.gui.SystemFacade;
import net.sf.rej.gui.editor.BasicInfoEditor;
import net.sf.rej.gui.event.Event;
import net.sf.rej.gui.event.EventObserver;
import net.sf.rej.gui.event.EventType;
import net.sf.rej.gui.split.ConstantPoolSplitSynchronizer;
import net.sf.rej.gui.tab.Tabbable;
import net.sf.rej.java.ClassFile;
import net.sf.rej.java.constantpool.ConstantPool;
import net.sf.rej.java.constantpool.ConstantPoolInfo;
import net.sf.rej.java.constantpool.DoubleInfo;
import net.sf.rej.java.constantpool.FloatInfo;
import net.sf.rej.java.constantpool.IntegerInfo;
import net.sf.rej.java.constantpool.LongInfo;
import net.sf.rej.java.constantpool.StringInfo;
import net.sf.rej.java.constantpool.UTF8Info;
import net.sf.rej.util.Range;
import net.sf.rej.util.Wrapper;

public class ConstantPoolTab
extends JPanel
implements Tabbable,
EventObserver {
    public static final long serialVersionUID = 1L;
    private ClassFile cf = null;
    private boolean isOpen = false;
    private boolean upToDate = false;
    private ConstantPoolSplitSynchronizer sync;
    private Map<Object, Range> offsets;
    DefaultTableModel model = new DefaultTableModel(){

        public boolean isCellEditable(int row, int col) {
            return false;
        }
    };
    JTable table = new JTable(this.model);
    private static final Object[] HEADERS = new Object[]{"Id", "Type", "Value"};

    public ConstantPoolTab() {
        this.setLayout(new BorderLayout());
        JScrollPane scrollPane = new JScrollPane(this.table);
        this.add((Component)scrollPane, "Center");
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                ConstantPoolTab.this.splitSynchronize();
            }
        });
        this.table.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent me) {
                Object obj = ConstantPoolTab.this.table.getValueAt(ConstantPoolTab.this.table.getSelectedRow(), 2);
                if (me.getClickCount() == 2 && me.getButton() == 1 && obj instanceof Wrapper) {
                    Wrapper wrapper = (Wrapper)obj;
                    ConstantPoolInfo cpi = (ConstantPoolInfo)wrapper.getContent();
                    ConstantPoolTab.this.launchEditor(cpi);
                } else if (me.getButton() == 3) {
                    // empty if block
                }
            }
        });
    }

    public void launchEditor(final ConstantPoolInfo cpi) {
        if (cpi.getType() == 7) {
            // empty if block
        }
        BasicInfoEditor bie = new BasicInfoEditor(MainWindow.getInstance()){

            public void validate(String value) throws BasicInfoEditor.ValidationException {
                ConstantPoolTab.this.validateAndStore(cpi, value);
            }
        };
        switch (cpi.getType()) {
            case 1: {
                bie.invoke("Edit UTF-8 Info", cpi.getValue());
                break;
            }
            case 6: {
                DoubleInfo di = (DoubleInfo)cpi;
                bie.invoke("Edit Double Info", String.valueOf(di.getDoubleValue()));
                break;
            }
            case 4: {
                FloatInfo fi = (FloatInfo)cpi;
                bie.invoke("Edit Float Info", String.valueOf(fi.getFloatValue()));
                break;
            }
            case 3: {
                IntegerInfo ii = (IntegerInfo)cpi;
                bie.invoke("Edit Integer Info", String.valueOf(ii.getIntValue()));
                break;
            }
            case 5: {
                LongInfo li = (LongInfo)cpi;
                bie.invoke("Edit Long Info", String.valueOf(li.getLongValue()));
                break;
            }
            case 8: {
                StringInfo si = (StringInfo)cpi;
                bie.invoke("Edit String Info", si.getStringValue());
            }
        }
    }

    public void processEvent(Event event) {
        if (event.getType() == EventType.CLASS_PARSE_ERROR) {
            this.model.setRowCount(0);
            this.model.setColumnCount(0);
            this.cf = null;
        }
        if (event.getType() == EventType.CLASS_OPEN || event.getType() == EventType.CLASS_REPARSE) {
            if (event.getClassFile() == null) {
                this.model.setRowCount(0);
                this.model.setColumnCount(0);
                this.cf = null;
            } else {
                this.cf = event.getClassFile();
                this.model.setColumnCount(3);
                this.model.setColumnIdentifiers(HEADERS);
            }
        }
        if (event.getType() == EventType.CLASS_OPEN || event.getType() == EventType.CLASS_UPDATE || event.getType() == EventType.CLASS_REPARSE) {
            if (this.cf != null) {
                Range constantPoolRange = this.cf.getOffsetMap().get((Object)ClassFile.OffsetTag.CONSTANT_POOL);
                this.offsets = this.cf.getPool().getOffsetMap(constantPoolRange.getOffset());
                if (this.sync != null) {
                    this.sync.setOffsets(this.offsets);
                }
            }
            this.upToDate = false;
            if (this.isOpen) {
                this.refresh();
            }
        }
        if (event.getType() == EventType.CLASS_OPEN) {
            this.table.scrollRectToVisible(new Rectangle(0, 0, 1, 1));
        }
    }

    public void refresh() {
        try {
            if (this.cf != null) {
                ConstantPool cp = this.cf.getPool();
                this.model.setRowCount(cp.size());
                int i = 0;
                for (ConstantPoolInfo cpi : cp) {
                    this.model.setValueAt(String.valueOf(i), i, 0);
                    Wrapper<ConstantPoolInfo> wrapper = new Wrapper<ConstantPoolInfo>();
                    wrapper.setContent(cpi);
                    if (cpi == null) {
                        this.model.setValueAt("", i, 1);
                        this.model.setValueAt("[empty]", i, 2);
                    } else {
                        this.model.setValueAt(cpi.getTypeString(), i, 1);
                        wrapper.setDisplay(cpi.getValue());
                        this.model.setValueAt(wrapper, i, 2);
                    }
                    ++i;
                }
                this.table.getColumnModel().getColumn(0).setMaxWidth(50);
                this.table.getColumnModel().getColumn(0).setMinWidth(50);
                this.table.getColumnModel().getColumn(1).setMaxWidth(130);
                this.table.getColumnModel().getColumn(1).setMinWidth(130);
            }
        }
        catch (Exception e) {
            SystemFacade.getInstance().handleException(e);
        }
        this.upToDate = true;
    }

    public String getTabTitle() {
        return "Constant Pool";
    }

    public void find() {
    }

    public void findNext() {
    }

    public void goTo(Link link) {
    }

    public void insert() {
        int selection = JOptionPane.showOptionDialog(this, "Insert constant..", "Insert constant..", 2, 1, null, new String[]{"String", "Integer", "Long", "Float", "Double"}, "String");
        switch (selection) {
            case -1: {
                break;
            }
            case 0: {
                BasicInfoEditor bie = new BasicInfoEditor(MainWindow.getInstance()){

                    public void validate(String value) throws BasicInfoEditor.ValidationException {
                        ConstantPoolTab.this.validateAndInsertStringInfo(value);
                    }
                };
                bie.invoke("Insert String Constant", "");
                break;
            }
            case 1: {
                BasicInfoEditor bie = new BasicInfoEditor(MainWindow.getInstance()){

                    public void validate(String value) throws BasicInfoEditor.ValidationException {
                        ConstantPoolTab.this.validateAndInsertIntegerInfo(value);
                    }
                };
                bie.invoke("Insert Integer Constant", "");
                break;
            }
            case 2: {
                BasicInfoEditor bie = new BasicInfoEditor(MainWindow.getInstance()){

                    public void validate(String value) throws BasicInfoEditor.ValidationException {
                        ConstantPoolTab.this.validateAndInsertLongInfo(value);
                    }
                };
                bie.invoke("Insert Integer Constant", "");
                break;
            }
            case 3: {
                BasicInfoEditor bie = new BasicInfoEditor(MainWindow.getInstance()){

                    public void validate(String value) throws BasicInfoEditor.ValidationException {
                        ConstantPoolTab.this.validateAndInsertFloatInfo(value);
                    }
                };
                bie.invoke("Insert Integer Constant", "");
                break;
            }
            case 4: {
                BasicInfoEditor bie = new BasicInfoEditor(MainWindow.getInstance()){

                    public void validate(String value) throws BasicInfoEditor.ValidationException {
                        ConstantPoolTab.this.validateAndInsertDoubleInfo(value);
                    }
                };
                bie.invoke("Insert Integer Constant", "");
                break;
            }
            default: {
                throw new RuntimeException("To be implemented");
            }
        }
    }

    public void remove() {
        if (this.table.getSelectedRow() == this.table.getRowCount() - 1) {
            EditorFacade.getInstance().removeLastConstantPoolItem(this.cf.getPool());
        } else {
            SystemFacade.getInstance().setStatus("Only last item of the pool may be removed.");
        }
    }

    public void redo() {
        EditorFacade.getInstance().performRedo();
    }

    public void undo() {
        EditorFacade.getInstance().performUndo();
    }

    void validateAndInsertStringInfo(String str) throws BasicInfoEditor.ValidationException {
        try {
            EditorFacade.getInstance().addStringInfo(this.cf.getPool(), str);
        }
        catch (Exception e) {
            throw new BasicInfoEditor.ValidationException(e.getMessage());
        }
    }

    void validateAndInsertLongInfo(String str) throws BasicInfoEditor.ValidationException {
        try {
            long l = Long.parseLong(str);
            EditorFacade.getInstance().addConstantPoolInfo(this.cf.getPool(), new LongInfo(l, this.cf.getPool()));
        }
        catch (Exception e) {
            throw new BasicInfoEditor.ValidationException(e.getMessage());
        }
    }

    void validateAndInsertFloatInfo(String str) throws BasicInfoEditor.ValidationException {
        try {
            float f = Float.parseFloat(str);
            EditorFacade.getInstance().addConstantPoolInfo(this.cf.getPool(), new FloatInfo(f, this.cf.getPool()));
        }
        catch (Exception e) {
            throw new BasicInfoEditor.ValidationException(e.getMessage());
        }
    }

    void validateAndInsertDoubleInfo(String str) throws BasicInfoEditor.ValidationException {
        try {
            double d = Double.parseDouble(str);
            EditorFacade.getInstance().addConstantPoolInfo(this.cf.getPool(), new DoubleInfo(d, this.cf.getPool()));
        }
        catch (Exception e) {
            throw new BasicInfoEditor.ValidationException(e.getMessage());
        }
    }

    void validateAndInsertIntegerInfo(String str) throws BasicInfoEditor.ValidationException {
        try {
            int i = Integer.parseInt(str);
            EditorFacade.getInstance().addConstantPoolInfo(this.cf.getPool(), new IntegerInfo(i, this.cf.getPool()));
        }
        catch (Exception e) {
            throw new BasicInfoEditor.ValidationException(e.getMessage());
        }
    }

    void validateAndStore(ConstantPoolInfo cpi, String newValue) throws BasicInfoEditor.ValidationException {
        switch (cpi.getType()) {
            case 1: {
                UTF8Info info = (UTF8Info)cpi;
                EditorFacade.getInstance().modifyUTF8Info(info, newValue);
                break;
            }
            case 6: {
                DoubleInfo info = (DoubleInfo)cpi;
                double d = 0.0;
                try {
                    d = Double.parseDouble(newValue);
                }
                catch (NumberFormatException nfe) {
                    throw new BasicInfoEditor.ValidationException("Not a valid double. (" + nfe.getMessage() + ")");
                }
                EditorFacade.getInstance().modifyDoubleInfo(info, d);
                break;
            }
            case 4: {
                FloatInfo info = (FloatInfo)cpi;
                float f = 0.0f;
                try {
                    f = Float.parseFloat(newValue);
                }
                catch (NumberFormatException nfe) {
                    throw new BasicInfoEditor.ValidationException("Not a valid float. (" + nfe.getMessage() + ")");
                }
                EditorFacade.getInstance().modifyFloatInfo(info, f);
                break;
            }
            case 3: {
                IntegerInfo info = (IntegerInfo)cpi;
                int i = 0;
                try {
                    i = Integer.parseInt(newValue);
                }
                catch (NumberFormatException nfe) {
                    throw new BasicInfoEditor.ValidationException("Not a valid integer. (" + nfe.getMessage() + ")");
                }
                EditorFacade.getInstance().modifyIntegerInfo(info, i);
                break;
            }
            case 5: {
                LongInfo info = (LongInfo)cpi;
                long l = 0L;
                try {
                    l = Long.parseLong(newValue);
                }
                catch (NumberFormatException nfe) {
                    throw new BasicInfoEditor.ValidationException("Not a valid long. (" + nfe.getMessage() + ")");
                }
                EditorFacade.getInstance().modifyLongInfo(info, l);
                break;
            }
            case 8: {
                StringInfo info = (StringInfo)cpi;
                int answer = JOptionPane.showOptionDialog(this, "Modify underlying UTF-8 info or create a new one.", "Modify String Info item", 1, 3, null, new String[]{"Modify", "Create new", "Cancel"}, "Modify");
                if (answer == 0) {
                    UTF8Info ui = info.getUTF8Info();
                    EditorFacade.getInstance().modifyUTF8Info(ui, newValue);
                    break;
                }
                if (answer != 1) break;
                EditorFacade.getInstance().modifyStringInfo(info, newValue);
            }
        }
    }

    public void outline() {
    }

    public void leavingTab() {
        this.isOpen = false;
    }

    public void enteringTab() {
        this.isOpen = true;
        if (!this.upToDate) {
            this.refresh();
        }
        this.splitSynchronize();
    }

    public void setSplitSynchronizer(ConstantPoolSplitSynchronizer sync) {
        this.sync = sync;
        this.sync.setOffsets(this.offsets);
        this.splitSynchronize();
    }

    public ConstantPoolInfo getSelectedObject() {
        int selectedRow = this.table.getSelectedRow();
        if (selectedRow == -1) {
            return null;
        }
        Object obj = this.table.getValueAt(selectedRow, 2);
        if (obj instanceof Wrapper) {
            Wrapper wrapper = (Wrapper)obj;
            return (ConstantPoolInfo)wrapper.getContent();
        }
        return null;
    }

    private void splitSynchronize() {
        if (this.sync != null && this.isOpen) {
            ConstantPoolInfo cpi = this.getSelectedObject();
            this.sync.sync(cpi);
        }
    }
}

