/*
 * Decompiled with CFR 0.152.
 */
package net.sf.rej.gui.structure;

import java.util.ArrayList;
import java.util.List;
import net.sf.rej.gui.structure.AttributesNode;
import net.sf.rej.gui.structure.MethodAccessFlagsNode;
import net.sf.rej.gui.structure.MethodDescriptorNode;
import net.sf.rej.gui.structure.MethodNameNode;
import net.sf.rej.gui.structure.StructureNode;
import net.sf.rej.java.ClassFile;
import net.sf.rej.java.Method;

public class MethodNode
extends StructureNode {
    private Method method;
    private List<StructureNode> contents;

    public MethodNode(ClassFile cf, Method method) {
        this.method = method;
        this.refresh();
    }

    public String toString() {
        return this.method.getSignatureLine();
    }

    public List getChildren() {
        return this.contents;
    }

    public void refresh() {
        this.contents = new ArrayList<StructureNode>();
        this.contents.add(new MethodAccessFlagsNode(this.method));
        this.contents.add(new MethodNameNode(this.method));
        this.contents.add(new MethodDescriptorNode(this.method));
        this.contents.add(new AttributesNode(this.method.getAttributes()));
        for (StructureNode child : this.contents) {
            child.setParent(this);
        }
    }

    public Method getMethod() {
        return this.method;
    }
}

