/*
 * Decompiled with CFR 0.152.
 */
package net.sf.rej.gui.structure;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import net.sf.rej.gui.MainWindow;
import net.sf.rej.gui.SystemFacade;
import net.sf.rej.gui.action.ModifyAttributeDataAction;
import net.sf.rej.gui.hexeditor.ByteArrayDataProvider;
import net.sf.rej.gui.hexeditor.DataProvider;
import net.sf.rej.gui.hexeditor.HexEditorDialog;
import net.sf.rej.gui.structure.AttributesNode;
import net.sf.rej.gui.structure.StructureNode;
import net.sf.rej.java.attribute.Attribute;
import net.sf.rej.java.attribute.Attributes;
import net.sf.rej.java.attribute.CodeAttribute;

public class AttributeNode
extends StructureNode {
    private Attribute attribute;
    private List<AttributesNode> subs;
    private Action hexEditAction = new AbstractAction("Edit attribute data.."){
        byte[] data;

        public void actionPerformed(ActionEvent e) {
            this.data = AttributeNode.this.attribute.getPayload();
            ByteArrayDataProvider badp = new ByteArrayDataProvider(this.data);
            HexEditorDialog dlg = new HexEditorDialog((Frame)MainWindow.getInstance(), (DataProvider)badp, 8, false);
            boolean cancelled = dlg.invoke();
            if (!cancelled) {
                SystemFacade.getInstance().performAction(new ModifyAttributeDataAction(AttributeNode.this.attribute, this.data));
            }
        }
    };

    public AttributeNode(Attributes attributes, Attribute attr) {
        this.attribute = attr;
        this.refresh();
    }

    public String toString() {
        return this.attribute.toString();
    }

    public List getChildren() {
        return this.subs;
    }

    public void refresh() {
        this.subs = new ArrayList<AttributesNode>();
        if (this.attribute instanceof CodeAttribute) {
            CodeAttribute ca = (CodeAttribute)this.attribute;
            Attributes attrs = ca.getAttributes();
            AttributesNode attrsNode = new AttributesNode(attrs);
            attrsNode.setParent(this);
            this.subs.add(attrsNode);
        }
    }

    public JPopupMenu getContextMenu() {
        JPopupMenu contextMenu = new JPopupMenu();
        contextMenu.add(new JMenuItem(this.hexEditAction));
        return contextMenu;
    }

    public Attribute getAttributeObject() {
        return this.attribute;
    }
}

