/*
 * Decompiled with CFR 0.152.
 */
package net.sf.rej.gui.preferences;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.rej.gui.preferences.Settings;
import net.sf.rej.gui.tab.Tab;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Preferences {
    private File preferencesFile;
    private List<File> classPath = new ArrayList<File>();
    private Map<Tab, Boolean> tabStates = new HashMap<Tab, Boolean>();
    private Map<Settings, Object> settings = new HashMap<Settings, Object>();

    public Preferences() {
        this.setDefaultSettings();
    }

    private void setDefaultSettings() {
        this.settings.put(Settings.DISPLAY_EXTENDS_OBJECT, Boolean.FALSE);
        this.settings.put(Settings.DISPLAY_GENERICS, Boolean.TRUE);
        this.settings.put(Settings.DISPLAY_VARARGS, Boolean.TRUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() throws IOException, ClassNotFoundException {
        if (this.preferencesFile.exists()) {
            FileInputStream fis = new FileInputStream(this.preferencesFile);
            ObjectInputStream ois = new ObjectInputStream(fis);
            try {
                this.classPath = (List)this.eofAwareReadObject(ois, "Classpath elements");
                this.tabStates = (Map)this.eofAwareReadObject(ois, "Tab visibility states");
                Map savedSettings = (Map)this.eofAwareReadObject(ois, "Settings");
                this.settings.putAll(savedSettings);
            }
            finally {
                ois.close();
                fis.close();
            }
        }
    }

    private Object eofAwareReadObject(ObjectInputStream ois, String descriptiveName) throws IOException, ClassNotFoundException {
        try {
            return ois.readObject();
        }
        catch (EOFException eof) {
            throw new RuntimeException("EOF on preferences file, element: " + descriptiveName + ".", eof);
        }
    }

    public void setFile(File prefs) {
        this.preferencesFile = prefs;
    }

    public void save() throws IOException {
        FileOutputStream fos = new FileOutputStream(this.preferencesFile);
        ObjectOutputStream oos = new ObjectOutputStream(fos);
        oos.writeObject(this.classPath);
        oos.writeObject(this.tabStates);
        oos.writeObject(this.settings);
        oos.close();
        fos.close();
    }

    public List<File> getClassPathList() {
        return this.classPath;
    }

    public void setClassPathList(List<File> classPath) {
        this.classPath = classPath;
    }

    public boolean isTabVisible(Tab tab) {
        Boolean visible = this.tabStates.get((Object)tab);
        return visible != null && visible != false;
    }

    public void setTabVisibility(Tab tab, boolean visible) {
        this.tabStates.put(tab, visible);
    }

    public <T> T getSetting(Settings setting, Class<T> type) {
        Object o = this.settings.get((Object)setting);
        return type.cast(o);
    }

    public boolean isSettingTrue(Settings setting) {
        return this.getSetting(setting, Boolean.class);
    }

    public void setSetting(Settings setting, Boolean value) {
        this.settings.put(setting, value);
    }

    public void invertSetting(Settings setting) {
        boolean oldValue = this.getSetting(setting, Boolean.class);
        this.setSetting(setting, !oldValue);
    }
}

