/*
 * Decompiled with CFR 0.152.
 */
package net.sf.rej.gui.hexeditor;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JList;
import net.sf.rej.gui.hexeditor.HexEditorCellRenderer;
import net.sf.rej.gui.hexeditor.SelectionModel;

public class HexEditorMouseListener
implements MouseListener {
    private SelectionModel selectionModel;
    private HexEditorCellRenderer renderer;
    private int width;

    public HexEditorMouseListener(SelectionModel selectionModel, HexEditorCellRenderer renderer) {
        this.selectionModel = selectionModel;
        this.renderer = renderer;
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        JList list = (JList)e.getComponent();
        int clickedIndex = list.locationToIndex(e.getPoint());
        int index = this.renderer.getIndex(clickedIndex, e);
        this.selectionModel.setSelectedIndex(index);
        list.setSelectedIndex(index / this.width);
        list.ensureIndexIsVisible(index / this.width);
        list.repaint();
        e.consume();
    }

    public void mouseReleased(MouseEvent e) {
        JList list = (JList)e.getComponent();
        int clickedIndex = list.locationToIndex(e.getPoint());
        int index = this.renderer.getIndex(clickedIndex, e);
        this.selectionModel.setSelectedIndex(index);
        list.setSelectedIndex(index / this.width);
        list.ensureIndexIsVisible(index / this.width);
        list.repaint();
        e.consume();
    }

    public void setWidth(int width) {
        this.width = width;
    }
}

