/*
 * Decompiled with CFR 0.152.
 */
package net.sf.rej.gui.editor.transfer;

import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import net.sf.rej.gui.editor.transfer.TransferComponent;

public class BytecodeEditorTransferHandler
extends TransferHandler {
    DataFlavor plainFlavor;
    DataFlavor htmlFlavor;
    DataFlavor objectFlavor;
    DataFlavor[] flavors = null;
    TransferComponent transferComponent;
    String plainSelection = "";
    String htmlSelection = "";
    Object data;
    private Transferable transferable = new Transferable(){

        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (flavor.equals(BytecodeEditorTransferHandler.this.plainFlavor)) {
                return new ByteArrayInputStream(BytecodeEditorTransferHandler.this.plainSelection.getBytes(flavor.getParameter("charset")));
            }
            if (flavor.equals(BytecodeEditorTransferHandler.this.htmlFlavor)) {
                return BytecodeEditorTransferHandler.this.htmlSelection;
            }
            if (flavor.equals(BytecodeEditorTransferHandler.this.objectFlavor)) {
                return BytecodeEditorTransferHandler.this.data;
            }
            throw new AssertionError((Object)("Invalid flavor: " + flavor));
        }

        public DataFlavor[] getTransferDataFlavors() {
            return BytecodeEditorTransferHandler.this.flavors;
        }

        public boolean isDataFlavorSupported(DataFlavor flavor) {
            for (DataFlavor df : BytecodeEditorTransferHandler.this.flavors) {
                if (!df.equals(flavor)) continue;
                return true;
            }
            return false;
        }
    };

    public BytecodeEditorTransferHandler(TransferComponent transferComponent) {
        this.transferComponent = transferComponent;
        try {
            this.plainFlavor = DataFlavor.getTextPlainUnicodeFlavor();
            this.htmlFlavor = new DataFlavor("text/html; class=java.lang.String", "Rich text (HTML");
            this.objectFlavor = new DataFlavor(Object.class, "Special transfer object(s)");
            this.flavors = new DataFlavor[]{this.plainFlavor, this.htmlFlavor, this.objectFlavor};
        }
        catch (Exception cnfe) {
            cnfe.printStackTrace();
        }
    }

    public void exportToClipboard(JComponent comp, Clipboard clip, int action) throws IllegalStateException {
        this.plainSelection = this.transferComponent.getSelectionPlainText();
        this.htmlSelection = this.transferComponent.getSelectionHTML();
        this.data = this.transferComponent.getSelectionObject();
        clip.setContents(this.transferable, null);
    }

    public boolean importData(JComponent comp, Transferable t) {
        try {
            Object data = t.getTransferData(this.objectFlavor);
            if (data != null) {
                this.transferComponent.pasteRows(data);
                return true;
            }
        }
        catch (UnsupportedFlavorException e) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }
}

