/*
 * Decompiled with CFR 0.152.
 */
package net.sf.rej.gui.editor.row;

import net.sf.rej.gui.editor.Breakpoint;
import net.sf.rej.gui.editor.row.EditorRow;
import net.sf.rej.gui.editor.row.MethodDefRow;
import net.sf.rej.java.ClassFile;
import net.sf.rej.java.Code;
import net.sf.rej.java.instruction.DecompilationContext;
import net.sf.rej.java.instruction.Instruction;

public class CodeRow
implements EditorRow {
    private MethodDefRow method;
    private Instruction instruction;
    private int pos = 0;
    private Integer lineNumber = null;
    private DecompilationContext dc;
    private Code code = null;
    private Breakpoint breakpoint = null;
    private boolean executionRow = false;

    public CodeRow(ClassFile cf, MethodDefRow method, Instruction instruction) {
        this.method = method;
        this.instruction = instruction;
    }

    public void setPosition(int pos) {
        this.pos = pos;
    }

    public void setLineNumber(int ln) {
        this.lineNumber = ln;
    }

    public Instruction getInstruction() {
        return this.instruction;
    }

    public int getPosition() {
        return this.pos;
    }

    public int getLineNumber() {
        if (this.hasLineNumber()) {
            return this.lineNumber;
        }
        return -1;
    }

    public boolean hasLineNumber() {
        return this.lineNumber != null;
    }

    public void setDecompilationContext(DecompilationContext dc) {
        this.dc = dc;
    }

    public DecompilationContext getDecompilationContext() {
        return this.dc;
    }

    public void setParentCode(Code code) {
        this.code = code;
    }

    public Code getParentCode() {
        return this.code;
    }

    public MethodDefRow getEnclosingMethodDef() {
        return this.method;
    }

    public Breakpoint getBreakpoint() {
        return this.breakpoint;
    }

    public void setBreakpoint(Breakpoint bp) {
        this.breakpoint = bp;
    }

    public void setExecutionRow(boolean executionRow) {
        this.executionRow = executionRow;
    }

    public boolean isExecutionRow() {
        return this.executionRow;
    }
}

