/*
 * Decompiled with CFR 0.152.
 */
package net.sf.rej.gui.editor.rendering;

import java.awt.Color;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import net.sf.rej.Imports;
import net.sf.rej.gui.ConstantPoolTranslationMode;
import net.sf.rej.gui.EditorFacade;
import net.sf.rej.gui.SystemFacade;
import net.sf.rej.gui.editor.LineIdentifierMode;
import net.sf.rej.gui.editor.rendering.JavaBytecodeSyntaxDrawer;
import net.sf.rej.gui.editor.row.ClassAnnotationDefRow;
import net.sf.rej.gui.editor.row.ClassCommentRow;
import net.sf.rej.gui.editor.row.ClassDefRow;
import net.sf.rej.gui.editor.row.CodeRow;
import net.sf.rej.gui.editor.row.DeprecatedAnnotationDefRow;
import net.sf.rej.gui.editor.row.EditorRow;
import net.sf.rej.gui.editor.row.FieldAnnotationDefRow;
import net.sf.rej.gui.editor.row.FieldDefRow;
import net.sf.rej.gui.editor.row.ImportDefRow;
import net.sf.rej.gui.editor.row.LabelRow;
import net.sf.rej.gui.editor.row.LocalVariableDefRow;
import net.sf.rej.gui.editor.row.MethodAnnotationDefRow;
import net.sf.rej.gui.editor.row.MethodDefRow;
import net.sf.rej.gui.editor.row.PackageDefRow;
import net.sf.rej.gui.preferences.Settings;
import net.sf.rej.java.AccessFlags;
import net.sf.rej.java.ClassFile;
import net.sf.rej.java.Descriptor;
import net.sf.rej.java.Field;
import net.sf.rej.java.Interface;
import net.sf.rej.java.JavaType;
import net.sf.rej.java.LocalVariable;
import net.sf.rej.java.Method;
import net.sf.rej.java.attribute.CodeAttribute;
import net.sf.rej.java.attribute.ExceptionDescriptor;
import net.sf.rej.java.attribute.LocalVariableTableAttribute;
import net.sf.rej.java.attribute.SignatureAttribute;
import net.sf.rej.java.attribute.annotations.Annotation;
import net.sf.rej.java.attribute.annotations.ArrayValue;
import net.sf.rej.java.attribute.annotations.ClassInfoValue;
import net.sf.rej.java.attribute.annotations.ConstantValue;
import net.sf.rej.java.attribute.annotations.ElementValue;
import net.sf.rej.java.attribute.annotations.EnumValue;
import net.sf.rej.java.attribute.annotations.NestedAnnotationValue;
import net.sf.rej.java.attribute.generics.Any;
import net.sf.rej.java.attribute.generics.BoundTypeArgument;
import net.sf.rej.java.attribute.generics.ClassSignature;
import net.sf.rej.java.attribute.generics.FieldSignature;
import net.sf.rej.java.attribute.generics.FormalTypeParameter;
import net.sf.rej.java.attribute.generics.GenericJavaType;
import net.sf.rej.java.attribute.generics.MethodSignature;
import net.sf.rej.java.attribute.generics.Signatures;
import net.sf.rej.java.attribute.generics.TypeArgument;
import net.sf.rej.java.constantpool.ClassInfo;
import net.sf.rej.java.constantpool.ConstantPool;
import net.sf.rej.java.constantpool.ConstantPoolInfo;
import net.sf.rej.java.constantpool.DoubleInfo;
import net.sf.rej.java.constantpool.FloatInfo;
import net.sf.rej.java.constantpool.IntegerInfo;
import net.sf.rej.java.constantpool.LongInfo;
import net.sf.rej.java.constantpool.RefInfo;
import net.sf.rej.java.constantpool.StringInfo;
import net.sf.rej.java.constantpool.UTF8Info;
import net.sf.rej.java.instruction.DecompilationContext;
import net.sf.rej.java.instruction.Instruction;
import net.sf.rej.java.instruction.Label;
import net.sf.rej.java.instruction.Parameters;
import net.sf.rej.java.instruction._newarray;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BytecodeRenderer {
    private static final Logger logger = Logger.getLogger(BytecodeRenderer.class.getName());

    public void render(EditorRow er, JavaBytecodeSyntaxDrawer sd, Imports ia) {
        if (er instanceof PackageDefRow) {
            PackageDefRow pdr = (PackageDefRow)er;
            if (pdr.getPackage().equals("")) {
                sd.drawComment("// Class is in the default package.");
            } else {
                sd.drawKeyword("package ");
                sd.drawDefault(pdr.getPackage() + ";");
            }
        } else if (er instanceof ImportDefRow) {
            ImportDefRow idr = (ImportDefRow)er;
            sd.drawKeyword("import ");
            sd.drawDefault(idr.getImport() + ";");
        } else if (er instanceof ClassCommentRow) {
            ClassCommentRow ccr = (ClassCommentRow)er;
            sd.drawComment("// ");
            sd.drawComment(ccr.getComment());
        } else if (er instanceof ClassDefRow) {
            ClassDefRow cdr = (ClassDefRow)er;
            if (cdr.isClosing()) {
                sd.drawDefault("}");
            } else {
                List<Interface> interfaces;
                String access;
                SignatureAttribute signature;
                ClassFile cf = cdr.getClassFile();
                ClassSignature classSig = null;
                boolean displayGenerics = SystemFacade.getInstance().getPreferences().isSettingTrue(Settings.DISPLAY_GENERICS);
                if (displayGenerics && (signature = cf.getAttributes().getSignatureAttribute()) != null) {
                    classSig = Signatures.getClassSignature(signature.getSignatureString());
                }
                if ((access = cf.getAccessString()).length() > 0) {
                    sd.drawKeyword(access + " ");
                }
                if (AccessFlags.isEnum(cf.getAccessFlags())) {
                    sd.drawKeyword("enum ");
                } else if (AccessFlags.isAnnotation(cf.getAccessFlags())) {
                    sd.drawKeyword("@interface ");
                } else if (AccessFlags.isInterface(cf.getAccessFlags())) {
                    sd.drawKeyword("interface ");
                } else {
                    sd.drawKeyword("class ");
                }
                sd.drawDefault(cf.getShortClassName());
                String superClass = cf.getSuperClassName();
                if (classSig != null) {
                    this.renderFormalTypeParameters(sd, ia, classSig.getFormalTypeParameters());
                }
                sd.drawDefault(" ");
                if (superClass != null) {
                    boolean displayExtendsObject = SystemFacade.getInstance().getPreferences().isSettingTrue(Settings.DISPLAY_EXTENDS_OBJECT);
                    if (!superClass.equals("java.lang.Object") || displayExtendsObject) {
                        sd.drawKeyword("extends ");
                        if (classSig == null) {
                            sd.drawDefault(ia.getShortName(superClass));
                        } else {
                            this.renderGenericJavaType(sd, ia, classSig.getSuperClassSignature());
                        }
                        sd.drawDefault(" ");
                    }
                }
                if ((interfaces = cf.getInterfaces()).size() > 0) {
                    if (AccessFlags.isInterface(cf.getAccessFlags())) {
                        sd.drawKeyword("extends ");
                    } else {
                        sd.drawKeyword("implements ");
                    }
                    if (classSig == null) {
                        for (int i = 0; i < interfaces.size(); ++i) {
                            Interface interface0 = interfaces.get(i);
                            if (i > 0) {
                                sd.drawDefault(", ");
                            }
                            sd.drawDefault(ia.getShortName(interface0.getName()));
                        }
                    } else {
                        boolean first = true;
                        for (GenericJavaType intf : classSig.getSuperInterfaceSignatures()) {
                            if (first) {
                                first = false;
                            } else {
                                sd.drawDefault(", ");
                            }
                            this.renderGenericJavaType(sd, ia, intf);
                        }
                    }
                    sd.drawDefault(" ");
                }
                sd.drawDefault("{");
            }
        } else if (er instanceof FieldDefRow) {
            SignatureAttribute signature;
            FieldDefRow fdr = (FieldDefRow)er;
            Field f = fdr.getField();
            FieldSignature fieldSig = null;
            boolean displayGenerics = SystemFacade.getInstance().getPreferences().isSettingTrue(Settings.DISPLAY_GENERICS);
            if (displayGenerics && (signature = f.getAttributes().getSignatureAttribute()) != null) {
                fieldSig = Signatures.getFieldSignature(signature.getSignatureString());
            }
            sd.drawIndent();
            String access = f.getAccessString();
            if (access.length() > 0) {
                sd.drawKeyword(access + " ");
            }
            JavaType ret = f.getDescriptor().getReturn();
            if (fieldSig == null) {
                if (ret.isPrimitive()) {
                    sd.drawKeyword(ret.getType());
                } else {
                    sd.drawDefault(ia.getShortName(ret.getType()));
                }
                sd.drawDefault(ret.getDimensions());
            } else {
                this.renderGenericJavaType(sd, ia, fieldSig.getType());
            }
            sd.drawDefault(" ");
            sd.drawField(f.getName());
            ConstantPoolInfo constant = f.getConstant();
            if (constant != null) {
                sd.drawDefault(" = ");
                this.drawConstant(sd, constant);
            }
            sd.drawDefault(";");
        } else if (er instanceof DeprecatedAnnotationDefRow) {
            sd.drawIndent();
            sd.drawAnnotation("@Deprecated");
        } else if (er instanceof ClassAnnotationDefRow || er instanceof MethodAnnotationDefRow || er instanceof FieldAnnotationDefRow) {
            Annotation ann = null;
            if (er instanceof ClassAnnotationDefRow) {
                ann = ((ClassAnnotationDefRow)er).getAnnotation();
            } else if (er instanceof MethodAnnotationDefRow) {
                sd.drawIndent();
                ann = ((MethodAnnotationDefRow)er).getAnnotation();
            } else {
                sd.drawIndent();
                ann = ((FieldAnnotationDefRow)er).getAnnotation();
            }
            sd.drawAnnotation("@" + ia.getShortName(ann.getName()));
            if (ann.getElementValueCount() > 0) {
                sd.drawDefault("(");
                Map<String, ElementValue> elementValues = ann.getElementValues();
                boolean first = true;
                for (Map.Entry<String, ElementValue> entry : elementValues.entrySet()) {
                    if (!first) {
                        sd.drawDefault(", ");
                    } else {
                        first = false;
                    }
                    if (!entry.getKey().equals("value") || elementValues.size() != 1) {
                        sd.drawDefault(entry.getKey() + "=");
                    }
                    ElementValue ev = entry.getValue();
                    this.drawElementValue(sd, ev, ia);
                }
                sd.drawDefault(")");
            }
        } else if (er instanceof MethodDefRow) {
            MethodDefRow mdr = (MethodDefRow)er;
            sd.drawIndent();
            if (mdr.isClosing()) {
                sd.drawDefault("}");
            } else {
                String access;
                SignatureAttribute signature;
                Method m = mdr.getMethod();
                MethodSignature methodSig = null;
                boolean displayGenerics = SystemFacade.getInstance().getPreferences().isSettingTrue(Settings.DISPLAY_GENERICS);
                if (displayGenerics && (signature = m.getAttributes().getSignatureAttribute()) != null) {
                    methodSig = Signatures.getMethodSignature(signature.getSignatureString());
                }
                if ((access = m.getAccessString()).length() > 0) {
                    sd.drawKeyword(access + " ");
                }
                if (methodSig != null) {
                    List<FormalTypeParameter> typeParams = methodSig.getFormalTypeParameters();
                    this.renderFormalTypeParameters(sd, ia, typeParams);
                    if (typeParams != null && typeParams.size() > 0) {
                        sd.drawKeyword(" ");
                    }
                }
                JavaType ret = m.getDescriptor().getReturn();
                if (methodSig == null) {
                    if (ret.isPrimitive()) {
                        sd.drawKeyword(ret.getType());
                    } else {
                        sd.drawDefault(ia.getShortName(ret.getType()));
                    }
                    sd.drawDefault(ret.getDimensions());
                } else {
                    this.renderGenericJavaType(sd, ia, methodSig.getReturnType());
                }
                sd.drawDefault(" ");
                if (m.isDeprecated()) {
                    sd.drawDefaultOverstrike(m.getName());
                } else {
                    sd.drawDefault(m.getName());
                }
                CodeAttribute ca = m.getAttributes().getCode();
                LocalVariableTableAttribute lvs = null;
                if (ca != null) {
                    lvs = ca.getAttributes().getLocalVariableTable();
                }
                int paramLVDefOffset = 0;
                if (!AccessFlags.isStatic(m.getAccessFlags())) {
                    paramLVDefOffset = 1;
                }
                sd.drawDefault("(");
                List<JavaType> params = m.getDescriptor().getParamList();
                List<GenericJavaType> genParams = null;
                if (methodSig != null) {
                    genParams = methodSig.getParameters();
                }
                boolean displayVarargs = SystemFacade.getInstance().getPreferences().isSettingTrue(Settings.DISPLAY_VARARGS);
                for (int i = 0; i < params.size(); ++i) {
                    LocalVariable lv;
                    boolean isLastItem;
                    if (i > 0) {
                        sd.drawDefault(", ");
                    }
                    JavaType item = params.get(i);
                    boolean bl = isLastItem = i == params.size() - 1;
                    if (displayVarargs && isLastItem && AccessFlags.isVarArgs(m.getAccessFlags()) && item.getDimensionCount() > 0) {
                        item.dropDimension();
                        if (methodSig == null) {
                            if (item.isPrimitive()) {
                                sd.drawKeyword(item.getType());
                            } else {
                                sd.drawDefault(ia.getShortName(item.getType()));
                            }
                            sd.drawDefault(item.getDimensions());
                        } else {
                            GenericJavaType genType = genParams.get(i);
                            genType.getBaseType().dropDimension();
                            this.renderGenericJavaType(sd, ia, genType);
                        }
                        sd.drawDefault(" ... ");
                        lv = null;
                        if (lvs != null) {
                            lv = lvs.getLocalVariable(paramLVDefOffset + i, 0);
                        }
                        if (lv != null) {
                            sd.drawDefault(lv.getName());
                            continue;
                        }
                        sd.drawDefault("p" + i);
                        continue;
                    }
                    if (methodSig == null) {
                        if (item.isPrimitive()) {
                            sd.drawKeyword(item.getType());
                        } else {
                            sd.drawDefault(ia.getShortName(item.getType()));
                        }
                        sd.drawDefault(item.getDimensions());
                    } else {
                        this.renderGenericJavaType(sd, ia, genParams.get(i));
                    }
                    sd.drawDefault(" ");
                    lv = null;
                    if (lvs != null) {
                        lv = lvs.getLocalVariable(paramLVDefOffset + i, 0);
                    }
                    if (lv != null) {
                        sd.drawDefault(lv.getName());
                        continue;
                    }
                    sd.drawDefault("p" + i);
                }
                sd.drawDefault(")");
                List<ExceptionDescriptor> exc = m.getExceptions();
                for (int i = 0; i < exc.size(); ++i) {
                    if (i == 0) {
                        sd.drawKeyword(" throws ");
                    } else {
                        sd.drawDefault(", ");
                    }
                    sd.drawDefault(ia.getShortName(exc.get(i).getName()));
                }
                if (mdr.hasBody()) {
                    sd.drawDefault(" {");
                } else {
                    sd.drawDefault(";");
                }
            }
        } else if (er instanceof LocalVariableDefRow) {
            LocalVariableDefRow lvdr = (LocalVariableDefRow)er;
            LocalVariable lv = lvdr.getLocalVariable();
            JavaType ret = lv.getDescriptor().getReturn();
            sd.drawIndent();
            sd.drawIndent();
            if (ret.isPrimitive()) {
                sd.drawKeyword(ret.getType());
            } else {
                sd.drawDefault(ia.getShortName(ret.getType()));
            }
            sd.drawDefault(ret.getDimensions() + " " + lv.getName() + " (#" + lv.getIndex() + " " + lv.getStartPc() + " - " + lv.getEndPc() + ")");
        } else if (er instanceof LabelRow) {
            LabelRow lr = (LabelRow)er;
            sd.drawIndent();
            sd.drawIndent();
            sd.drawDefault(lr.getLabel().getId() + ":");
        } else if (er instanceof CodeRow) {
            CodeRow cr = (CodeRow)er;
            if (cr.isExecutionRow()) {
                sd.setExecutionBackground();
            }
            if (cr.getBreakpoint() != null) {
                sd.drawBreakpoint();
            }
            LineIdentifierMode mode = EditorFacade.getInstance().getLineIdentifierMode();
            switch (mode.getMode()) {
                case 0: {
                    break;
                }
                case 1: {
                    sd.drawSmall(String.valueOf(cr.getPosition()), 15);
                    break;
                }
                case 2: {
                    if (!cr.hasLineNumber()) break;
                    sd.drawSmall(String.valueOf(cr.getLineNumber()), 0);
                }
            }
            sd.setOffset(0);
            Instruction inst = cr.getInstruction();
            DecompilationContext dc = cr.getDecompilationContext();
            LocalVariableTableAttribute lvs = dc.getLocalVariableTable();
            ConstantPool pool = dc.getConstantPool();
            sd.drawIndent();
            sd.drawIndent();
            sd.drawInstruction(inst.getMnemonic());
            Parameters params = inst.getParameters();
            block23: for (int i = 0; i < params.getCount(); ++i) {
                try {
                    switch (params.getType(i)) {
                        case TYPE_LOCAL_VARIABLE: 
                        case TYPE_LOCAL_VARIABLE_WIDE: 
                        case TYPE_LOCAL_VARIABLE_READONLY: {
                            if (lvs == null) {
                                sd.drawDefault(" " + params.getInt(i));
                                break;
                            }
                            LocalVariable lv = lvs.getLocalVariable(params.getInt(i), cr.getPosition());
                            if (lv == null) {
                                sd.drawDefault(" " + params.getInt(i));
                                break;
                            }
                            sd.drawDefault(" " + lv.getName());
                            break;
                        }
                        case TYPE_CONSTANT_POOL_METHOD_REF: {
                            int index = params.getInt(i);
                            ConstantPoolInfo cpi = pool.get(index);
                            this.renderMethodRef(sd, ia, (RefInfo)cpi, index);
                            break;
                        }
                        case TYPE_CONSTANT_POOL_FIELD_REF: {
                            int index = params.getInt(i);
                            ConstantPoolInfo cpi = pool.get(index);
                            this.renderFieldRef(sd, ia, (RefInfo)cpi, index);
                            break;
                        }
                        case TYPE_CONSTANT_POOL_CLASS: {
                            int index = params.getInt(i);
                            ConstantPoolInfo cpi = pool.get(index);
                            this.renderClassRef(sd, ia, (ClassInfo)cpi, index);
                            break;
                        }
                        case TYPE_CONSTANT_POOL_CONSTANT: {
                            int index = params.getInt(i);
                            ConstantPoolInfo cpi = pool.get(index);
                            this.renderConstant(sd, cpi, index);
                            break;
                        }
                        case TYPE_LABEL: {
                            Label label = (Label)params.getObject(i);
                            sd.drawDefault(" " + label.getId());
                            break;
                        }
                        case TYPE_SWITCH: {
                            Map offsets = (Map)params.getObject(i);
                            for (Map.Entry entry : offsets.entrySet()) {
                                sd.drawDefault(" " + entry.getKey() + "=" + ((Label)entry.getValue()).getId());
                            }
                            continue block23;
                        }
                        case TYPE_CONSTANT: 
                        case TYPE_CONSTANT_READONLY: 
                        case TYPE_CONSTANT_WIDE: {
                            sd.drawDefault(" " + params.getInt(i));
                            break;
                        }
                        case TYPE_ARRAYTYPE: {
                            sd.drawDefault(" " + _newarray.getTypeName(params.getInt(i)));
                        }
                    }
                    continue;
                }
                catch (Exception ee) {
                    logger.warning("Error rendering instruction. Instruction = " + inst.getMnemonic() + " params = " + params);
                    StringWriter sw = new StringWriter();
                    ee.printStackTrace(new PrintWriter(sw));
                    logger.warning(sw.toString());
                }
            }
        }
    }

    private void renderFormalTypeParameters(JavaBytecodeSyntaxDrawer sd, Imports ia, List<FormalTypeParameter> typeParams) {
        boolean displayExtendsObject = SystemFacade.getInstance().getPreferences().isSettingTrue(Settings.DISPLAY_EXTENDS_OBJECT);
        if (typeParams != null && typeParams.size() > 0) {
            sd.drawDefault("<");
            boolean isFirstTypeParam = true;
            for (FormalTypeParameter typeParam : typeParams) {
                if (isFirstTypeParam) {
                    isFirstTypeParam = false;
                } else {
                    sd.drawDefault(", ");
                }
                sd.drawDefault(typeParam.getIdentifier());
                List<GenericJavaType> union = typeParam.getTypeUnion();
                if (union.size() == 1 && union.get(0).getBaseType().equals(JavaType.JAVA_LANG_OBJECT)) {
                    if (!displayExtendsObject) continue;
                    sd.drawKeyword(" extends ");
                    sd.drawDefault(ia.getShortName(JavaType.JAVA_LANG_OBJECT.toString()));
                    continue;
                }
                sd.drawKeyword(" extends ");
                boolean isFirstType = true;
                for (GenericJavaType gjt : union) {
                    if (isFirstType) {
                        isFirstType = false;
                    } else {
                        sd.drawDefault(" & ");
                    }
                    this.renderGenericJavaType(sd, ia, gjt);
                }
            }
            sd.drawDefault(">");
        }
    }

    private void renderGenericJavaType(JavaBytecodeSyntaxDrawer sd, Imports ia, GenericJavaType gjt) {
        JavaType baseType = gjt.getBaseType();
        if (baseType.isPrimitive()) {
            sd.drawKeyword(baseType.getType());
        } else {
            sd.drawDefault(ia.getShortName(baseType.getType()));
        }
        List<TypeArgument> typeArgs = gjt.getTypeArguments();
        if (typeArgs.size() > 0) {
            sd.drawDefault("<");
            boolean isFirstTypeArg = true;
            for (TypeArgument typeArg : typeArgs) {
                if (isFirstTypeArg) {
                    isFirstTypeArg = false;
                } else {
                    sd.drawDefault(", ");
                }
                if (typeArg instanceof GenericJavaType) {
                    this.renderGenericJavaType(sd, ia, (GenericJavaType)typeArg);
                    continue;
                }
                if (typeArg instanceof BoundTypeArgument) {
                    BoundTypeArgument bta = (BoundTypeArgument)typeArg;
                    sd.drawDefault("? ");
                    sd.drawKeyword(bta.getBoundString());
                    sd.drawDefault(" ");
                    this.renderGenericJavaType(sd, ia, bta.getBound());
                    continue;
                }
                if (typeArg instanceof Any) {
                    sd.drawDefault("?");
                    continue;
                }
                throw new AssertionError((Object)("Invalid TypeArgument : " + typeArg.getClass().getName()));
            }
            sd.drawDefault(">");
        }
        sd.drawDefault(baseType.getDimensions());
    }

    private void renderConstant(JavaBytecodeSyntaxDrawer sd, ConstantPoolInfo cpi, int index) {
        ConstantPoolTranslationMode mode = EditorFacade.getInstance().getConstantPoolTranslationMode();
        sd.drawDefault(" ");
        if (mode == ConstantPoolTranslationMode.OFF || mode == ConstantPoolTranslationMode.HYBRID) {
            sd.drawDefault("#" + index + ";");
        }
        if (mode == ConstantPoolTranslationMode.HYBRID) {
            sd.drawComment(" //");
        }
        if (mode == ConstantPoolTranslationMode.TRANSLATION || mode == ConstantPoolTranslationMode.HYBRID) {
            sd.drawDefault(cpi.getTypeString() + " ");
            this.drawConstant(sd, cpi);
        }
    }

    private void renderClassRef(JavaBytecodeSyntaxDrawer sd, Imports ia, ClassInfo ci, int index) {
        ConstantPoolTranslationMode mode = EditorFacade.getInstance().getConstantPoolTranslationMode();
        sd.drawDefault(" ");
        if (mode == ConstantPoolTranslationMode.OFF || mode == ConstantPoolTranslationMode.HYBRID) {
            sd.drawDefault("#" + index + ";");
        }
        if (mode == ConstantPoolTranslationMode.HYBRID) {
            sd.drawComment(" //");
        }
        if (mode == ConstantPoolTranslationMode.TRANSLATION || mode == ConstantPoolTranslationMode.HYBRID) {
            JavaType jt = new JavaType(ci.getName());
            sd.drawDefault(ia.getShortName(jt.getType()) + jt.getDimensions());
        }
    }

    private void renderFieldRef(JavaBytecodeSyntaxDrawer sd, Imports ia, RefInfo ri, int index) {
        ConstantPoolTranslationMode mode = EditorFacade.getInstance().getConstantPoolTranslationMode();
        sd.drawDefault(" ");
        if (mode == ConstantPoolTranslationMode.OFF || mode == ConstantPoolTranslationMode.HYBRID) {
            sd.drawDefault("#" + index + ";");
        }
        if (mode == ConstantPoolTranslationMode.HYBRID) {
            sd.drawComment(" //");
        }
        if (mode == ConstantPoolTranslationMode.TRANSLATION || mode == ConstantPoolTranslationMode.HYBRID) {
            Descriptor desc = ri.getDescriptor();
            JavaType ret = desc.getReturn();
            if (ret.isPrimitive()) {
                sd.drawKeyword(ret.getType());
            } else {
                sd.drawDefault(ia.getShortName(ret.getType()));
            }
            sd.drawDefault(ret.getDimensions() + " " + ia.getShortName(ri.getClassName()) + ".");
            sd.drawField(ri.getTargetName());
        }
    }

    private void renderMethodRef(JavaBytecodeSyntaxDrawer sd, Imports ia, RefInfo ri, int index) {
        ConstantPoolTranslationMode mode = EditorFacade.getInstance().getConstantPoolTranslationMode();
        sd.drawDefault(" ");
        if (mode == ConstantPoolTranslationMode.OFF || mode == ConstantPoolTranslationMode.HYBRID) {
            sd.drawDefault("#" + index + ";");
        }
        if (mode == ConstantPoolTranslationMode.HYBRID) {
            sd.drawComment(" //");
        }
        if (mode == ConstantPoolTranslationMode.TRANSLATION || mode == ConstantPoolTranslationMode.HYBRID) {
            Descriptor desc = ri.getDescriptor();
            JavaType ret = desc.getReturn();
            if (ret.isPrimitive()) {
                sd.drawKeyword(ret.getType());
            } else {
                sd.drawDefault(ia.getShortName(ret.getType()));
            }
            sd.drawDefault(ret.getDimensions() + " " + ia.getShortName(ri.getClassName()) + "." + ri.getTargetName());
            sd.drawDefault("(");
            List<JavaType> al = desc.getParamList();
            for (int j = 0; j < al.size(); ++j) {
                JavaType item = al.get(j);
                if (j > 0) {
                    sd.drawDefault(", ");
                }
                if (item.isPrimitive()) {
                    sd.drawKeyword(item.getType());
                } else {
                    sd.drawDefault(ia.getShortName(item.getType()));
                }
                sd.drawDefault(item.getDimensions());
            }
            sd.drawDefault(")");
        }
    }

    private void drawConstant(JavaBytecodeSyntaxDrawer sd, ConstantPoolInfo constant) {
        switch (constant.getType()) {
            case 6: {
                DoubleInfo di = (DoubleInfo)constant;
                sd.drawDefault("(");
                sd.drawKeyword("double");
                sd.drawDefault(") " + di.getDoubleValue());
                break;
            }
            case 4: {
                FloatInfo fi = (FloatInfo)constant;
                sd.drawDefault("(");
                sd.drawKeyword("float");
                sd.drawDefault(") " + fi.getFloatValue());
                break;
            }
            case 3: {
                IntegerInfo ii = (IntegerInfo)constant;
                sd.drawDefault("(");
                sd.drawKeyword("int");
                sd.drawDefault(") " + ii.getIntValue());
                break;
            }
            case 5: {
                LongInfo li = (LongInfo)constant;
                sd.drawDefault("(");
                sd.drawKeyword("long");
                sd.drawDefault(") " + li.getLongValue());
                break;
            }
            case 1: {
                UTF8Info ui = (UTF8Info)constant;
                sd.drawString("\"");
                sd.drawString(ui.getValue());
                sd.drawString("\"");
                break;
            }
            case 8: {
                StringInfo si = (StringInfo)constant;
                sd.drawString("\"");
                sd.drawString(si.getString());
                sd.drawString("\"");
            }
        }
    }

    private void drawElementValue(JavaBytecodeSyntaxDrawer sd, ElementValue ev, Imports ia) {
        if (ev instanceof ArrayValue) {
            ArrayValue av = (ArrayValue)ev;
            List<ElementValue> values = av.getArray();
            boolean first = true;
            sd.drawDefault("{");
            for (ElementValue value : values) {
                if (!first) {
                    sd.drawDefault(", ");
                } else {
                    first = false;
                }
                this.drawElementValue(sd, value, ia);
            }
            sd.drawDefault("}");
        } else if (ev instanceof ClassInfoValue) {
            sd.drawDefault(ia.getShortName(ev.getValue()));
        } else if (ev instanceof ConstantValue) {
            ConstantValue cv = (ConstantValue)ev;
            this.drawConstant(sd, cv.getConstantPoolInfo());
        } else if (ev instanceof EnumValue) {
            EnumValue en = (EnumValue)ev;
            sd.drawDefault(ia.getShortName(en.getTypeName()));
            sd.drawDefault(".");
            sd.drawField(en.getConstName());
        } else if (ev instanceof NestedAnnotationValue) {
            sd.drawDefault(ev.getValue());
        }
    }

    public Color getBackgroundColor(EditorRow er) {
        MethodDefRow mdr;
        CodeRow cr;
        if (er instanceof CodeRow ? (cr = (CodeRow)er).isExecutionRow() : er instanceof MethodDefRow && (mdr = (MethodDefRow)er).isExecutionRow()) {
            return new Color(255, 190, 190);
        }
        return Color.white;
    }
}

