/*
 * Decompiled with CFR 0.152.
 */
package net.sf.rej.gui.editor.iteration;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import net.sf.rej.gui.editor.iteration.RefactoringAdvisorAdapter;
import net.sf.rej.java.Descriptor;
import net.sf.rej.obfuscation.NameSequence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodNameLegalizingAdvisor
extends RefactoringAdvisorAdapter {
    private static final Logger logger = Logger.getLogger(MethodNameLegalizingAdvisor.class.getName());
    private static final String[] KEYWORDS = new String[]{"abstract", "continue", "for", "new", "switch", "assert", "default", "goto", "package", "synchronized", "boolean", "do", "if", "private", "this", "break", "double", "implements", "protected", "throw", "byte", "else", "import", "public", "throws", "case", "enum", "instanceof", "return", "transient", "catch", "extends", "int", "short", "try", "char", "final", "interface", "static", "void", "class", "finally", "long", "strictfp", "volatile", "const", "float", "native", "super", "while"};
    private static List<String> KEYWORDLIST = Arrays.asList(KEYWORDS);
    private List<String> classNames;
    private List<String> methodNames = new ArrayList<String>();
    private HashMap<Key, String> methodRenames = new HashMap();
    private NameSequence methodNameSequence = new NameSequence();

    public MethodNameLegalizingAdvisor(List<String> classNames) {
        this.classNames = classNames;
    }

    @Override
    public String newMethodNameFor(String className, String targetName, Descriptor desc) {
        if (this.classNames.contains(className)) {
            Key key = new Key(className, targetName, desc);
            String newMethodName = this.methodRenames.get(key);
            if (newMethodName == null) {
                if (KEYWORDLIST.contains(targetName)) {
                    newMethodName = this.getUniqueMethodName(className, desc);
                    this.methodRenames.put(key, newMethodName);
                    this.methodNames.add(className + "." + newMethodName + " " + desc.getRawParams());
                    logger.fine("Method rename (illegal name): " + targetName + " => " + newMethodName);
                } else if (this.methodNames.contains(className + "." + targetName + " " + desc.getRawParams())) {
                    newMethodName = this.getUniqueMethodName(className, desc);
                    this.methodRenames.put(key, newMethodName);
                    this.methodNames.add(className + "." + newMethodName + " " + desc.getRawParams());
                    logger.fine("Method rename (duplicate name): " + targetName + " => " + newMethodName);
                } else {
                    this.methodRenames.put(key, targetName);
                    this.methodNames.add(className + "." + targetName + " " + desc.getRawParams());
                }
                return newMethodName;
            }
            return newMethodName;
        }
        return null;
    }

    public String getUniqueMethodName(String className, Descriptor desc) {
        String candidate;
        do {
            candidate = this.methodNameSequence.getNextName();
        } while (this.methodNames.contains(className + "." + candidate + " " + desc.getRawParams()));
        return candidate;
    }

    public class Key {
        private String className;
        private String targetName;
        private Descriptor desc;

        public Key(String className, String targetName, Descriptor desc) {
            this.className = className;
            this.targetName = targetName;
            this.desc = desc;
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode += this.className.hashCode();
            hashCode *= 63;
            hashCode += this.targetName.hashCode();
            hashCode *= 63;
            return hashCode += this.desc.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Key)) {
                return false;
            }
            Key key = (Key)obj;
            return this.className.equals(key.className) && this.targetName.equals(key.targetName) && this.desc.equals(key.desc);
        }
    }
}

