/*
 * Decompiled with CFR 0.152.
 */
package net.sf.rej.gui.editor.iteration;

import net.sf.rej.gui.IterationContext;
import net.sf.rej.gui.IteratorAgentAdapter;
import net.sf.rej.gui.Link;
import net.sf.rej.gui.MainWindow;
import net.sf.rej.gui.tab.Tab;
import net.sf.rej.java.Descriptor;
import net.sf.rej.java.Field;

public class FindFieldDefinition
extends IteratorAgentAdapter {
    private int resultCount = 0;
    private String className;
    private String fieldName;
    private Descriptor desc;

    public FindFieldDefinition(String className, String fieldName, Descriptor desc) {
        this.className = className;
        this.fieldName = fieldName;
        this.desc = desc;
    }

    public void processField(IterationContext sc, Field field) {
        boolean classNamesMatch = sc.getCf().getFullClassName().equals(this.className);
        boolean methodNamesMatch = field.getName().equals(this.fieldName);
        boolean descriptorsMatch = field.getDescriptor().equals(this.desc);
        if (classNamesMatch && methodNamesMatch && descriptorsMatch) {
            Link link = new Link();
            link.setText("Field definition : " + sc.getCf().getFullClassName() + "." + field.getName());
            link.setAnchor(2);
            link.setProject(sc.getProject());
            link.setFile(sc.getFilename());
            link.setTab(Tab.EDITOR);
            link.setField(field);
            MainWindow.getInstance().getSearchTab().addResult(link);
            ++this.resultCount;
        }
    }
}

