/*
 * Decompiled with CFR 0.152.
 */
package net.sf.rej.gui.editor.iteration;

import net.sf.rej.gui.IterationContext;
import net.sf.rej.gui.IteratorAgentAdapter;
import net.sf.rej.gui.Link;
import net.sf.rej.gui.MainWindow;
import net.sf.rej.gui.tab.Tab;
import net.sf.rej.java.ClassFile;
import net.sf.rej.java.constantpool.ClassInfo;
import net.sf.rej.java.constantpool.ConstantPoolInfo;
import net.sf.rej.java.constantpool.RefInfo;
import net.sf.rej.java.instruction.Instruction;
import net.sf.rej.java.instruction.ParameterType;
import net.sf.rej.java.instruction.Parameters;

public class FindClassRefs
extends IteratorAgentAdapter {
    private int resultCount = 0;
    private String className;

    public FindClassRefs(String className) {
        this.className = className;
    }

    public void processClass(IterationContext sc, ClassFile cf) {
        boolean classNamesMatch = cf.getFullClassName().equals(this.className);
        if (classNamesMatch) {
            Link link = new Link();
            link.setText("Class definition : " + sc.getCf().getFullClassName());
            link.setAnchor(1);
            link.setProject(sc.getProject());
            link.setFile(sc.getFilename());
            link.setTab(Tab.EDITOR);
            MainWindow.getInstance().getSearchTab().addResult(link);
            ++this.resultCount;
        }
    }

    public void processInstruction(IterationContext sc, Instruction instruction) {
        Parameters params = instruction.getParameters();
        for (int i = 0; i < params.getCount(); ++i) {
            ClassInfo ci;
            Link link;
            String instructionLine;
            boolean classNamesMatch;
            RefInfo ri;
            ConstantPoolInfo cpi;
            if (params.getType(i) == ParameterType.TYPE_CONSTANT_POOL_FIELD_REF) {
                cpi = sc.getDc().getConstantPool().get(params.getInt(i));
                ri = (RefInfo)cpi;
                classNamesMatch = ri.getClassName().equals(this.className);
                if (!classNamesMatch) continue;
                instructionLine = instruction.getMnemonic() + " " + instruction.getParameters().getString(sc.getDc());
                link = new Link();
                link.setText("Field Ref : " + sc.getCf().getFullClassName() + "." + sc.getMethod().getName() + " / " + instructionLine);
                link.setAnchor(4);
                link.setProject(sc.getProject());
                link.setFile(sc.getFilename());
                link.setTab(Tab.EDITOR);
                link.setMethod(sc.getMethod());
                link.setPosition(sc.getDc().getPosition());
                MainWindow.getInstance().getSearchTab().addResult(link);
                ++this.resultCount;
                continue;
            }
            if (params.getType(i) == ParameterType.TYPE_CONSTANT_POOL_METHOD_REF) {
                cpi = sc.getDc().getConstantPool().get(params.getInt(i));
                ri = (RefInfo)cpi;
                classNamesMatch = ri.getClassName().equals(this.className);
                if (!classNamesMatch) continue;
                instructionLine = instruction.getMnemonic() + " " + instruction.getParameters().getString(sc.getDc());
                link = new Link();
                link.setText("Method Call : " + sc.getCf().getFullClassName() + "." + sc.getMethod().getName() + " / " + instructionLine);
                link.setAnchor(4);
                link.setProject(sc.getProject());
                link.setFile(sc.getFilename());
                link.setTab(Tab.EDITOR);
                link.setMethod(sc.getMethod());
                link.setPosition(sc.getDc().getPosition());
                MainWindow.getInstance().getSearchTab().addResult(link);
                ++this.resultCount;
                continue;
            }
            if (params.getType(i) != ParameterType.TYPE_CONSTANT_POOL_CLASS || !(classNamesMatch = (ci = (ClassInfo)(cpi = sc.getDc().getConstantPool().get(params.getInt(i)))).getName().equals(this.className))) continue;
            instructionLine = instruction.getMnemonic() + " " + instruction.getParameters().getString(sc.getDc());
            link = new Link();
            link.setText("Instruction : " + sc.getCf().getFullClassName() + "." + sc.getMethod().getName() + " / " + instructionLine);
            link.setAnchor(4);
            link.setProject(sc.getProject());
            link.setFile(sc.getFilename());
            link.setTab(Tab.EDITOR);
            link.setMethod(sc.getMethod());
            link.setPosition(sc.getDc().getPosition());
            MainWindow.getInstance().getSearchTab().addResult(link);
            ++this.resultCount;
        }
    }
}

