/*
 * Decompiled with CFR 0.152.
 */
package net.sf.rej.gui.editor.iteration;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import net.sf.rej.gui.editor.iteration.RefactoringAdvisorAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassNameLegalizingAdvisor
extends RefactoringAdvisorAdapter {
    private static final Logger logger = Logger.getLogger(ClassNameLegalizingAdvisor.class.getName());
    private static final String[] KEYWORDS = new String[]{"abstract", "continue", "for", "new", "switch", "assert", "default", "goto", "package", "synchronized", "boolean", "do", "if", "private", "this", "break", "double", "implements", "protected", "throw", "byte", "else", "import", "public", "throws", "case", "enum", "instanceof", "return", "transient", "catch", "extends", "int", "short", "try", "char", "final", "interface", "static", "void", "class", "finally", "long", "strictfp", "volatile", "const", "float", "native", "super", "while"};
    private static List<String> KEYWORDLIST = Arrays.asList(KEYWORDS);
    private HashMap<String, String> classRenames = new HashMap();

    public ClassNameLegalizingAdvisor(List<String> classNames) {
        for (String className : classNames) {
            String[] components = className.split("\\.");
            StringBuffer newName = new StringBuffer();
            for (String component : components) {
                if (newName.length() > 0) {
                    newName.append(".");
                }
                if (KEYWORDLIST.contains(component)) {
                    newName.append("_");
                }
                newName.append(component);
            }
            if (className.equals(newName.toString())) continue;
            this.classRenames.put(className, newName.toString());
            logger.fine("Class rename: " + className + " => " + newName);
        }
    }

    @Override
    public String newClassNameFor(String fullClassName) {
        String newClassName = this.classRenames.get(fullClassName);
        return newClassName;
    }
}

