/*
 * Decompiled with CFR 0.152.
 */
package net.sf.rej.gui.editor;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecentFiles {
    private File file;
    private Properties properties = new Properties();
    private List<String> list = new ArrayList<String>();

    public RecentFiles(File file) {
        this.file = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() throws IOException {
        FileInputStream fis = null;
        try {
            if (this.file.exists()) {
                fis = new FileInputStream(this.file);
                this.properties.load(fis);
            }
            this.list.clear();
            String file = this.properties.getProperty("recent.file.0");
            if (file != null) {
                this.list.add(file);
            }
            if ((file = this.properties.getProperty("recent.file.1")) != null) {
                this.list.add(file);
            }
            if ((file = this.properties.getProperty("recent.file.2")) != null) {
                this.list.add(file);
            }
            if ((file = this.properties.getProperty("recent.file.3")) != null) {
                this.list.add(file);
            }
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
    }

    public void serialize() throws IOException {
        FileOutputStream fos = new FileOutputStream(this.file);
        this.properties.store(fos, "Recent files list");
        fos.flush();
        fos.close();
    }

    public List<String> getList() {
        ArrayList<String> al = new ArrayList<String>();
        al.addAll(this.list);
        return al;
    }

    public void add(String file) throws IOException {
        if (this.list.contains(file)) {
            this.list.remove(file);
        }
        this.list.add(0, file);
        if (this.list.size() > 4) {
            this.list.remove(4);
        }
        this.properties.clear();
        for (int i = 0; i < 4; ++i) {
            if (this.list.size() <= i) continue;
            String f = this.list.get(i);
            this.properties.setProperty("recent.file." + i, f);
        }
        this.serialize();
    }
}

