/*
 * Decompiled with CFR 0.152.
 */
package net.sf.rej.gui.editor;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.sf.rej.Imports;
import net.sf.rej.files.ClassLocator;
import net.sf.rej.files.MethodLocator;
import net.sf.rej.gui.EditorFacade;
import net.sf.rej.gui.MainWindow;
import net.sf.rej.gui.SystemFacade;
import net.sf.rej.gui.dialog.MethodChooseDialog;
import net.sf.rej.gui.editor.LayoutChangeListener;
import net.sf.rej.java.ClassFile;
import net.sf.rej.java.Descriptor;
import net.sf.rej.java.Method;
import net.sf.rej.java.constantpool.ConstantPool;
import net.sf.rej.java.constantpool.ConstantPoolInfo;
import net.sf.rej.java.constantpool.RefInfo;
import net.sf.rej.util.Wrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodChooser
extends JPanel {
    private Action chooserAction = new AbstractAction("..."){

        public void actionPerformed(ActionEvent e) {
            Object obj = MethodChooser.this.combo.getSelectedItem();
            String className = null;
            if (obj instanceof String) {
                className = (String)obj;
            } else if (obj instanceof Wrapper) {
                Wrapper wrapper = (Wrapper)obj;
                if (wrapper.getContent() instanceof RefInfo) {
                    RefInfo ri = (RefInfo)wrapper.getContent();
                    className = ri.getClassName();
                } else {
                    MethodLocator ml = (MethodLocator)wrapper.getContent();
                    className = ml.getClassLocator().getFullName();
                }
            }
            ClassLocator cl = SystemFacade.getInstance().getClassIndex().getLocator(className);
            MethodChooseDialog mcd = new MethodChooseDialog((Frame)MainWindow.getInstance(), cl);
            mcd.invoke();
            cl = mcd.getSelectedClass();
            Method method = mcd.getSelectedMethod();
            if (cl != null && method != null) {
                Wrapper<MethodLocator> wrapper = new Wrapper<MethodLocator>();
                wrapper.setContent(new MethodLocator(cl, method));
                wrapper.setDisplay(method.getSignatureLine(cl.getFullName()));
                MethodChooser.this.model.addElement(wrapper);
                MethodChooser.this.combo.setSelectedItem(wrapper);
                if (MethodChooser.this.layoutChangeListener != null) {
                    MethodChooser.this.layoutChangeListener.layoutChanged(MethodChooser.this);
                }
            }
        }
    };
    private JLabel label = new JLabel("Method: ");
    DefaultComboBoxModel model = null;
    JComboBox combo = new JComboBox();
    private JButton button = new JButton(this.chooserAction);
    private ConstantPool cp = null;
    private ClassFile cf = null;
    private Imports imports = null;
    private LayoutChangeListener layoutChangeListener = null;

    public MethodChooser(LayoutChangeListener layoutChangeListener) {
        this.setLayout(new GridBagLayout());
        this.add((Component)this.label, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.combo, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.button, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.layoutChangeListener = layoutChangeListener;
    }

    public void setClassFile(ClassFile cf) {
        this.cf = cf;
    }

    public void setConstantPool(ConstantPool pool) {
        this.cp = pool;
        ArrayList<Wrapper<RefInfo>> al = new ArrayList<Wrapper<RefInfo>>();
        this.imports = EditorFacade.getInstance().getImports(this.cf);
        for (int i = 0; i < this.cp.size(); ++i) {
            ConstantPoolInfo cpi = this.cp.get(i);
            if (cpi == null || cpi.getType() != 11 && cpi.getType() != 10) continue;
            al.add(this.createWrapper((RefInfo)cpi));
        }
        this.model = new DefaultComboBoxModel<Object>(al.toArray());
        this.combo.setModel(this.model);
    }

    public Wrapper<RefInfo> createWrapper(RefInfo ri) {
        Wrapper<RefInfo> wrapper = new Wrapper<RefInfo>();
        wrapper.setContent(ri);
        Descriptor desc = ri.getDescriptor();
        wrapper.setDisplay(EditorFacade.getInstance().getMethodString(this.imports, desc, ri.getClassName(), ri.getTargetName()));
        return wrapper;
    }

    public Object getValue() {
        Object o = this.combo.getSelectedItem();
        int value = 0;
        if (o instanceof String) {
            throw new RuntimeException("Editing not implemented.");
        }
        Wrapper wrapper = (Wrapper)o;
        Object content = wrapper.getContent();
        if (content instanceof MethodLocator) {
            MethodLocator ml = (MethodLocator)content;
            return ml;
        }
        RefInfo ri = (RefInfo)((Wrapper)o).getContent();
        value = this.cp.optionalAdd(ri);
        return value;
    }

    public void setSelected(Object o) {
        this.combo.setSelectedItem(this.createWrapper((RefInfo)o));
    }

    public void setEditable(boolean b) {
        this.combo.setEditable(b);
    }

    public void setReadOnly() {
        this.combo.setEnabled(false);
    }
}

