/*
 * Decompiled with CFR 0.152.
 */
package net.sf.rej.gui.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.ToolTipManager;
import net.sf.rej.gui.InstructionHints;
import net.sf.rej.gui.MainWindow;
import net.sf.rej.gui.editor.ArrayTypeChooser;
import net.sf.rej.gui.editor.ClassChooser;
import net.sf.rej.gui.editor.ConstantChooser;
import net.sf.rej.gui.editor.ConstantpoolConstantChooser;
import net.sf.rej.gui.editor.FieldChooser;
import net.sf.rej.gui.editor.InstructionList;
import net.sf.rej.gui.editor.LayoutChangeListener;
import net.sf.rej.gui.editor.LocalVariableChooser;
import net.sf.rej.gui.editor.MethodChooser;
import net.sf.rej.java.ClassFile;
import net.sf.rej.java.LocalVariable;
import net.sf.rej.java.attribute.LocalVariableTableAttribute;
import net.sf.rej.java.constantpool.ConstantPool;
import net.sf.rej.java.instruction.Instruction;
import net.sf.rej.java.instruction.Parameters;

public class InstructionEditor
extends JDialog
implements LayoutChangeListener {
    private static final long serialVersionUID = 1L;
    private static final InstructionHints hints = new InstructionHints();
    private Instruction instruction = null;
    private List<Object> choosers = new ArrayList<Object>();
    private InstructionList instructionList = new InstructionList();
    private int position = 0;
    private ConstantPool pool = null;
    private ClassFile cf;
    private LocalVariableTableAttribute lvTable = null;
    private boolean insertMode = false;
    private JPanel content = new JPanel();
    private JPanel instructionInfo = new JPanel();
    private DefaultComboBoxModel model = new DefaultComboBoxModel();
    private JComboBox instructionCombo = new JComboBox(this.model){

        public String getToolTipText() {
            Object obj = this.getSelectedItem();
            if (obj != null && obj instanceof Instruction) {
                Instruction inst = (Instruction)obj;
                return hints.getHint(inst);
            }
            return super.getToolTipText();
        }
    };
    private JButton okButton = new JButton("Ok");
    private JButton cancelButton = new JButton("Cancel");
    private JPanel paramPanel = new JPanel();
    private JPanel buttonPanel = new JPanel();
    boolean cancelled = true;

    public InstructionEditor() {
        super(MainWindow.getInstance(), "Instruction editor", true);
        this.getContentPane().setLayout(new BorderLayout());
        this.content.setLayout(new GridBagLayout());
        this.instructionInfo.setLayout(new GridBagLayout());
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                InstructionEditor.this.cancelled = false;
                InstructionEditor.this.setVisible(false);
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                InstructionEditor.this.cancelled = true;
                InstructionEditor.this.setVisible(false);
            }
        });
        this.paramPanel.setLayout(new GridBagLayout());
        this.instructionInfo.setBorder(BorderFactory.createTitledBorder("Instruction"));
        this.paramPanel.setBorder(BorderFactory.createTitledBorder("Instruction Parameters"));
        this.paramPanel.setDebugGraphicsOptions(0);
        this.getContentPane().add((Component)this.content, "Center");
        this.content.add((Component)this.instructionInfo, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.instructionInfo.add((Component)this.instructionCombo, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.instructionInfo.add((Component)this.buttonPanel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.buttonPanel.add((Component)this.okButton, null);
        this.buttonPanel.add((Component)this.cancelButton, null);
        this.content.add((Component)this.paramPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void invokeModify() {
        this.insertMode = false;
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
        this.updateEditor();
        ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
        toolTipManager.registerComponent(this.instructionCombo);
        super.setVisible(true);
        toolTipManager.unregisterComponent(this.instructionCombo);
    }

    public void invokeInsert() {
        this.insertMode = true;
        List<Instruction> instructions = this.instructionList.getList();
        Collections.sort(instructions, new Comparator<Instruction>(){

            @Override
            public int compare(Instruction a, Instruction b) {
                return a.getMnemonic().compareTo(b.getMnemonic());
            }
        });
        this.model.removeAllElements();
        for (Instruction inst : instructions) {
            this.model.addElement(inst);
        }
        this.instruction = (Instruction)this.instructionCombo.getSelectedItem();
        this.pack();
        this.updateEditor();
        this.setLocationRelativeTo(this.getOwner());
        ItemListener il = new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                InstructionEditor.this.instruction = (Instruction)InstructionEditor.this.instructionCombo.getSelectedItem();
                InstructionEditor.this.updateEditor();
            }
        };
        this.instructionCombo.addItemListener(il);
        this.updateEditor();
        ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
        toolTipManager.registerComponent(this.instructionCombo);
        super.setVisible(true);
        toolTipManager.unregisterComponent(this.instructionCombo);
        this.instructionCombo.removeItemListener(il);
    }

    private void addToPanel(Container parent, Component child, int pos) {
        parent.add(child, new GridBagConstraints(0, pos + 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void updateEditor() {
        this.paramPanel.removeAll();
        Parameters params = this.instruction.getParameters();
        if (params == null) {
            throw new RuntimeException("Instruction " + this.instruction.getClass().getName() + " fails the instruction contract by returning null on a call to getParameters()");
        }
        this.choosers.clear();
        block12: for (int i = 0; i < params.getCount(); ++i) {
            switch (params.getType(i)) {
                case TYPE_LOCAL_VARIABLE_WIDE: 
                case TYPE_LOCAL_VARIABLE: {
                    JPanel chooser = new LocalVariableChooser();
                    this.choosers.add(chooser);
                    LocalVariable lv = null;
                    if (this.lvTable != null) {
                        ((LocalVariableChooser)chooser).setLocalVariable(this.lvTable);
                        lv = this.lvTable.getLocalVariable(params.getInt(i), this.position);
                    }
                    if (lv != null) {
                        ((LocalVariableChooser)chooser).setSelected(lv);
                    } else {
                        ((LocalVariableChooser)chooser).setSelected(String.valueOf(params.getInt(i)));
                    }
                    ((LocalVariableChooser)chooser).setEditable(true);
                    this.addToPanel(this.paramPanel, chooser, i);
                    continue block12;
                }
                case TYPE_LOCAL_VARIABLE_READONLY: {
                    LocalVariable lv;
                    JPanel chooser = new LocalVariableChooser();
                    this.choosers.add(chooser);
                    if (this.lvTable != null) {
                        ((LocalVariableChooser)chooser).setLocalVariable(this.lvTable);
                        lv = this.lvTable.getLocalVariable(params.getInt(i), this.position);
                        if (lv != null) {
                            ((LocalVariableChooser)chooser).setSelected(lv);
                        } else {
                            ((LocalVariableChooser)chooser).setSelected(String.valueOf(params.getInt(i)));
                        }
                    }
                    ((LocalVariableChooser)chooser).setEditable(false);
                    ((LocalVariableChooser)chooser).setReadOnly();
                    this.addToPanel(this.paramPanel, chooser, i);
                    continue block12;
                }
                case TYPE_CONSTANT_WIDE: 
                case TYPE_CONSTANT: {
                    JPanel chooser = new ConstantChooser();
                    this.choosers.add(chooser);
                    ((ConstantChooser)chooser).setValue(params.getInt(i));
                    this.addToPanel(this.paramPanel, chooser, i);
                    continue block12;
                }
                case TYPE_CONSTANT_POOL_METHOD_REF: {
                    JPanel chooser = new MethodChooser(this);
                    this.choosers.add(chooser);
                    ((MethodChooser)chooser).setClassFile(this.cf);
                    ((MethodChooser)chooser).setConstantPool(this.pool);
                    if (!this.insertMode) {
                        ((MethodChooser)chooser).setSelected(this.pool.get(params.getInt(i)));
                    }
                    ((MethodChooser)chooser).setEditable(false);
                    this.addToPanel(this.paramPanel, chooser, i);
                    continue block12;
                }
                case TYPE_CONSTANT_POOL_FIELD_REF: {
                    JPanel chooser = new FieldChooser(this);
                    this.choosers.add(chooser);
                    ((FieldChooser)chooser).setClassFile(this.cf);
                    ((FieldChooser)chooser).setConstantPool(this.pool);
                    if (!this.insertMode) {
                        ((FieldChooser)chooser).setSelected(this.pool.get(params.getInt(i)));
                    }
                    ((FieldChooser)chooser).setEditable(false);
                    this.addToPanel(this.paramPanel, chooser, i);
                    continue block12;
                }
                case TYPE_CONSTANT_POOL_CLASS: {
                    JPanel chooser = new ClassChooser(this);
                    this.choosers.add(chooser);
                    ((ClassChooser)chooser).setClassFile(this.cf);
                    ((ClassChooser)chooser).setConstantPool(this.pool);
                    if (!this.insertMode) {
                        ((ClassChooser)chooser).setSelected(this.pool.get(params.getInt(i)));
                    }
                    ((ClassChooser)chooser).setEditable(false);
                    this.addToPanel(this.paramPanel, chooser, i);
                    continue block12;
                }
                case TYPE_ARRAYTYPE: {
                    JPanel chooser = new ArrayTypeChooser();
                    this.choosers.add(chooser);
                    if (!this.insertMode) {
                        ((ArrayTypeChooser)chooser).setSelected(params.getInt(i));
                    }
                    ((ArrayTypeChooser)chooser).setEditable(false);
                    this.addToPanel(this.paramPanel, chooser, i);
                    continue block12;
                }
                case TYPE_CONSTANT_POOL_CONSTANT: {
                    JPanel chooser = new ConstantpoolConstantChooser();
                    this.choosers.add(chooser);
                    ((ConstantpoolConstantChooser)chooser).setConstantPool(this.pool);
                    if (!this.insertMode) {
                        ((ConstantpoolConstantChooser)chooser).setSelected(this.pool.get(params.getInt(i)));
                    }
                    ((ConstantpoolConstantChooser)chooser).setEditable(false);
                    this.addToPanel(this.paramPanel, chooser, i);
                    continue block12;
                }
                case TYPE_CONSTANT_READONLY: {
                    continue block12;
                }
                case TYPE_LABEL: {
                    continue block12;
                }
            }
        }
        this.pack();
        this.paramPanel.validate();
        this.paramPanel.repaint();
    }

    public boolean wasCancelled() {
        return this.cancelled;
    }

    public Instruction getInstruction() {
        return this.instruction;
    }

    public List getChoosers() {
        return this.choosers;
    }

    public void setLocalVariableTable(LocalVariableTableAttribute lvTable) {
        this.lvTable = lvTable;
    }

    public void setPC(int pc) {
        this.position = pc;
    }

    public void setClassFile(ClassFile cf) {
        this.cf = cf;
        this.pool = cf.getPool();
    }

    public void setInstruction(Instruction instruction) {
        this.instruction = instruction;
        this.model.removeAllElements();
        this.model.addElement(instruction);
        this.instructionCombo.setSelectedItem(instruction);
    }

    public void layoutChanged(JComponent c) {
        this.pack();
    }
}

