/*
 * Decompiled with CFR 0.152.
 */
package net.sf.rej.gui.editor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterListModel
implements ListModel {
    private List<ListDataListener> listeners = new ArrayList<ListDataListener>();
    private List<Object> original = new ArrayList<Object>();
    private List<Object> filtered = new ArrayList<Object>();
    private String filter = "";

    public FilterListModel(Collection<Object> c) {
        this.original.addAll(c);
        this.filtered.addAll(this.original);
    }

    @Override
    public int getSize() {
        return this.filtered.size();
    }

    public void filter() {
        int oldSize = this.filtered.size();
        String lcaseFilter = this.filter.toLowerCase();
        this.filtered.clear();
        for (int i = 0; i < this.original.size(); ++i) {
            Object obj = this.original.get(i);
            if (!obj.toString().toLowerCase().startsWith(lcaseFilter)) continue;
            this.filtered.add(obj);
        }
        this.notifyListeners(oldSize);
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public Object getElementAt(int index) {
        if (index >= this.filtered.size()) {
            return null;
        }
        return this.filtered.get(index);
    }

    @Override
    public void addListDataListener(ListDataListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeListDataListener(ListDataListener l) {
        this.listeners.remove(l);
    }

    private void notifyListeners(int oldSize) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ListDataListener ldl = this.listeners.get(i);
            ldl.contentsChanged(new ListDataEvent(this, 2, 0, oldSize));
            ldl.contentsChanged(new ListDataEvent(this, 1, 0, this.filtered.size()));
        }
    }
}

