/*
 * Decompiled with CFR 0.152.
 */
package net.sf.rej.gui.dialog;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.sf.rej.gui.MainWindow;
import net.sf.rej.java.ClassVersion;
import net.sf.rej.util.Wrapper;

public class ClassVersionDialog
extends JDialog {
    private JPanel jContentPane = null;
    private JLabel versionLabel = null;
    JComboBox versionCombo = null;
    private JPanel okCancelPanel = null;
    private JButton okButton = null;
    private JButton cancelButton = null;
    DefaultComboBoxModel versionModel;
    boolean cancelled = false;
    private ClassVersion selectedVersion = null;

    public ClassVersionDialog(Dialog owner) {
        super(owner, true);
        this.initialize();
    }

    public ClassVersionDialog(Frame owner) {
        super(owner, true);
        this.initialize();
    }

    private void initialize() {
        this.setSize(300, 150);
        this.setTitle("Class Version Chooser");
        this.setContentPane(this.getJContentPane());
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            GridBagConstraints gridBagConstraints21 = new GridBagConstraints();
            gridBagConstraints21.gridx = 0;
            gridBagConstraints21.gridwidth = 3;
            gridBagConstraints21.gridy = 2;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.gridy = 0;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.gridx = 1;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.gridy = 0;
            this.versionLabel = new JLabel();
            this.versionLabel.setText("Version: ");
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            this.jContentPane.add((Component)this.versionLabel, gridBagConstraints);
            this.jContentPane.add((Component)this.getVersionCombo(), gridBagConstraints2);
            this.jContentPane.add((Component)this.getOkCancelPanel(), gridBagConstraints21);
        }
        return this.jContentPane;
    }

    private JComboBox getVersionCombo() {
        if (this.versionCombo == null) {
            this.versionModel = new DefaultComboBoxModel();
            this.versionCombo = new JComboBox(this.versionModel);
            this.versionCombo.setEditable(true);
        }
        return this.versionCombo;
    }

    private JPanel getOkCancelPanel() {
        if (this.okCancelPanel == null) {
            this.okCancelPanel = new JPanel();
            this.okCancelPanel.add((Component)this.getOkButton(), null);
            this.okCancelPanel.add((Component)this.getCancelButton(), null);
        }
        return this.okCancelPanel;
    }

    private JButton getOkButton() {
        if (this.okButton == null) {
            this.okButton = new JButton();
            this.okButton.setText("OK");
            this.okButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    try {
                        ClassVersionDialog.this.selectedVersion = ClassVersionDialog.this.parseVersion();
                        ClassVersionDialog.this.cancelled = false;
                        ClassVersionDialog.this.setVisible(false);
                    }
                    catch (VersionParseException vpe) {
                        MainWindow.getInstance().showErrorMessage(vpe.getMessage());
                    }
                }
            });
        }
        return this.okButton;
    }

    private JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton();
            this.cancelButton.setText("Cancel");
            this.cancelButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ClassVersionDialog.this.cancelled = true;
                    ClassVersionDialog.this.setVisible(false);
                }
            });
        }
        return this.cancelButton;
    }

    public void invoke(int majorVersion, int minorVersion) {
        this.versionModel.removeAllElements();
        Wrapper<ClassVersion> wrapper49 = new Wrapper<ClassVersion>();
        wrapper49.setContent(new ClassVersion(49, 0));
        wrapper49.setDisplay("49.0 (Java 1.5)");
        this.versionModel.addElement(wrapper49);
        Wrapper<ClassVersion> wrapper48 = new Wrapper<ClassVersion>();
        wrapper48.setContent(new ClassVersion(48, 0));
        wrapper48.setDisplay("48.0 (Java 1.4)");
        this.versionModel.addElement(wrapper48);
        ClassVersion initial = new ClassVersion(majorVersion, minorVersion);
        if (initial.equals(wrapper49.getContent())) {
            this.versionCombo.setSelectedItem(wrapper49);
        } else if (initial.equals(wrapper48.getContent())) {
            this.versionCombo.setSelectedItem(wrapper48);
        } else {
            this.versionModel.addElement(initial);
            this.versionCombo.setSelectedItem(initial);
        }
        this.setLocationRelativeTo(this.getOwner());
        this.setVisible(true);
    }

    public boolean wasCancelled() {
        return this.cancelled;
    }

    public ClassVersion getVersion() {
        return this.selectedVersion;
    }

    private ClassVersion parseVersion() throws VersionParseException {
        Object item = this.versionCombo.getSelectedItem();
        if (item instanceof String) {
            ClassVersion version = new ClassVersion();
            String[] strs = item.toString().split("\\.");
            if (strs.length == 1) {
                try {
                    version.setMajorVersion(Integer.parseInt(strs[0]));
                    version.setMinorVersion(0);
                }
                catch (NumberFormatException nfe) {
                    throw new VersionParseException("Version must be of format number.number");
                }
            } else if (strs.length == 2) {
                try {
                    version.setMajorVersion(Integer.parseInt(strs[0]));
                    version.setMinorVersion(Integer.parseInt(strs[1]));
                }
                catch (NumberFormatException nfe) {
                    throw new VersionParseException("Version must be of format number.number");
                }
            } else {
                throw new VersionParseException("Version must be of format number.number");
            }
            return version;
        }
        if (item instanceof ClassVersion) {
            return (ClassVersion)item;
        }
        if (item instanceof Wrapper) {
            Wrapper wrapper = (Wrapper)item;
            return (ClassVersion)wrapper.getContent();
        }
        throw new AssertionError((Object)("Invalid type in combobox: " + item.getClass().getName()));
    }

    static class VersionParseException
    extends Exception {
        public VersionParseException(String msg) {
            super(msg);
        }
    }
}

