/*
 * Decompiled with CFR 0.152.
 */
package net.sf.rej.gui.compare;

import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import net.sf.rej.Imports;
import net.sf.rej.gui.EditorFacade;
import net.sf.rej.gui.MainWindow;
import net.sf.rej.gui.SystemFacade;
import net.sf.rej.gui.compare.CodeCompareRenderer;
import net.sf.rej.gui.dialog.QuickOutlineDialog;
import net.sf.rej.gui.editor.CaseInsensitiveMatcher;
import net.sf.rej.gui.editor.rendering.BytecodeRenderer;
import net.sf.rej.gui.editor.rendering.HTMLSyntaxDrawer;
import net.sf.rej.gui.editor.rendering.PlaintextSyntaxDrawer;
import net.sf.rej.gui.editor.row.BlankRow;
import net.sf.rej.gui.editor.row.ClassCommentRow;
import net.sf.rej.gui.editor.row.ClassDefRow;
import net.sf.rej.gui.editor.row.CodeRow;
import net.sf.rej.gui.editor.row.DeprecatedAnnotationDefRow;
import net.sf.rej.gui.editor.row.EditorRow;
import net.sf.rej.gui.editor.row.FieldDefRow;
import net.sf.rej.gui.editor.row.ImportDefRow;
import net.sf.rej.gui.editor.row.LabelRow;
import net.sf.rej.gui.editor.row.LocalVariableDefRow;
import net.sf.rej.gui.editor.row.MethodAnnotationDefRow;
import net.sf.rej.gui.editor.row.MethodDefRow;
import net.sf.rej.gui.editor.row.PackageDefRow;
import net.sf.rej.gui.editor.transfer.BytecodeEditorTransferHandler;
import net.sf.rej.gui.editor.transfer.TransferComponent;
import net.sf.rej.java.ClassFile;
import net.sf.rej.java.Code;
import net.sf.rej.java.Descriptor;
import net.sf.rej.java.Field;
import net.sf.rej.java.Interface;
import net.sf.rej.java.LocalVariable;
import net.sf.rej.java.Method;
import net.sf.rej.java.attribute.Attributes;
import net.sf.rej.java.attribute.CodeAttribute;
import net.sf.rej.java.attribute.LineNumberTableAttribute;
import net.sf.rej.java.attribute.LocalVariableTableAttribute;
import net.sf.rej.java.attribute.RuntimeInvisibleAnnotationsAttribute;
import net.sf.rej.java.attribute.RuntimeVisibleAnnotationsAttribute;
import net.sf.rej.java.attribute.SourceFileAttribute;
import net.sf.rej.java.attribute.annotations.Annotation;
import net.sf.rej.java.instruction.DecompilationContext;
import net.sf.rej.java.instruction.Instruction;
import net.sf.rej.java.instruction.Label;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComparePanel
extends JPanel
implements TransferComponent {
    private static final long serialVersionUID = 1L;
    private CaseInsensitiveMatcher lastSearch = null;
    private String lastQueryString = null;
    private List<EditorRow> rowsAll;
    private Collection<EditorRow> rowsA;
    private Collection<EditorRow> rowsB;
    private CodeCompareRenderer renderer = new CodeCompareRenderer();
    DefaultListModel model = new DefaultListModel();
    JList list = new JList(this.model);
    private JScrollPane editorScrollPane = new JScrollPane(this.list);
    private ClassFile cfA;
    private ClassFile cfB;
    private JLabel label = new JLabel("Bytecode Compare");
    BufferedImage clueImage = null;

    public ComparePanel() {
        this.setLayout(new BorderLayout());
        this.list.setCellRenderer(this.renderer);
        this.list.setTransferHandler(new BytecodeEditorTransferHandler(this));
        this.add((Component)this.label, "North");
        this.add((Component)this.editorScrollPane, "Center");
        this.editorScrollPane.setVerticalScrollBar(new JScrollBar(){
            final AlphaComposite SEMI_OPAQUE = AlphaComposite.getInstance(3, 0.3f);

            public void paint(Graphics g) {
                g.setPaintMode();
                super.paint(g);
                if (ComparePanel.this.clueImage != null) {
                    Graphics2D g2 = (Graphics2D)g;
                    g2.setComposite(this.SEMI_OPAQUE);
                    g2.drawImage(ComparePanel.this.clueImage, 2, 17, this.getWidth() - 3, this.getHeight() - 34, null);
                }
            }
        });
    }

    public void setClassFiles(ClassFile cfA, ClassFile cfB) {
        this.cfA = cfA;
        this.cfB = cfB;
        if (cfA.getFullClassName().equals(cfB.getFullClassName())) {
            this.label.setText("Bytecode Compare: " + cfA.getFullClassName());
        } else {
            this.label.setText("Bytecode Compare: " + cfA.getFullClassName() + " / " + cfB.getFullClassName());
        }
        this.load(cfA, cfB);
    }

    private void load(ClassFile cfA, ClassFile cfB) {
        this.rowsAll = new ArrayList<EditorRow>();
        this.rowsA = new HashSet<EditorRow>();
        this.rowsB = new HashSet<EditorRow>();
        if (cfA.getPackageName().equals(cfB.getPackageName())) {
            this.rowsAll.add(new PackageDefRow(cfA));
        } else {
            PackageDefRow pdrA = new PackageDefRow(cfA);
            PackageDefRow pdrB = new PackageDefRow(cfB);
            this.rowsA.add(pdrA);
            this.rowsB.add(pdrB);
            this.rowsAll.add(pdrA);
            this.rowsAll.add(pdrB);
        }
        this.rowsAll.add(new BlankRow());
        Imports importsA = EditorFacade.getInstance().getImports(cfA);
        Imports importsB = EditorFacade.getInstance().getImports(cfB);
        this.renderer.setImports(importsA, importsB);
        Set<String> tsA = importsA.getImports();
        Set<String> tsB = importsB.getImports();
        TreeSet<String> allOrdered = new TreeSet<String>();
        allOrdered.addAll(tsA);
        allOrdered.addAll(tsB);
        for (String imp : allOrdered) {
            ImportDefRow idr = new ImportDefRow(imp);
            this.rowsAll.add(idr);
            if (!tsA.contains(imp)) {
                this.rowsB.add(idr);
            }
            if (tsB.contains(imp)) continue;
            this.rowsA.add(idr);
        }
        if (allOrdered.size() > 0) {
            this.rowsAll.add(new BlankRow());
        }
        SourceFileAttribute sfA = cfA.getAttributes().getSourceFileAttribute();
        SourceFileAttribute sfB = cfB.getAttributes().getSourceFileAttribute();
        if (sfA != null || sfB != null) {
            ClassCommentRow sfComment;
            if (sfA == null || sfB == null) {
                if (sfA != null) {
                    sfComment = new ClassCommentRow("SourceFile = " + sfA.getSourceFile());
                    this.rowsA.add(sfComment);
                    this.rowsAll.add(sfComment);
                }
                if (sfB != null) {
                    sfComment = new ClassCommentRow("SourceFile = " + sfB.getSourceFile());
                    this.rowsB.add(sfComment);
                    this.rowsAll.add(sfComment);
                }
            } else if (sfA.getSourceFile().equals(sfB.getSourceFile())) {
                sfComment = new ClassCommentRow("SourceFile = " + sfA.getSourceFile());
                this.rowsAll.add(sfComment);
            } else {
                ClassCommentRow sfCommentA = new ClassCommentRow("SourceFile = " + sfA.getSourceFile());
                this.rowsA.add(sfCommentA);
                this.rowsAll.add(sfCommentA);
                ClassCommentRow sfCommentB = new ClassCommentRow("SourceFile = " + sfB.getSourceFile());
                this.rowsB.add(sfCommentB);
                this.rowsAll.add(sfCommentB);
            }
        }
        if (cfA.getMajorVersion() == cfB.getMajorVersion() && cfA.getMinorVersion() == cfB.getMinorVersion()) {
            ClassCommentRow versionComment = new ClassCommentRow("Class Version: " + cfA.getMajorVersion() + "." + cfA.getMinorVersion());
            this.rowsAll.add(versionComment);
        } else {
            ClassCommentRow versionCommentA = new ClassCommentRow("Class Version: " + cfA.getMajorVersion() + "." + cfA.getMinorVersion());
            this.rowsA.add(versionCommentA);
            ClassCommentRow versionCommentB = new ClassCommentRow("Class Version: " + cfB.getMajorVersion() + "." + cfB.getMinorVersion());
            this.rowsB.add(versionCommentB);
            this.rowsAll.add(versionCommentA);
            this.rowsAll.add(versionCommentB);
        }
        List<Interface> interfacesA = cfA.getInterfaces();
        List<Interface> interfacesB = cfB.getInterfaces();
        boolean interfacesAreEqual = ((Object)interfacesA).equals(interfacesB);
        if (cfA.getShortClassName().equals(cfB.getShortClassName()) && cfA.getAccessFlags() == cfB.getAccessFlags() && cfA.getSuperClassName().equals(cfB.getSuperClassName()) && interfacesAreEqual) {
            this.rowsAll.add(new ClassDefRow(cfA, true));
        } else {
            ClassDefRow cdrA = new ClassDefRow(cfA, true);
            ClassDefRow cdrB = new ClassDefRow(cfB, true);
            this.rowsA.add(cdrA);
            this.rowsB.add(cdrB);
            this.rowsAll.add(cdrA);
            this.rowsAll.add(cdrB);
        }
        this.rowsAll.add(new BlankRow());
        HashMap<String, Field> fieldsA = new HashMap<String, Field>();
        for (Field field : cfA.getFields()) {
            fieldsA.put(field.getSignatureLine(), field);
        }
        HashMap<String, Field> fieldsB = new HashMap<String, Field>();
        for (Field field : cfB.getFields()) {
            fieldsB.put(field.getSignatureLine(), field);
        }
        TreeSet allFields = new TreeSet();
        allFields.addAll(fieldsA.keySet());
        allFields.addAll(fieldsB.keySet());
        for (String fieldSignature : allFields) {
            FieldDefRow fdr = null;
            Field field = (Field)fieldsA.get(fieldSignature);
            if (field == null) {
                field = (Field)fieldsB.get(fieldSignature);
                fdr = new FieldDefRow(cfB, field);
                this.rowsB.add(fdr);
            } else {
                fdr = new FieldDefRow(cfA, field);
                if (!fieldsB.keySet().contains(fieldSignature)) {
                    this.rowsA.add(fdr);
                }
            }
            this.rowsAll.add(fdr);
        }
        if (allFields.size() > 0) {
            this.rowsAll.add(new BlankRow());
        }
        HashMap<String, Method> methodsA = new HashMap<String, Method>();
        for (Method method : cfA.getMethods()) {
            Descriptor desc = method.getDescriptor();
            methodsA.put(desc.getReturn() + method.getName() + " " + desc.getParams(), method);
        }
        HashMap<String, Method> methodsB = new HashMap<String, Method>();
        for (Method method : cfB.getMethods()) {
            Descriptor desc = method.getDescriptor();
            methodsB.put(desc.getReturn() + method.getName() + " " + desc.getParams(), method);
        }
        TreeSet allMethods = new TreeSet();
        allMethods.addAll(methodsA.keySet());
        allMethods.addAll(methodsB.keySet());
        for (String methodTypeNameParams : allMethods) {
            List<EditorRow> methodRows;
            Method methodA = (Method)methodsA.get(methodTypeNameParams);
            Method methodB = (Method)methodsB.get(methodTypeNameParams);
            if (methodA == null) {
                methodRows = this.getMethodRows(cfB, methodB);
                this.rowsB.addAll(methodRows);
                this.rowsAll.addAll(methodRows);
            } else if (methodB == null) {
                methodRows = this.getMethodRows(cfA, methodA);
                this.rowsA.addAll(methodRows);
                this.rowsAll.addAll(methodRows);
            } else {
                this.addMethodRows(cfA, cfB, methodA, methodB);
            }
            this.rowsAll.add(new BlankRow());
        }
        this.rowsAll.add(new ClassDefRow(cfA, false));
        this.renderer.setRedSet(this.rowsA);
        this.renderer.setYellowSet(this.rowsB);
        this.model.clear();
        for (EditorRow er : this.rowsAll) {
            this.model.addElement(er);
        }
        int all = this.rowsAll.size();
        this.clueImage = new BufferedImage(10, all, 2);
        Graphics g = this.clueImage.getGraphics();
        g.setColor(Color.RED);
        for (EditorRow er : this.rowsA) {
            int i = this.rowsAll.indexOf(er);
            g.fillRect(0, i, 10, 1);
        }
        g.setColor(Color.YELLOW.darker());
        for (EditorRow er : this.rowsB) {
            int i = this.rowsAll.indexOf(er);
            g.fillRect(0, i, 10, 1);
        }
    }

    public void find() {
        if (this.rowsAll == null) {
            return;
        }
        String query = (String)JOptionPane.showInputDialog(this, "Search for..", "Search", 3, null, null, this.lastQueryString);
        if (query == null) {
            return;
        }
        this.lastQueryString = query;
        this.lastSearch = new CaseInsensitiveMatcher(query);
        BytecodeRenderer renderer = new BytecodeRenderer();
        PlaintextSyntaxDrawer sd = new PlaintextSyntaxDrawer();
        Imports imports = EditorFacade.getInstance().getImports(this.cfA);
        for (int i = 0; i < this.model.size(); ++i) {
            sd.clear();
            renderer.render((EditorRow)this.model.elementAt(i), sd, imports);
            if (!this.lastSearch.matches(sd.getText())) continue;
            this.list.setSelectedIndex(i);
            this.list.ensureIndexIsVisible(i);
            SystemFacade.getInstance().setStatus("Found '" + query + "'.");
            return;
        }
        this.lastSearch = null;
        SystemFacade.getInstance().setStatus("No occurances of '" + query + "' found.");
    }

    public void findNext() {
        if (this.lastSearch == null) {
            this.find();
        } else {
            BytecodeRenderer renderer = new BytecodeRenderer();
            PlaintextSyntaxDrawer sd = new PlaintextSyntaxDrawer();
            Imports imports = EditorFacade.getInstance().getImports(this.cfA);
            for (int i = this.list.getSelectedIndex() + 1; i < this.model.size(); ++i) {
                sd.clear();
                renderer.render((EditorRow)this.model.elementAt(i), sd, imports);
                if (!this.lastSearch.matches(sd.getText())) continue;
                this.list.setSelectedIndex(i);
                this.list.ensureIndexIsVisible(i);
                SystemFacade.getInstance().setStatus("Found '" + this.lastQueryString + "'.");
                return;
            }
            SystemFacade.getInstance().setStatus("No more occurances of '" + this.lastQueryString + "' found.");
        }
    }

    @Override
    public String getSelectionPlainText() {
        BytecodeRenderer renderer = new BytecodeRenderer();
        PlaintextSyntaxDrawer sd = new PlaintextSyntaxDrawer();
        Imports imports = EditorFacade.getInstance().getImports(this.cfA);
        for (Object obj : this.list.getSelectedValues()) {
            EditorRow er = (EditorRow)obj;
            renderer.render(er, sd, imports);
            sd.drawLineBreak();
        }
        return sd.getText();
    }

    @Override
    public String getSelectionHTML() {
        BytecodeRenderer renderer = new BytecodeRenderer();
        HTMLSyntaxDrawer sd = new HTMLSyntaxDrawer();
        Imports imports = EditorFacade.getInstance().getImports(this.cfA);
        for (Object obj : this.list.getSelectedValues()) {
            EditorRow er = (EditorRow)obj;
            renderer.render(er, sd, imports);
            sd.drawLineBreak();
        }
        return "<HTML><FONT FACE=\"Courier New\">" + sd.getHTML() + "</FONT></HTML>";
    }

    @Override
    public Object getSelectionObject() {
        return new ArrayList();
    }

    @Override
    public void pasteRows(Object data) {
    }

    public void outline() {
        EditorRow er2;
        if (this.rowsAll == null) {
            return;
        }
        ArrayList<EditorRow> list = new ArrayList<EditorRow>();
        for (EditorRow er2 : this.rowsAll) {
            MethodDefRow mdr;
            if (er2 instanceof PackageDefRow) {
                list.add(er2);
                continue;
            }
            if (er2 instanceof ClassDefRow) {
                ClassDefRow cdr = (ClassDefRow)er2;
                if (cdr.isClosing()) continue;
                list.add(er2);
                continue;
            }
            if (er2 instanceof FieldDefRow) {
                list.add(er2);
                continue;
            }
            if (!(er2 instanceof MethodDefRow) || (mdr = (MethodDefRow)er2).isClosing()) continue;
            list.add(er2);
        }
        QuickOutlineDialog qod = new QuickOutlineDialog((Frame)MainWindow.getInstance(), list);
        qod.invoke();
        er2 = qod.getSelected();
        if (er2 != null) {
            int index = this.rowsAll.indexOf(er2);
            this.list.setSelectedIndex(index);
            this.list.ensureIndexIsVisible(index);
        }
    }

    private List<EditorRow> getMethodRows(ClassFile cf, Method method) {
        ArrayList<EditorRow> list = new ArrayList<EditorRow>();
        boolean deprecatedAnnotationAdded = false;
        RuntimeInvisibleAnnotationsAttribute methodAnnInvisible = method.getAttributes().getRuntimeInvisibleAnnotationsAttribute();
        RuntimeVisibleAnnotationsAttribute methodAnnVisible = method.getAttributes().getRuntimeVisibleAnnotationsAttribute();
        ArrayList<Annotation> methodAnnotations = new ArrayList<Annotation>();
        if (methodAnnInvisible != null) {
            methodAnnotations.addAll(methodAnnInvisible.getAnnotations());
        }
        if (methodAnnVisible != null) {
            methodAnnotations.addAll(methodAnnVisible.getAnnotations());
        }
        for (Annotation annotation : methodAnnotations) {
            MethodAnnotationDefRow madr = new MethodAnnotationDefRow(annotation);
            list.add(madr);
            if (!"java.lang.Deprecated".equals(annotation.getName())) continue;
            deprecatedAnnotationAdded = true;
        }
        if (!deprecatedAnnotationAdded && method.isDeprecated()) {
            DeprecatedAnnotationDefRow ddr = new DeprecatedAnnotationDefRow();
            list.add(ddr);
        }
        MethodDefRow mdr = new MethodDefRow(cf, method, true, method.getAttributes().getCode() != null);
        list.add(mdr);
        Attributes attr = method.getAttributes();
        CodeAttribute codeAttr = attr.getCode();
        LineNumberTableAttribute lnAttr = null;
        LocalVariableTableAttribute lvs = null;
        if (codeAttr != null) {
            if (codeAttr.getAttributes() != null) {
                lnAttr = codeAttr.getAttributes().getLineNumberTable();
                lvs = codeAttr.getAttributes().getLocalVariableTable();
            }
            Code code = codeAttr.getCode();
            DecompilationContext dc = code.createDecompilationContext();
            List<Instruction> instructions = code.getInstructions();
            dc.setPosition(0);
            for (int j = 0; j < instructions.size(); ++j) {
                Instruction instruction = instructions.get(j);
                if (instruction instanceof Label) {
                    LabelRow lr = new LabelRow((Label)instruction, mdr);
                    lr.setParentCode(code);
                    list.add(lr);
                    mdr.addCodeRow(lr);
                    continue;
                }
                int lineNumber = -1;
                if (lnAttr != null) {
                    lineNumber = lnAttr.getLineNumber(dc.getPosition());
                }
                if (lvs != null) {
                    List locals = lvs.getLocalVariable(dc.getPosition());
                    for (int k = 0; k < locals.size(); ++k) {
                        LocalVariable lv = (LocalVariable)locals.get(k);
                        LocalVariableDefRow lvdr = new LocalVariableDefRow(lv, mdr);
                        list.add(lvdr);
                        mdr.addLocalVariable(lvdr);
                    }
                }
                CodeRow cd = new CodeRow(cf, mdr, instruction);
                cd.setPosition(dc.getPosition());
                cd.setDecompilationContext(dc);
                cd.setParentCode(code);
                if (lineNumber != -1) {
                    cd.setLineNumber(lineNumber);
                }
                list.add(cd);
                mdr.addCodeRow(cd);
                dc.incrementPosition(instruction);
            }
            list.add(new MethodDefRow(cf, method, false, true));
        }
        return list;
    }

    private void addMethodRows(ClassFile cfA, ClassFile cfB, Method methodA, Method methodB) {
        MethodDefRow mdrA = null;
        MethodDefRow mdrB = null;
        if (methodA.getAccessFlags() == methodB.getAccessFlags() && ((Object)methodA.getExceptions()).equals(methodB.getExceptions())) {
            MethodDefRow mdr;
            mdrA = mdr = new MethodDefRow(cfA, methodA, true, methodA.getAttributes().getCode() != null);
            mdrB = mdr;
            this.rowsAll.add(mdr);
        } else {
            mdrA = new MethodDefRow(cfA, methodA, true, methodA.getAttributes().getCode() != null);
            this.rowsA.add(mdrA);
            mdrB = new MethodDefRow(cfB, methodB, true, methodB.getAttributes().getCode() != null);
            this.rowsB.add(mdrB);
            this.rowsAll.add(mdrA);
            this.rowsAll.add(mdrB);
        }
        Attributes attrA = methodA.getAttributes();
        Attributes attrB = methodB.getAttributes();
        CodeAttribute codeAttrA = attrA.getCode();
        CodeAttribute codeAttrB = attrB.getCode();
        LineNumberTableAttribute lnAttrA = null;
        LineNumberTableAttribute lnAttrB = null;
        LocalVariableTableAttribute lvsA = null;
        LocalVariableTableAttribute lvsB = null;
        if (codeAttrA != null && codeAttrB != null) {
            EditorRow erB;
            EditorRow erA;
            boolean equal;
            int endEqCount;
            EditorRow erB2;
            EditorRow erA2;
            boolean equal2;
            int startEqCount;
            if (codeAttrA.getAttributes() != null) {
                lnAttrA = codeAttrA.getAttributes().getLineNumberTable();
                lvsA = codeAttrA.getAttributes().getLocalVariableTable();
            }
            if (codeAttrB.getAttributes() != null) {
                lnAttrB = codeAttrB.getAttributes().getLineNumberTable();
                lvsB = codeAttrB.getAttributes().getLocalVariableTable();
            }
            Code codeA = codeAttrA.getCode();
            Code codeB = codeAttrB.getCode();
            DecompilationContext dcA = codeA.createDecompilationContext();
            DecompilationContext dcB = codeB.createDecompilationContext();
            List<Instruction> instructionsA = codeA.getInstructions();
            List<Instruction> instructionsB = codeB.getInstructions();
            dcA.setPosition(0);
            dcB.setPosition(0);
            List<EditorRow> methodRowsA = this.getMethodRows(instructionsA, codeA, mdrA, lnAttrA, lvsA, dcA, cfA);
            List<EditorRow> methodRowsB = this.getMethodRows(instructionsB, codeB, mdrB, lnAttrB, lvsB, dcB, cfB);
            for (startEqCount = 0; startEqCount != methodRowsA.size() && startEqCount != methodRowsB.size() && (equal2 = ComparePanel.rowsAreEqual(erA2 = methodRowsA.get(startEqCount), erB2 = methodRowsB.get(startEqCount))); ++startEqCount) {
            }
            for (int i = 0; i < startEqCount; ++i) {
                this.rowsAll.add(methodRowsA.get(0));
                methodRowsA.remove(0);
                methodRowsB.remove(0);
            }
            for (endEqCount = 0; endEqCount != methodRowsA.size() && endEqCount != methodRowsB.size() && (equal = ComparePanel.rowsAreEqual(erA = methodRowsA.get(methodRowsA.size() - 1 - endEqCount), erB = methodRowsB.get(methodRowsB.size() - 1 - endEqCount))); ++endEqCount) {
            }
            ArrayList<EditorRow> equalRowsAtTheEnd = new ArrayList<EditorRow>();
            for (int i = 0; i < endEqCount; ++i) {
                equalRowsAtTheEnd.add(methodRowsA.get(methodRowsA.size() - 1));
                methodRowsA.remove(methodRowsA.size() - 1);
                methodRowsB.remove(methodRowsB.size() - 1);
            }
            int m = methodRowsA.size();
            int n = methodRowsB.size();
            int[][] C = new int[m + 1][n + 1];
            ComparePanel.lcs(C, methodRowsA, methodRowsB);
            ArrayList<EditorRow> common = new ArrayList<EditorRow>();
            ComparePanel.bt(C, methodRowsA, methodRowsB, m, n, common);
            for (EditorRow commonRow : common) {
                while (!ComparePanel.rowsAreEqual(methodRowsA.get(0), commonRow)) {
                    this.rowsAll.add(methodRowsA.get(0));
                    this.rowsA.add(methodRowsA.get(0));
                    methodRowsA.remove(0);
                }
                while (!ComparePanel.rowsAreEqual(methodRowsB.get(0), commonRow)) {
                    this.rowsAll.add(methodRowsB.get(0));
                    this.rowsB.add(methodRowsB.get(0));
                    methodRowsB.remove(0);
                }
                this.rowsAll.add(commonRow);
                methodRowsA.remove(0);
                methodRowsB.remove(0);
            }
            this.rowsA.addAll(methodRowsA);
            this.rowsAll.addAll(methodRowsA);
            this.rowsB.addAll(methodRowsB);
            this.rowsAll.addAll(methodRowsB);
            this.rowsAll.addAll(equalRowsAtTheEnd);
            this.rowsAll.add(new MethodDefRow(cfA, methodA, false, true));
        }
    }

    private List<EditorRow> getMethodRows(List<Instruction> instructions, Code code, MethodDefRow mdr, LineNumberTableAttribute lnAttr, LocalVariableTableAttribute lvs, DecompilationContext dc, ClassFile cf) {
        ArrayList<EditorRow> list = new ArrayList<EditorRow>();
        for (Instruction instruction : instructions) {
            if (instruction instanceof Label) {
                LabelRow lr = new LabelRow((Label)instruction, mdr);
                lr.setParentCode(code);
                list.add(lr);
                mdr.addCodeRow(lr);
                continue;
            }
            int lineNumber = -1;
            if (lnAttr != null) {
                lineNumber = lnAttr.getLineNumber(dc.getPosition());
            }
            if (lvs != null) {
                List locals = lvs.getLocalVariable(dc.getPosition());
                for (int k = 0; k < locals.size(); ++k) {
                    LocalVariable lv = (LocalVariable)locals.get(k);
                    LocalVariableDefRow lvdr = new LocalVariableDefRow(lv, mdr);
                    list.add(lvdr);
                    mdr.addLocalVariable(lvdr);
                }
            }
            CodeRow cd = new CodeRow(cf, mdr, instruction);
            cd.setPosition(dc.getPosition());
            cd.setDecompilationContext(dc);
            cd.setParentCode(code);
            if (lineNumber != -1) {
                cd.setLineNumber(lineNumber);
            }
            list.add(cd);
            mdr.addCodeRow(cd);
            dc.incrementPosition(instruction);
        }
        return list;
    }

    public static boolean rowsAreEqual(EditorRow erA, EditorRow erB) {
        if (!erA.getClass().equals(erB.getClass())) {
            return false;
        }
        if (erA instanceof LocalVariableDefRow) {
            LocalVariableDefRow lvdrA = (LocalVariableDefRow)erA;
            LocalVariableDefRow lvdrB = (LocalVariableDefRow)erB;
            return lvdrA.getLocalVariable().getName().equals(lvdrB.getLocalVariable().getName());
        }
        if (erA instanceof LabelRow) {
            LabelRow lrA = (LabelRow)erA;
            LabelRow lrB = (LabelRow)erB;
            return lrA.getLabel().getId().equals(lrB.getLabel().getId());
        }
        if (erA instanceof CodeRow) {
            boolean opCodesEqual;
            CodeRow crA = (CodeRow)erA;
            CodeRow crB = (CodeRow)erB;
            Instruction instA = crA.getInstruction();
            Instruction instB = crB.getInstruction();
            boolean bl = opCodesEqual = instA.getOpcode() == instB.getOpcode();
            if (!opCodesEqual) {
                return false;
            }
            return instA.getParameters().getString(crA.getDecompilationContext()).equals(instB.getParameters().getString(crB.getDecompilationContext()));
        }
        throw new AssertionError((Object)("Invalid object type: " + erA.getClass()));
    }

    public static void lcs(int[][] C, List<EditorRow> X, List<EditorRow> Y) {
        for (int i = 1; i < X.size() + 1; ++i) {
            for (int j = 1; j < Y.size() + 1; ++j) {
                C[i][j] = ComparePanel.rowsAreEqual(X.get(i - 1), Y.get(j - 1)) ? C[i - 1][j - 1] + 1 : Math.max(C[i][j - 1], C[i - 1][j]);
            }
        }
    }

    public static void bt(int[][] C, List<EditorRow> X, List<EditorRow> Y, int i, int j, List<EditorRow> list) {
        if (i == 0 || j == 0) {
            return;
        }
        if (ComparePanel.rowsAreEqual(X.get(i - 1), Y.get(j - 1))) {
            ComparePanel.bt(C, X, Y, i - 1, j - 1, list);
            list.add(X.get(i - 1));
        } else if (C[i][j - 1] > C[i - 1][j]) {
            ComparePanel.bt(C, X, Y, i, j - 1, list);
        } else {
            ComparePanel.bt(C, X, Y, i - 1, j, list);
        }
    }
}

