/*
 * Decompiled with CFR 0.152.
 */
package net.sf.rej.gui.compare;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.util.Collection;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import net.sf.rej.Imports;
import net.sf.rej.gui.editor.rendering.BytecodeRenderer;
import net.sf.rej.gui.editor.rendering.GraphicsSyntaxDrawer;
import net.sf.rej.gui.editor.rendering.WidthCalculatorDrawer;
import net.sf.rej.gui.editor.row.EditorRow;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CodeCompareRenderer
extends DefaultListCellRenderer {
    private static final long serialVersionUID = 1L;
    private EditorRow er = null;
    private Imports importsA;
    private Imports importsB;
    private Collection<EditorRow> redSet = null;
    private Collection<EditorRow> yellowSet = null;
    private Color bg = Color.WHITE;
    private boolean yellow = false;
    private BytecodeRenderer renderer = new BytecodeRenderer();
    private int width = 0;

    public void setRedSet(Collection<EditorRow> set) {
        this.redSet = set;
    }

    public void setYellowSet(Collection<EditorRow> set) {
        this.yellowSet = set;
    }

    @Override
    public Component getListCellRendererComponent(JList table, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        this.er = (EditorRow)value;
        this.yellow = false;
        if (this.redSet.contains(this.er)) {
            this.bg = new Color(255, 100, 100);
        } else if (this.yellowSet.contains(this.er)) {
            this.yellow = true;
            this.bg = new Color(255, 255, 100);
        } else {
            this.bg = Color.WHITE;
        }
        if (isSelected) {
            this.bg = this.bg.darker();
        }
        this.setText(" ");
        WidthCalculatorDrawer wcd = new WidthCalculatorDrawer(table.getGraphics());
        this.renderer.render(this.er, wcd, this.yellow ? this.importsA : this.importsB);
        this.width = wcd.getMaxWidth();
        return this;
    }

    @Override
    public void paint(Graphics g) {
        this.setBackground(this.bg);
        super.paint(g);
        if (this.er == null) {
            return;
        }
        Dimension d = this.getSize();
        GraphicsSyntaxDrawer sd = new GraphicsSyntaxDrawer(g, d);
        if (this.yellow) {
            this.renderer.render(this.er, sd, this.importsB);
        } else {
            this.renderer.render(this.er, sd, this.importsA);
        }
    }

    public void setImports(Imports importsA, Imports importsB) {
        this.importsA = importsA;
        this.importsB = importsB;
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.width, super.getPreferredSize().height);
    }
}

