/*
 * Decompiled with CFR 0.152.
 */
package net.sf.rej.gui.action;

import java.util.ArrayList;
import java.util.List;
import net.sf.rej.gui.Undoable;
import net.sf.rej.java.Method;
import net.sf.rej.java.constantpool.ConstantPool;

public class RenameMethodAction
implements Undoable {
    private ConstantPool cp;
    private Method method;
    private String methodName;
    private int oldNameIndex;
    private List<Integer> createdPoolItems = new ArrayList<Integer>();

    public RenameMethodAction(ConstantPool pool, Method method, String name) {
        this.cp = pool;
        this.method = method;
        this.methodName = name;
        this.oldNameIndex = method.getNameIndex();
    }

    public void execute() {
        int nameIndex = this.cp.indexOfUtf8(this.methodName);
        if (nameIndex == -1) {
            nameIndex = this.cp.optionalAddUtf8(this.methodName);
            this.createdPoolItems.add(nameIndex);
        }
        this.method.setNameIndex(nameIndex);
    }

    public void undo() {
        for (int i = 0; i < this.createdPoolItems.size(); ++i) {
            this.cp.removeLast();
        }
        this.method.setNameIndex(this.oldNameIndex);
    }
}

