/*
 * Decompiled with CFR 0.152.
 */
package net.sf.rej.gui.action;

import java.util.ArrayList;
import java.util.List;
import net.sf.rej.gui.Undoable;
import net.sf.rej.java.AccessFlags;
import net.sf.rej.java.ClassFile;
import net.sf.rej.java.Code;
import net.sf.rej.java.Descriptor;
import net.sf.rej.java.Method;
import net.sf.rej.java.MethodFactory;
import net.sf.rej.java.attribute.ExceptionDescriptor;
import net.sf.rej.java.constantpool.ConstantPool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InsertMethodAction
implements Undoable {
    private ClassFile cf;
    private String methodName;
    private Descriptor desc;
    private int maxStackSize;
    private int maxLocals;
    private AccessFlags accessFlags;
    private List<Integer> createdPoolItems = new ArrayList<Integer>();
    private List<String> exceptionNames;
    private Method method = null;
    private static MethodFactory methodFactory = new MethodFactory();

    public InsertMethodAction(ClassFile cf, String methodName, Descriptor desc, AccessFlags accessFlags, int maxStackSize, int maxLocals, List<String> exceptionNames) {
        this.cf = cf;
        this.methodName = methodName;
        this.desc = desc;
        this.maxStackSize = maxStackSize;
        this.maxLocals = maxLocals;
        this.accessFlags = accessFlags;
        this.exceptionNames = exceptionNames;
    }

    @Override
    public void execute() {
        int exAttrNameIndex;
        int codeAttrNameIndex;
        int descIndex;
        ConstantPool cp = this.cf.getPool();
        int nameIndex = cp.indexOfUtf8(this.methodName);
        if (nameIndex == -1) {
            nameIndex = cp.optionalAddUtf8(this.methodName);
            this.createdPoolItems.add(nameIndex);
        }
        if ((descIndex = cp.indexOfUtf8(this.desc.getRawDesc())) == -1) {
            descIndex = cp.optionalAddUtf8(this.desc.getRawDesc());
            this.createdPoolItems.add(descIndex);
        }
        if ((codeAttrNameIndex = cp.indexOfUtf8("Code")) == -1) {
            codeAttrNameIndex = cp.optionalAddUtf8("Code");
            this.createdPoolItems.add(codeAttrNameIndex);
        }
        if ((exAttrNameIndex = cp.indexOfUtf8("Exceptions")) == -1) {
            exAttrNameIndex = cp.optionalAddUtf8("Exceptions");
            this.createdPoolItems.add(exAttrNameIndex);
        }
        ArrayList<ExceptionDescriptor> exceptionList = new ArrayList<ExceptionDescriptor>();
        for (int i = 0; i < this.exceptionNames.size(); ++i) {
            String exceptionName = this.exceptionNames.get(i);
            int exIndex = cp.indexOfClassRef(exceptionName);
            if (exIndex == -1) {
                exIndex = cp.forceAddClassRef(exceptionName);
                this.createdPoolItems.add(exIndex);
            }
            exceptionList.add(new ExceptionDescriptor(cp, exIndex));
        }
        this.method = methodFactory.createMethod(this.cf, this.accessFlags, nameIndex, descIndex, codeAttrNameIndex, this.maxStackSize, this.maxLocals, exAttrNameIndex, exceptionList);
        this.cf.add(this.method);
    }

    @Override
    public void undo() {
        this.cf.remove(this.method);
        for (int i = 0; i < this.createdPoolItems.size(); ++i) {
            this.cf.getPool().removeLast();
        }
    }

    public Code getCode() {
        return this.method.getAttributes().getCode().getCode();
    }
}

