/*
 * Decompiled with CFR 0.152.
 */
package net.sf.rej.gui.action;

import net.sf.rej.gui.Undoable;
import net.sf.rej.java.Code;
import net.sf.rej.java.Method;
import net.sf.rej.java.instruction.Instruction;

public class InsertInstructionAction
implements Undoable {
    private Instruction instruction;
    private int pc;
    private Code code = null;
    private Method method = null;

    public InsertInstructionAction(Instruction instruction, int pc, Code code) {
        this.instruction = instruction;
        this.pc = pc;
        this.code = code;
    }

    public InsertInstructionAction(Instruction instruction, int pc, Method method) {
        this.instruction = instruction;
        this.pc = pc;
        this.method = method;
    }

    public void execute() {
        if (this.method != null) {
            this.code = this.method.getAttributes().getCode().getCode();
        }
        this.code.addInstructionAtPC(this.pc, this.instruction);
        this.code.updateLabelPositions();
    }

    public void undo() {
        if (this.method != null) {
            this.code = this.method.getAttributes().getCode().getCode();
        }
        this.code.remove(this.instruction);
        this.code.updateLabelPositions();
    }
}

