/*
 * Decompiled with CFR 0.152.
 */
package net.sf.rej.gui.action;

import net.sf.rej.gui.Undoable;
import net.sf.rej.java.AccessFlags;
import net.sf.rej.java.ClassFile;
import net.sf.rej.java.Descriptor;
import net.sf.rej.java.Field;
import net.sf.rej.java.FieldFactory;
import net.sf.rej.java.constantpool.ConstantPool;

public class InsertFieldAction
implements Undoable {
    private ClassFile cf;
    private String fieldName;
    private Descriptor desc;
    private AccessFlags accessFlags;
    private int createdNameIndex = -1;
    private int createdDescIndex = -1;
    private Field field = null;
    private static FieldFactory fieldFactory = new FieldFactory();

    public InsertFieldAction(ClassFile cf, String fieldName, Descriptor desc, AccessFlags accessFlags) {
        this.cf = cf;
        this.fieldName = fieldName;
        this.desc = desc;
        this.accessFlags = accessFlags;
    }

    public void execute() {
        int descIndex;
        ConstantPool cp = this.cf.getPool();
        int nameIndex = cp.indexOfUtf8(this.fieldName);
        if (nameIndex == -1) {
            this.createdNameIndex = nameIndex = cp.optionalAddUtf8(this.fieldName);
        }
        if ((descIndex = cp.indexOfUtf8(this.desc.getRawDesc())) == -1) {
            this.createdDescIndex = descIndex = cp.optionalAddUtf8(this.desc.getRawDesc());
        }
        this.field = fieldFactory.createField(this.cf, this.accessFlags, nameIndex, descIndex);
        this.cf.add(this.field);
    }

    public void undo() {
        this.cf.remove(this.field);
        if (this.createdDescIndex != -1) {
            this.cf.getPool().removeLast();
        }
        if (this.createdNameIndex != -1) {
            this.cf.getPool().removeLast();
        }
    }
}

