/*
 * Decompiled with CFR 0.152.
 */
package net.sf.rej.gui.action;

import java.util.ArrayList;
import java.util.List;
import net.sf.rej.gui.Undoable;
import net.sf.rej.java.ClassFile;
import net.sf.rej.java.Code;
import net.sf.rej.java.InstructionCopier;
import net.sf.rej.java.constantpool.ConstantPool;
import net.sf.rej.java.instruction.Instruction;
import net.sf.rej.java.instruction.Label;

public class InsertCodeAction
implements Undoable {
    private ClassFile cf;
    private Code targetCode;
    private int pos;
    private Code newCode;
    private int oldPoolSize = -1;
    private List<Instruction> addedInstructions = new ArrayList<Instruction>();

    public InsertCodeAction(ClassFile cf, Code targetCode, int pos, Code newCode) {
        this.cf = cf;
        this.targetCode = targetCode;
        this.pos = pos;
        this.newCode = newCode;
    }

    public void execute() {
        this.oldPoolSize = this.cf.getPool().size();
        ArrayList<Instruction> list = new ArrayList<Instruction>();
        for (Instruction inst : this.newCode.getInstructions()) {
            list.add(inst);
        }
        InstructionCopier instructionCopier = new InstructionCopier();
        for (Instruction inst : this.newCode.getInstructions()) {
            if (inst instanceof Label) continue;
            Instruction copy = instructionCopier.copyInstruction(inst, this.newCode.createDecompilationContext().getConstantPool(), this.cf.getPool());
            this.addedInstructions.add(copy);
            int index = list.indexOf(inst);
            list.set(index, copy);
            List<Label> labels = inst.getLabels();
            List<Label> copyLabels = copy.getLabels();
            for (int i = 0; i < labels.size(); ++i) {
                Label label = labels.get(i);
                int labelIndex = list.indexOf(label);
                if (labelIndex != -1) {
                    list.set(labelIndex, copyLabels.get(i));
                    continue;
                }
                list.add(copyLabels.get(i));
            }
        }
        this.targetCode.add(this.pos, list);
    }

    public void undo() {
        for (Instruction inst : this.addedInstructions) {
            this.targetCode.remove(inst);
        }
        ConstantPool cp = this.cf.getPool();
        while (cp.size() > this.oldPoolSize) {
            cp.removeLast();
        }
    }
}

