/*
 * Decompiled with CFR 0.152.
 */
package net.sf.rej.gui.action;

import net.sf.rej.gui.Undoable;
import net.sf.rej.java.constantpool.ConstantPool;
import net.sf.rej.java.instruction.Instruction;
import net.sf.rej.java.instruction.Parameters;

public class AddFieldRefAction
implements Undoable {
    private String className;
    private String fieldName;
    private String typeName;
    private Instruction instruction;
    private int paramIndex;
    private ConstantPool pool;
    private int createdNameAndTypeIndex = -1;
    private int createdClassIndex = -1;
    private int createdRefIndex = -1;
    private int originalParamValue = -1;

    public AddFieldRefAction(String className, String fieldName, String typeName, Instruction instruction, int i, ConstantPool pool) {
        this.className = className;
        this.fieldName = fieldName;
        this.typeName = typeName;
        this.instruction = instruction;
        this.paramIndex = i;
        this.pool = pool;
    }

    public void execute() {
        int index = this.pool.indexOfNameAndTypeRef(this.fieldName, this.typeName);
        if (index == -1) {
            this.createdNameAndTypeIndex = this.pool.optionalAddNameAndTypeRef(this.fieldName, this.typeName);
        }
        if ((index = this.pool.indexOfClassRef(this.className)) == -1) {
            this.createdClassIndex = this.pool.optionalAddClassRef(this.className);
        }
        if ((index = this.pool.indexOfFieldRef(this.className, this.fieldName, this.typeName)) == -1) {
            index = this.createdRefIndex = this.pool.optionalAddFieldRef(this.className, this.fieldName, this.typeName);
        }
        Parameters params = this.instruction.getParameters();
        this.originalParamValue = params.getInt(this.paramIndex);
        params.setValue(this.paramIndex, index);
        this.instruction.setParameters(params);
    }

    public void undo() {
        if (this.createdRefIndex != -1) {
            this.pool.removeLast();
        }
        if (this.createdClassIndex != -1) {
            this.pool.removeLast();
        }
        if (this.createdNameAndTypeIndex != -1) {
            this.pool.removeLast();
        }
        Parameters params = this.instruction.getParameters();
        params.setValue(this.paramIndex, this.originalParamValue);
        this.instruction.setParameters(params);
    }
}

