/*
 * Decompiled with CFR 0.152.
 */
package net.sf.rej.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.DefaultButtonModel;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sf.rej.files.ClassIndex;
import net.sf.rej.files.ClassLocator;
import net.sf.rej.files.Project;
import net.sf.rej.gui.ConstantPoolTranslationMode;
import net.sf.rej.gui.EditorFacade;
import net.sf.rej.gui.Link;
import net.sf.rej.gui.OpenRecentFileAction;
import net.sf.rej.gui.SystemFacade;
import net.sf.rej.gui.debug.DebugControlPanel;
import net.sf.rej.gui.dialog.ClassChooseDialog;
import net.sf.rej.gui.dialog.NewClassDialog;
import net.sf.rej.gui.event.Event;
import net.sf.rej.gui.event.EventDispatcher;
import net.sf.rej.gui.event.EventObserver;
import net.sf.rej.gui.event.EventType;
import net.sf.rej.gui.preferences.Preferences;
import net.sf.rej.gui.preferences.Settings;
import net.sf.rej.gui.split.BytecodeToHexSync;
import net.sf.rej.gui.split.ConstantPoolToHexSync;
import net.sf.rej.gui.split.HexSplit;
import net.sf.rej.gui.split.SplitMode;
import net.sf.rej.gui.split.StructureToHexSync;
import net.sf.rej.gui.tab.CompareTab;
import net.sf.rej.gui.tab.ConstantPoolTab;
import net.sf.rej.gui.tab.DebugTab;
import net.sf.rej.gui.tab.EditorTab;
import net.sf.rej.gui.tab.FilesTab;
import net.sf.rej.gui.tab.HexEditorTab;
import net.sf.rej.gui.tab.InjectionTab;
import net.sf.rej.gui.tab.NoDebugTab;
import net.sf.rej.gui.tab.ObfuscationTab;
import net.sf.rej.gui.tab.SearchTab;
import net.sf.rej.gui.tab.StructureTab;
import net.sf.rej.gui.tab.Tab;
import net.sf.rej.gui.tab.Tabbable;
import net.sf.rej.java.ClassFile;

public class MainWindow
extends JFrame
implements EventObserver {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(MainWindow.class.getName());
    static MainWindow instance;
    BorderLayout borderLayout1 = new BorderLayout();
    JToolBar toolbar = new JToolBar();
    JTabbedPane tabbedPane = new JTabbedPane();
    DebugControlPanel debugPanel = null;
    JMenuBar menuBar = new JMenuBar();
    JMenu fileMenu = null;
    JMenu recentFilesMenu = null;
    JLabel status = new JLabel();
    JSplitPane splitPane = null;
    SplitMode split = SplitMode.NONE;
    HexSplit hexSplit = new HexSplit();
    EventDispatcher dispatcher = new EventDispatcher();
    JFileChooser fd = new JFileChooser();
    private Project project = null;
    private FilesTab filesTab = new FilesTab();
    private StructureTab structureTab = new StructureTab();
    private ConstantPoolTab constantPoolTab = new ConstantPoolTab();
    private EditorTab editorTab = new EditorTab();
    private InjectionTab injectionTab = new InjectionTab();
    private ObfuscationTab obfuscationTab = new ObfuscationTab();
    private SearchTab searchTab = new SearchTab();
    private CompareTab compareTab = new CompareTab();
    private Tabbable debugTab = this.createDebugTab();
    private HexEditorTab hexTab = new HexEditorTab();
    Map<JCheckBoxMenuItem, Tab> viewCheckBoxes = new HashMap<JCheckBoxMenuItem, Tab>();
    private Action tabViewAction = new AbstractAction(){

        public void actionPerformed(ActionEvent e) {
            JCheckBoxMenuItem checkBox = (JCheckBoxMenuItem)e.getSource();
            Tab tab = MainWindow.this.viewCheckBoxes.get(checkBox);
            Tabbable tabComponent = MainWindow.this.getTab(tab);
            boolean tabVisible = MainWindow.this.isTabVisible(tabComponent);
            try {
                if (checkBox.isSelected() && !tabVisible) {
                    MainWindow.this.ensureTabIsVisible(tabComponent);
                    Preferences prefs = SystemFacade.getInstance().getPreferences();
                    prefs.setTabVisibility(tab, true);
                    prefs.save();
                } else if (!checkBox.isSelected() && tabVisible) {
                    MainWindow.this.hideTab(tabComponent);
                    Preferences prefs = SystemFacade.getInstance().getPreferences();
                    prefs.setTabVisibility(tab, false);
                    prefs.save();
                }
            }
            catch (Exception ex) {
                SystemFacade.getInstance().handleException(ex);
            }
        }
    };
    private Action newProjectAction = new AbstractAction("Project.."){

        public void actionPerformed(ActionEvent e) {
            MainWindow.this.fd.setFileSelectionMode(0);
            MainWindow.this.fd.setDialogType(1);
            MainWindow.this.fd.setDialogTitle("Select Archive file to create");
            int i = MainWindow.this.fd.showDialog(instance, "Create");
            if (i == 0) {
                SystemFacade.getInstance().createNewArchiveProject(MainWindow.this.fd.getSelectedFile());
            }
        }
    };
    private Action newClassAction = new AbstractAction("Class.."){

        public void actionPerformed(ActionEvent e) {
            if (MainWindow.this.project != null) {
                NewClassDialog dialog = new NewClassDialog(MainWindow.this);
                dialog.invoke();
                if (!dialog.userCancelled()) {
                    SystemFacade.getInstance().createNewClass(dialog.getFullClassName(), dialog.getSelectedFile());
                }
            }
        }
    };
    private Action openAction = new AbstractAction("Open.."){

        public void actionPerformed(ActionEvent e) {
            MainWindow.this.fd.setFileSelectionMode(2);
            MainWindow.this.fd.setDialogType(0);
            MainWindow.this.fd.setDialogTitle("Select java .class file, an archive or a folder.");
            int i = MainWindow.this.fd.showDialog(instance, "Open");
            if (i == 0) {
                SystemFacade.getInstance().openFile(MainWindow.this.fd.getSelectedFile());
            }
        }
    };
    private Action saveAction = new AbstractAction("Save"){

        public void actionPerformed(ActionEvent e) {
            SystemFacade.getInstance().saveFile();
        }
    };
    private Action saveAsAction = new AbstractAction("Save as.."){

        public void actionPerformed(ActionEvent e) {
            MainWindow.this.fd.setFileSelectionMode(2);
            MainWindow.this.fd.setDialogType(1);
            MainWindow.this.fd.setDialogTitle("Save class or file set.");
            int i = MainWindow.this.fd.showDialog(instance, "Save");
            if (i == 0) {
                SystemFacade.getInstance().saveFile(MainWindow.this.fd.getSelectedFile());
            }
        }
    };
    private Action exitAction = new AbstractAction("Exit"){

        public void actionPerformed(ActionEvent e) {
            SystemFacade.getInstance().exit();
        }
    };
    private Action undoAction = new AbstractAction("Undo"){

        public void actionPerformed(ActionEvent e) {
            Tabbable tab = MainWindow.this.getSelectedTab();
            if (tab != null) {
                tab.undo();
            }
        }
    };
    private Action redoAction = new AbstractAction("Redo"){

        public void actionPerformed(ActionEvent e) {
            Tabbable tab = MainWindow.this.getSelectedTab();
            if (tab != null) {
                tab.redo();
            }
        }
    };
    private Action outlineAction = new AbstractAction("Quick Outline.."){

        public void actionPerformed(ActionEvent e) {
            Tabbable tab = MainWindow.this.getSelectedTab();
            if (tab != null) {
                tab.outline();
            }
        }
    };
    private Action openTypeAction = new AbstractAction("Open Type.."){

        public void actionPerformed(ActionEvent e) {
            if (MainWindow.this.project == null) {
                return;
            }
            ClassIndex ci = SystemFacade.getInstance().getClassIndex();
            ClassChooseDialog ccd = new ClassChooseDialog((Frame)MainWindow.this, ci);
            ccd.setTitle("Open Type..");
            ccd.invoke();
            ClassLocator cl = ccd.getSelected();
            if (cl != null) {
                try {
                    Event event = new Event(EventType.CLASS_OPEN);
                    ClassFile cf = SystemFacade.getInstance().getClassFile(cl);
                    event.setClassFile(cf);
                    event.setFile(cl.getFile());
                    MainWindow.this.dispatcher.notifyObservers(event);
                    MainWindow.this.setTab(Tab.EDITOR);
                }
                catch (Exception ioe) {
                    SystemFacade.getInstance().handleException(ioe);
                }
            }
        }
    };
    private Action goToAction = new AbstractAction("Go to.."){

        public void actionPerformed(ActionEvent e) {
            int selection = JOptionPane.showOptionDialog(MainWindow.this, "Go to..", "Go to..", 2, 1, null, new String[]{"Source line number", "pc offset"}, "Source line number");
            Link link = null;
            switch (selection) {
                case 0: {
                    String positionStr = JOptionPane.showInputDialog(MainWindow.this, (Object)"Source line number to go to:");
                    if (positionStr == null) break;
                    int pos = Integer.parseInt(positionStr);
                    link = new Link();
                    link.setAnchor(7);
                    link.setTab(Tab.EDITOR);
                    link.setPosition(pos);
                    break;
                }
                case 1: {
                    String positionStr = JOptionPane.showInputDialog(MainWindow.this, (Object)"Method pc offset to go to:");
                    if (positionStr == null) break;
                    int pos = Integer.parseInt(positionStr);
                    link = new Link();
                    link.setAnchor(6);
                    link.setTab(Tab.EDITOR);
                    link.setPosition(pos);
                }
            }
            if (link != null) {
                SystemFacade.getInstance().goTo(link);
            }
        }
    };
    private Action insertAction = new AbstractAction("Insert.."){

        public void actionPerformed(ActionEvent e) {
            Tabbable tab = MainWindow.this.getSelectedTab();
            if (tab != null) {
                tab.insert();
            }
        }
    };
    private Action removeAction = new AbstractAction("Remove"){

        public void actionPerformed(ActionEvent e) {
            Tabbable tab = MainWindow.this.getSelectedTab();
            if (tab != null) {
                tab.remove();
            }
        }
    };
    private Action findAction = new AbstractAction("Find.."){

        public void actionPerformed(ActionEvent e) {
            Tabbable tab = MainWindow.this.getSelectedTab();
            if (tab != null) {
                tab.find();
            }
        }
    };
    private Action findNextAction = new AbstractAction("Find next"){

        public void actionPerformed(ActionEvent e) {
            Tabbable tab = MainWindow.this.getSelectedTab();
            if (tab != null) {
                tab.findNext();
            }
        }
    };
    private Action splitOffAction = new AbstractAction("None"){

        public void actionPerformed(ActionEvent e) {
            MainWindow.this.clearContentPane();
            MainWindow.this.hexSplit.setActive(false);
            MainWindow.this.getContentPane().add((Component)MainWindow.this.tabbedPane, "Center");
            MainWindow.this.getContentPane().validate();
            MainWindow.this.split = SplitMode.NONE;
        }
    };
    private Action splitHexAction = new AbstractAction("Hex View"){

        public void actionPerformed(ActionEvent e) {
            MainWindow.this.splitPane = new JSplitPane(0, MainWindow.this.hexSplit, MainWindow.this.tabbedPane);
            MainWindow.this.hexSplit.setActive(true);
            MainWindow.this.clearContentPane();
            MainWindow.this.getContentPane().add((Component)MainWindow.this.splitPane, "Center");
            MainWindow.this.getContentPane().validate();
            MainWindow.this.split = SplitMode.HEX;
            MainWindow.this.editorTab.setSplitSynchronizer(new BytecodeToHexSync(MainWindow.this.hexSplit));
            MainWindow.this.structureTab.setSplitSynchronizer(new StructureToHexSync(MainWindow.this.hexSplit));
            MainWindow.this.constantPoolTab.setSplitSynchronizer(new ConstantPoolToHexSync(MainWindow.this.hexSplit));
        }
    };
    private Action splitSourceAction = new AbstractAction("Java Source View"){

        public void actionPerformed(ActionEvent e) {
            MainWindow.this.splitPane = new JSplitPane(0, new JPanel(), MainWindow.this.tabbedPane);
            MainWindow.this.clearContentPane();
            MainWindow.this.getContentPane().add((Component)MainWindow.this.splitPane, "Center");
            MainWindow.this.getContentPane().validate();
            MainWindow.this.split = SplitMode.SOURCE;
        }
    };
    private Action cpTranslationOff = new AbstractAction("No translation"){

        public void actionPerformed(ActionEvent e) {
            EditorFacade.getInstance().setConstantPoolTranslationMode(ConstantPoolTranslationMode.OFF);
        }
    };
    private Action cpTranslationNormal = new AbstractAction("Translation"){

        public void actionPerformed(ActionEvent e) {
            EditorFacade.getInstance().setConstantPoolTranslationMode(ConstantPoolTranslationMode.TRANSLATION);
        }
    };
    private Action cpTranslationHybrid = new AbstractAction("Hybrid"){

        public void actionPerformed(ActionEvent e) {
            EditorFacade.getInstance().setConstantPoolTranslationMode(ConstantPoolTranslationMode.HYBRID);
        }
    };
    private Action lineIdOff = new AbstractAction("Off"){

        public void actionPerformed(ActionEvent e) {
            EditorFacade.getInstance().setLineMode(0);
        }
    };
    private Action lineIdPC = new AbstractAction("PC"){

        public void actionPerformed(ActionEvent e) {
            EditorFacade.getInstance().setLineMode(1);
        }
    };
    private Action lineIdSrc = new AbstractAction("Sourcecode line"){

        public void actionPerformed(ActionEvent e) {
            EditorFacade.getInstance().setLineMode(2);
        }
    };
    private Action preferencesAction = new AbstractAction("Preferences.."){

        public void actionPerformed(ActionEvent e) {
            SystemFacade.getInstance().showPreferencesDialog();
        }
    };
    private Action compareAction = new AbstractAction("Compare.."){

        public void actionPerformed(ActionEvent e) {
            MainWindow.this.setTab(Tab.COMPARE);
        }
    };
    private Action extendsObjectAction = new AbstractAction("Display \"extends Object\""){

        public void actionPerformed(ActionEvent e) {
            try {
                Preferences prefs = SystemFacade.getInstance().getPreferences();
                prefs.invertSetting(Settings.DISPLAY_EXTENDS_OBJECT);
                prefs.save();
                MainWindow.this.dispatcher.notifyObservers(new Event(EventType.DISPLAY_PARAMETER_UPDATE));
            }
            catch (Exception ex) {
                SystemFacade.getInstance().handleException(ex);
            }
        }
    };
    private Action showGenericsAction = new AbstractAction("Display Generics"){

        public void actionPerformed(ActionEvent e) {
            try {
                Preferences prefs = SystemFacade.getInstance().getPreferences();
                prefs.invertSetting(Settings.DISPLAY_GENERICS);
                prefs.save();
                MainWindow.this.dispatcher.notifyObservers(new Event(EventType.DISPLAY_PARAMETER_UPDATE));
            }
            catch (Exception ex) {
                SystemFacade.getInstance().handleException(ex);
            }
        }
    };
    private Action showVarargsAction = new AbstractAction("Display Varargs"){

        public void actionPerformed(ActionEvent e) {
            try {
                Preferences prefs = SystemFacade.getInstance().getPreferences();
                prefs.invertSetting(Settings.DISPLAY_VARARGS);
                prefs.save();
                MainWindow.this.dispatcher.notifyObservers(new Event(EventType.DISPLAY_PARAMETER_UPDATE));
            }
            catch (Exception ex) {
                SystemFacade.getInstance().handleException(ex);
            }
        }
    };
    JPanel progressAndStatusPanel = new JPanel();
    JProgressBar progress = new JProgressBar();
    GridLayout gridLayout1 = new GridLayout();

    public MainWindow() {
        super("reJ");
        this.setDefaultCloseOperation(0);
        this.tabbedPane.addChangeListener(new ChangeListener(){
            Tabbable lastTab = null;

            public void stateChanged(ChangeEvent e) {
                if (this.lastTab != null) {
                    this.lastTab.leavingTab();
                }
                this.lastTab = (Tabbable)((Object)MainWindow.this.tabbedPane.getSelectedComponent());
                if (this.lastTab != null) {
                    this.lastTab.enteringTab();
                }
            }
        });
        this.fd.setFileHidingEnabled(false);
        try {
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent we) {
                    SystemFacade.getInstance().exit();
                }
            });
            this.setJMenuBar(this.menuBar);
            this.setState(0);
            this.getContentPane().setLayout(this.borderLayout1);
            this.status.setText("Situation under control.");
            this.clearContentPane();
            this.getContentPane().add((Component)this.tabbedPane, "Center");
            this.progressAndStatusPanel.setLayout(this.gridLayout1);
            this.gridLayout1.setRows(2);
            this.progressAndStatusPanel.add((Component)this.progress, null);
            this.progressAndStatusPanel.add((Component)this.status, null);
            this.populateToolbar();
            this.createMenu();
            this.setVisible(true);
            this.pack();
            this.setExtendedState(6);
            this.dispatcher.registerObserver(this);
            this.dispatcher.registerObserver(this.compareTab);
            this.dispatcher.registerObserver(this.constantPoolTab);
            if (this.debugTab instanceof EventObserver) {
                this.dispatcher.registerObserver((EventObserver)((Object)this.debugTab));
            }
            this.dispatcher.registerObserver(EditorFacade.getInstance());
            this.dispatcher.registerObserver(this.editorTab);
            this.dispatcher.registerObserver(this.hexTab);
            this.dispatcher.registerObserver(this.filesTab);
            this.dispatcher.registerObserver(this.obfuscationTab);
            this.dispatcher.registerObserver(this.structureTab);
            this.dispatcher.registerObserver(SystemFacade.getInstance());
            this.dispatcher.registerObserver(this.hexSplit);
            this.conditionalSetVisible(Tab.COMPARE);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void clearContentPane() {
        this.getContentPane().removeAll();
        this.getContentPane().add((Component)this.toolbar, "North");
        this.getContentPane().add((Component)this.progressAndStatusPanel, "South");
    }

    private void createMenu() {
        this.fileMenu = new JMenu("File");
        this.menuBar.add(this.fileMenu);
        JMenu newMenu = new JMenu("New");
        newMenu.add(this.newProjectAction);
        newMenu.add(this.newClassAction);
        this.fileMenu.add(newMenu);
        this.fileMenu.add(new JMenuItem(this.openAction));
        JMenuItem item = new JMenuItem(this.saveAction);
        this.fileMenu.add(item);
        item.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.fileMenu.add(new JMenuItem(this.saveAsAction));
        this.fileMenu.add(new JSeparator());
        this.recentFilesMenu = new JMenu("Recent Files");
        this.updateRecentFilesMenu();
        this.fileMenu.add(this.recentFilesMenu);
        this.fileMenu.add(new JSeparator());
        this.fileMenu.add(new JMenuItem(this.exitAction));
        this.updateRecentFilesMenu();
        JMenu editMenu = new JMenu("Edit");
        this.menuBar.add(editMenu);
        item = new JMenuItem(this.undoAction);
        item.setAccelerator(KeyStroke.getKeyStroke(90, 2));
        editMenu.add(item);
        item = new JMenuItem(this.redoAction);
        item.setAccelerator(KeyStroke.getKeyStroke(89, 2));
        editMenu.add(item);
        editMenu.add(new JSeparator());
        editMenu.add(new JMenuItem(this.insertAction));
        item = new JMenuItem(this.removeAction);
        item.setAccelerator(KeyStroke.getKeyStroke(127, 0));
        editMenu.add(item);
        editMenu.add(new JSeparator());
        item = new JMenuItem(this.findAction);
        item.setAccelerator(KeyStroke.getKeyStroke(70, 128));
        editMenu.add(item);
        item = new JMenuItem(this.findNextAction);
        item.setAccelerator(KeyStroke.getKeyStroke(114, 0));
        editMenu.add(item);
        JMenu navigate = new JMenu("Navigate");
        this.menuBar.add(navigate);
        item = new JMenuItem(this.openTypeAction);
        item.setAccelerator(KeyStroke.getKeyStroke(84, 192));
        navigate.add(item);
        item = new JMenuItem(this.outlineAction);
        item.setAccelerator(KeyStroke.getKeyStroke(79, 128));
        navigate.add(item);
        item = new JMenuItem(this.goToAction);
        item.setAccelerator(KeyStroke.getKeyStroke(71, 128));
        navigate.add(item);
        JMenu view = new JMenu("View");
        this.menuBar.add(view);
        JMenu sub = new JMenu("Line identifier");
        ButtonGroup bg = new ButtonGroup();
        JRadioButtonMenuItem btn = new JRadioButtonMenuItem(this.lineIdOff);
        bg.add(btn);
        sub.add(btn);
        btn = new JRadioButtonMenuItem(this.lineIdPC);
        btn.setSelected(true);
        bg.add(btn);
        sub.add(btn);
        btn = new JRadioButtonMenuItem(this.lineIdSrc);
        bg.add(btn);
        sub.add(btn);
        view.add(sub);
        JMenu translation = new JMenu("Reference Translation");
        bg = new ButtonGroup();
        btn = new JRadioButtonMenuItem(this.cpTranslationOff);
        bg.add(btn);
        translation.add(btn);
        btn = new JRadioButtonMenuItem(this.cpTranslationNormal);
        btn.setSelected(true);
        bg.add(btn);
        translation.add(btn);
        btn = new JRadioButtonMenuItem(this.cpTranslationHybrid);
        bg.add(btn);
        translation.add(btn);
        view.add(translation);
        JMenu split = new JMenu("Split Mode");
        bg = new ButtonGroup();
        btn = new JRadioButtonMenuItem(this.splitOffAction);
        btn.setSelected(true);
        bg.add(btn);
        split.add(btn);
        btn = new JRadioButtonMenuItem(this.splitHexAction);
        bg.add(btn);
        split.add(btn);
        btn = new JRadioButtonMenuItem(this.splitSourceAction);
        bg.add(btn);
        split.add(btn);
        view.add(split);
        view.add(new JSeparator());
        JCheckBoxMenuItem extendsObject = new JCheckBoxMenuItem(this.extendsObjectAction);
        extendsObject.setModel(new DefaultButtonModel(){

            public boolean isSelected() {
                Preferences prefs = SystemFacade.getInstance().getPreferences();
                return prefs.getSetting(Settings.DISPLAY_EXTENDS_OBJECT, Boolean.class);
            }
        });
        view.add(extendsObject);
        JCheckBoxMenuItem showGenerics = new JCheckBoxMenuItem(this.showGenericsAction);
        showGenerics.setModel(new DefaultButtonModel(){

            public boolean isSelected() {
                Preferences prefs = SystemFacade.getInstance().getPreferences();
                return prefs.getSetting(Settings.DISPLAY_GENERICS, Boolean.class);
            }
        });
        view.add(showGenerics);
        JCheckBoxMenuItem showVarargs = new JCheckBoxMenuItem(this.showVarargsAction);
        showVarargs.setModel(new DefaultButtonModel(){

            public boolean isSelected() {
                Preferences prefs = SystemFacade.getInstance().getPreferences();
                return prefs.getSetting(Settings.DISPLAY_VARARGS, Boolean.class);
            }
        });
        view.add(showVarargs);
        view.add(new JSeparator());
        JCheckBoxMenuItem box = new JCheckBoxMenuItem(this.tabViewAction);
        box.setText(this.structureTab.getTabTitle());
        view.add(box);
        this.viewCheckBoxes.put(box, Tab.STRUCTURE);
        box = new JCheckBoxMenuItem(this.tabViewAction);
        box.setText(this.hexTab.getTabTitle());
        view.add(box);
        this.viewCheckBoxes.put(box, Tab.HEX);
        box = new JCheckBoxMenuItem(this.tabViewAction);
        box.setText(this.constantPoolTab.getTabTitle());
        view.add(box);
        this.viewCheckBoxes.put(box, Tab.CONSTANTPOOL);
        box = new JCheckBoxMenuItem(this.tabViewAction);
        box.setText(this.editorTab.getTabTitle());
        view.add(box);
        this.viewCheckBoxes.put(box, Tab.EDITOR);
        box = new JCheckBoxMenuItem(this.tabViewAction);
        box.setText(this.obfuscationTab.getTabTitle());
        view.add(box);
        this.viewCheckBoxes.put(box, Tab.OBFUSCATION);
        box = new JCheckBoxMenuItem(this.tabViewAction);
        box.setText(this.searchTab.getTabTitle());
        view.add(box);
        this.viewCheckBoxes.put(box, Tab.SEARCH);
        box = new JCheckBoxMenuItem(this.tabViewAction);
        box.setText(this.debugTab.getTabTitle());
        view.add(box);
        this.viewCheckBoxes.put(box, Tab.DEBUG);
        box = new JCheckBoxMenuItem(this.tabViewAction);
        box.setText(this.compareTab.getTabTitle());
        view.add(box);
        this.viewCheckBoxes.put(box, Tab.COMPARE);
        for (JCheckBoxMenuItem chkBox : this.viewCheckBoxes.keySet()) {
            chkBox.setSelected(false);
        }
        JMenu tools = new JMenu("Tools");
        this.menuBar.add(tools);
        item = new JMenuItem(this.preferencesAction);
        tools.add(item);
        item = new JMenuItem(this.compareAction);
        tools.add(item);
    }

    public void updateRecentFilesMenu() {
        this.recentFilesMenu.removeAll();
        List list = SystemFacade.getInstance().getRecentFiles();
        for (int i = 0; i < list.size(); ++i) {
            File file = new File((String)list.get(i));
            this.recentFilesMenu.add(new JMenuItem(new OpenRecentFileAction(file)));
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length > 0 && args[0].equalsIgnoreCase("-debug")) {
            FileHandler fh = new FileHandler("reJ.log");
            Logger.getLogger("net.sf.rej").addHandler(fh);
            Logger.getLogger("net.sf.rej").setLevel(Level.FINEST);
        } else if (args.length <= 0 || !args[0].equalsIgnoreCase("-nolog")) {
            FileHandler fh = new FileHandler("reJ.log");
            Logger.getLogger("net.sf.rej").addHandler(fh);
            Logger.getLogger("net.sf.rej").setLevel(Level.WARNING);
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                instance = new MainWindow();
            }
        });
    }

    public static MainWindow getInstance() {
        return instance;
    }

    public void processEvent(Event event) {
        if (event.getType() == EventType.PROJECT_UPDATE) {
            this.project = event.getProject();
            if (this.project != null) {
                this.insertControlTabs();
            } else {
                this.tabbedPane.removeAll();
                for (JCheckBoxMenuItem item : this.viewCheckBoxes.keySet()) {
                    item.setSelected(true);
                }
                this.ensureTabIsVisible(this.filesTab);
            }
        } else if (event.getType() == EventType.CLASS_OPEN && event.getFile() != null) {
            this.insertConditionalTabs();
            this.selectFileRelatedTab();
        } else if (event.getType() == EventType.DEBUG_STACK_FRAME_CHANGED) {
            this.insertConditionalTabs();
            this.setTab(Tab.EDITOR);
        } else if (event.getType() == EventType.DEBUG_ATTACH) {
            this.splitPane = new JSplitPane(0, this.getDebugPanel(), this.tabbedPane);
            this.getContentPane().remove(this.tabbedPane);
            this.getContentPane().add((Component)this.splitPane, "Center");
            this.getContentPane().validate();
        } else if (event.getType() == EventType.DEBUG_DETACH) {
            this.getContentPane().remove(this.splitPane);
            this.getContentPane().add((Component)this.tabbedPane, "Center");
            this.getContentPane().validate();
        }
    }

    private void insertControlTabs() {
        this.ensureTabIsVisible(this.filesTab);
        this.conditionalSetVisible(Tab.SEARCH);
        this.conditionalSetVisible(Tab.DEBUG);
    }

    private void insertConditionalTabs() {
        this.conditionalSetVisible(Tab.STRUCTURE);
        this.conditionalSetVisible(Tab.CONSTANTPOOL);
        this.conditionalSetVisible(Tab.EDITOR);
        this.conditionalSetVisible(Tab.HEX);
        this.conditionalSetVisible(Tab.OBFUSCATION);
    }

    private void selectFileRelatedTab() {
        if (this.tabbedPane.indexOfComponent(this.editorTab) != -1) {
            this.setTab(Tab.EDITOR);
        } else if (this.tabbedPane.indexOfComponent(this.structureTab) != -1) {
            this.setTab(Tab.STRUCTURE);
        } else if (this.tabbedPane.indexOfComponent(this.hexTab) != -1) {
            this.setTab(Tab.HEX);
        } else if (this.tabbedPane.indexOfComponent(this.constantPoolTab) != -1) {
            this.setTab(Tab.CONSTANTPOOL);
        } else {
            this.setTab(Tab.EDITOR);
        }
    }

    private void conditionalSetVisible(Tab tab) {
        Preferences prefs = SystemFacade.getInstance().getPreferences();
        if (prefs.isTabVisible(tab)) {
            this.ensureTabIsVisible(this.getTab(tab));
        }
    }

    private void ensureTabIsVisible(Tabbable tab) {
        if (!this.isTabVisible(tab)) {
            this.tabbedPane.addTab(tab.getTabTitle(), (Component)((Object)tab));
            for (Map.Entry<JCheckBoxMenuItem, Tab> set : this.viewCheckBoxes.entrySet()) {
                if (this.getTab(set.getValue()) != tab) continue;
                set.getKey().setSelected(true);
            }
        }
    }

    public Tabbable getSelectedTab() {
        return (Tabbable)((Object)this.tabbedPane.getSelectedComponent());
    }

    public void setProgress(final int i) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                MainWindow.this.progress.setValue(i);
            }
        });
    }

    public void setProgressScope(final int min, final int max) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                MainWindow.this.progress.setMinimum(min);
                MainWindow.this.progress.setMaximum(max);
                MainWindow.this.progress.setValue(min);
            }
        });
    }

    public void setStatus(String status) {
        this.status.setText(status);
    }

    public void showErrorMessage(String message) {
        JOptionPane.showMessageDialog(this, message, "Error", 0);
    }

    public void setTab(Tab tab) {
        Tabbable tabbable = this.getTab(tab);
        this.ensureTabIsVisible(tabbable);
        this.tabbedPane.setSelectedComponent((Component)((Object)tabbable));
    }

    public void hideTab(Tabbable tab) {
        this.tabbedPane.remove((Component)((Object)tab));
    }

    public boolean isTabVisible(Tab tab) {
        return this.isTabVisible(this.getTab(tab));
    }

    public boolean isTabVisible(Tabbable tab) {
        return this.tabbedPane.indexOfComponent((Component)((Object)tab)) != -1;
    }

    public Tabbable getTab(Tab tab) {
        switch (tab) {
            case FILES: {
                return this.filesTab;
            }
            case STRUCTURE: {
                return this.structureTab;
            }
            case CONSTANTPOOL: {
                return this.constantPoolTab;
            }
            case EDITOR: {
                return this.editorTab;
            }
            case HEX: {
                return this.hexTab;
            }
            case INJECTION: {
                return this.injectionTab;
            }
            case SEARCH: {
                return this.searchTab;
            }
            case OBFUSCATION: {
                return this.obfuscationTab;
            }
            case COMPARE: {
                return this.compareTab;
            }
            case DEBUG: {
                return this.debugTab;
            }
        }
        return null;
    }

    public SearchTab getSearchTab() {
        return this.searchTab;
    }

    public HexEditorTab getHexTab() {
        return this.hexTab;
    }

    public void populateToolbar() {
        this.toolbar.removeAll();
        this.toolbar.add(this.openAction);
        this.toolbar.add(this.saveAction);
        this.toolbar.add(this.saveAsAction);
        this.toolbar.add(new JSeparator());
        this.toolbar.add(this.insertAction);
        this.toolbar.add(this.removeAction);
        this.toolbar.add(new JSeparator());
        this.toolbar.add(this.findAction);
        this.toolbar.add(new JSeparator());
        this.toolbar.add(this.exitAction);
    }

    private Tabbable createDebugTab() {
        try {
            Class<?> c = Class.forName("com.sun.jdi.Bootstrap");
            return new DebugTab();
        }
        catch (ClassNotFoundException ncdfe) {
            logger.warning("Class com.sun.jdi.Bootstrap not found. Probably due to the fact that JDI library (tools.jar) is not on classpath. In order to have debugging support, please correct this and restart reJ.");
            return new NoDebugTab();
        }
    }

    public Tabbable getDebugTab() {
        return this.debugTab;
    }

    public EditorTab getEditorTab() {
        return this.editorTab;
    }

    private JPanel getDebugPanel() {
        if (this.debugPanel == null) {
            this.debugPanel = new DebugControlPanel();
            this.dispatcher.registerObserver(this.debugPanel);
        }
        return this.debugPanel;
    }
}

