/*
 * Decompiled with CFR 0.152.
 */
package net.sf.rej.gui;

import javax.swing.SwingUtilities;
import net.sf.rej.AbstractIteratorAgent;
import net.sf.rej.gui.IterationContext;
import net.sf.rej.gui.Link;
import net.sf.rej.gui.SystemFacade;
import net.sf.rej.gui.tab.Tab;
import net.sf.rej.java.ClassFile;
import net.sf.rej.java.Field;
import net.sf.rej.java.LocalVariable;
import net.sf.rej.java.Method;
import net.sf.rej.java.attribute.Attribute;
import net.sf.rej.java.constantpool.ConstantPoolInfo;
import net.sf.rej.java.instruction.Instruction;

public abstract class DefaultMatcher
extends AbstractIteratorAgent {
    protected int resultCount = 0;

    public abstract boolean matches(String var1);

    public abstract void addLink(Link var1);

    private void addResult(Link link) {
        ++this.resultCount;
        this.addLink(link);
    }

    public void processClass(IterationContext ic, ClassFile cf) {
        String superClassName;
        if (this.matches(cf.getFullClassName())) {
            Link link = new Link();
            link.setText("Type name : " + ic.getCf().getFullClassName());
            link.setAnchor(1);
            link.setProject(ic.getProject());
            link.setFile(ic.getFilename());
            link.setTab(Tab.EDITOR);
            this.addResult(link);
        }
        if ((superClassName = cf.getSuperClassName()) != null && this.matches(superClassName)) {
            Link link = new Link();
            link.setText("Superclass name : " + ic.getCf().getFullClassName());
            link.setAnchor(1);
            link.setProject(ic.getProject());
            link.setFile(ic.getFilename());
            link.setTab(Tab.EDITOR);
            this.addResult(link);
        }
    }

    public void processFile(String filename) {
        SystemFacade.getInstance().setStatus("Searching " + filename + " ...");
    }

    public void processInterface(IterationContext ic, String interfaceName) {
        if (this.matches(interfaceName)) {
            Link link = new Link();
            link.setText("Interface name : " + ic.getCf().getFullClassName());
            link.setAnchor(1);
            link.setProject(ic.getProject());
            link.setFile(ic.getFilename());
            link.setTab(Tab.EDITOR);
            this.addResult(link);
        }
    }

    public void processField(IterationContext ic, Field field) {
        if (this.matches(field.getSignatureLine())) {
            Link link = new Link();
            link.setText("Field signature : " + ic.getCf().getFullClassName() + "." + field.getName());
            link.setAnchor(2);
            link.setProject(ic.getProject());
            link.setFile(ic.getFilename());
            link.setTab(Tab.EDITOR);
            link.setField(field);
            this.addResult(link);
        }
    }

    public void processMethod(IterationContext ic, Method method) {
        if (this.matches(method.getSignatureLine())) {
            Link link = new Link();
            link.setText("Method signature : " + ic.getCf().getFullClassName() + "." + method.getName());
            link.setAnchor(3);
            link.setProject(ic.getProject());
            link.setFile(ic.getFilename());
            link.setTab(Tab.EDITOR);
            link.setMethod(method);
            this.addResult(link);
        }
    }

    public void processLocalVariable(IterationContext ic, LocalVariable lv) {
        if (this.matches(lv.getSignatureLine())) {
            Link link = new Link();
            link.setText("Local variable : " + ic.getCf().getFullClassName() + "." + ic.getMethod().getName() + " / " + lv.getName());
            link.setAnchor(5);
            link.setProject(ic.getProject());
            link.setFile(ic.getFilename());
            link.setTab(Tab.EDITOR);
            link.setMethod(ic.getMethod());
            link.setLv(lv);
            this.addResult(link);
        }
    }

    public void processInstruction(IterationContext ic, Instruction instruction) {
        String instructionLine = instruction.getMnemonic() + " " + instruction.getParameters().getString(ic.getDc());
        if (this.matches(instructionLine)) {
            Link link = new Link();
            link.setText("Instruction : " + ic.getCf().getFullClassName() + "." + ic.getMethod().getName() + " / " + instructionLine);
            link.setAnchor(4);
            link.setProject(ic.getProject());
            link.setFile(ic.getFilename());
            link.setTab(Tab.EDITOR);
            link.setMethod(ic.getMethod());
            link.setPosition(ic.getDc().getPosition());
            this.addResult(link);
        }
    }

    public void finished(IterationContext ic, final int totalCount) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SystemFacade.getInstance().setStatus("Search done. Searched in " + totalCount + " files. Found " + DefaultMatcher.this.resultCount + " results.");
            }
        });
    }

    public void processAttribute(IterationContext ic, Attribute attr) {
    }

    public void processConstantPoolInfo(IterationContext ic, ConstantPoolInfo cpi) {
    }

    public void postProcessFile(IterationContext ic) {
    }

    public void processException(final Exception ex) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SystemFacade.getInstance().handleException(ex);
            }
        });
    }
}

