/*
 * Decompiled with CFR 0.152.
 */
package net.sf.rej.files;

import java.io.File;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import net.sf.rej.files.FileSet;
import net.sf.rej.files.Modifications;
import net.sf.rej.gui.UndoManager;
import net.sf.rej.java.ClassFile;
import net.sf.rej.java.ClassParsingException;
import net.sf.rej.java.Disassembler;

public class Project
implements Modifications {
    private Map<String, UndoManager> undoManagers = new HashMap<String, UndoManager>();
    private UndoManager undoManager = new UndoManager();
    private Set<String> modified = new LinkedHashSet<String>();
    private Map<String, Object> cache = new HashMap<String, Object>();
    private File file = null;
    private FileSet fileset = null;

    public void setFile(File f) {
        this.file = f;
    }

    public File getFile() {
        return this.file;
    }

    public String toString() {
        return this.file.getName();
    }

    public void setFileSet(FileSet fileset) {
        this.fileset = fileset;
    }

    public boolean isArchive() {
        return this.fileset != null;
    }

    public FileSet getFileSet() {
        return this.fileset;
    }

    public UndoManager getUndoManager(String file) {
        UndoManager um = null;
        if (this.undoManagers.containsKey(file)) {
            um = this.undoManagers.get(file);
        } else {
            um = new UndoManager();
            this.undoManagers.put(file, um);
        }
        return um;
    }

    public void setClassFileMofidied(boolean modified, String filename, ClassFile cf) {
        if (modified) {
            this.modified.add(filename);
            this.cache.put(filename, cf);
        } else {
            this.modified.remove(filename);
            this.cache.put(filename, new SoftReference<ClassFile>(cf));
        }
    }

    public boolean isModified() {
        return this.modified.size() > 0;
    }

    public boolean isModified(String filename) {
        return this.modified.contains(filename);
    }

    public ClassFile getClassFile(String filename) throws IOException, ClassParsingException {
        ClassFile cf;
        if (this.cache.containsKey(filename)) {
            Object value = this.cache.get(filename);
            if (value instanceof ClassFile) {
                return (ClassFile)value;
            }
            cf = (ClassFile)((SoftReference)value).get();
            if (cf != null) {
                return cf;
            }
        }
        byte[] data = this.fileset.getData(filename);
        try {
            cf = Disassembler.readClass(data);
            this.cache.put(filename, new SoftReference<ClassFile>(cf));
            return cf;
        }
        catch (Exception e) {
            throw new ClassParsingException("Error parsing class file " + this.file + " : " + e.getMessage(), e);
        }
    }

    public void save() throws Exception {
        this.fileset.save(this);
        this.modified.clear();
    }

    public void saveAs(File file) throws Exception {
        this.fileset.saveAs(file, this);
        this.modified.clear();
        this.file = file;
    }

    public UndoManager getProjectUndoManager() {
        return this.undoManager;
    }

    public void removeFile(String file) {
        this.fileset.removeFile(file);
        this.modified.add(file);
    }

    public void addFile(String file) {
        this.fileset.addFile(file);
        this.modified.add(file);
    }

    public void clearCache() {
        this.cache.clear();
    }

    public byte[] getData(String filename) throws IOException {
        try {
            return this.getClassFile(filename).getData();
        }
        catch (ClassParsingException cpe) {
            cpe.printStackTrace();
            throw new IOException("Class file parsing failed where no parsing was supposed to happen; " + cpe.getMessage());
        }
    }

    public void addFile(String file, ClassFile cf) {
        this.addFile(file);
        this.cache.put(file, cf);
    }
}

