/*
 * Decompiled with CFR 0.152.
 */
package net.sf.rej.files;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.List;
import java.util.zip.CRC32;
import net.sf.rej.files.Modifications;
import net.sf.rej.util.IOToolkit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FileSet
implements Serializable {
    public static final long serialVersionUID = 1L;

    public abstract List<String> getContentsList();

    public abstract byte[] getData(String var1) throws IOException;

    public abstract String getName();

    public abstract InputStream getInputStream(String var1) throws IOException;

    public abstract long getLength(String var1) throws IOException;

    public abstract void close() throws IOException;

    public abstract void removeFile(String var1);

    public abstract void addFile(String var1);

    public abstract void refresh() throws IOException;

    public long getChecksum() throws IOException {
        List<String> list = this.getContentsList();
        CRC32 crc = new CRC32();
        for (int i = 0; i < list.size(); ++i) {
            String filename = list.get(i);
            InputStream is = this.getInputStream(filename);
            IOToolkit.updateCRCWithStream(is, crc);
        }
        return crc.getValue();
    }

    public abstract void save(Modifications var1) throws IOException;

    public abstract void saveAs(File var1, Modifications var2) throws IOException;

    public abstract void removeAllFiles() throws IOException;

    public int hashCode() {
        return this.getClass().hashCode() * 37 + this.getName().hashCode();
    }

    public boolean equals(Object other) {
        if (other != null && other.getClass() == this.getClass()) {
            FileSet otherFS = (FileSet)other;
            return otherFS.getName().equals(this.getName());
        }
        return false;
    }

    public void getContentsFrom(final FileSet fs) throws IOException {
        this.removeAllFiles();
        for (String contentFile : fs.getContentsList()) {
            this.addFile(contentFile);
        }
        this.save(new Modifications(){

            public byte[] getData(String filename) throws IOException {
                return fs.getData(filename);
            }

            public boolean isModified(String filename) {
                return true;
            }
        });
    }

    public abstract String getClasspath(String var1);
}

