/*
 * Decompiled with CFR 0.152.
 */
package net.sf.rej.files;

import java.io.Serializable;
import net.sf.rej.files.FileSet;

public class ClassLocator
implements Serializable {
    public static final long serialVersionUID = 1L;
    private String shortName = null;
    private String pkg = "";
    private String file = null;
    private transient FileSet fileSet = null;

    public ClassLocator(String classLongName, FileSet fileSet, String file) {
        this.fileSet = fileSet;
        this.file = file;
        this.getData(classLongName);
    }

    private void getData(String longName) {
        int lastDot = longName.lastIndexOf(".");
        this.shortName = longName.substring(lastDot + 1);
        if (lastDot != -1) {
            this.pkg = longName.substring(0, lastDot);
        }
    }

    public String getShortName() {
        return this.shortName;
    }

    public String getPackage() {
        return this.pkg;
    }

    public String getFile() {
        return this.file;
    }

    public FileSet getFileSet() {
        return this.fileSet;
    }

    public void setFileSet(FileSet fs) {
        this.fileSet = fs;
    }

    public String toString() {
        return this.getShortName();
    }

    public String getFullName() {
        if (this.pkg.length() == 0) {
            return this.getShortName();
        }
        return this.getPackage() + "." + this.getShortName();
    }

    public String dumpDetails() {
        return "File set: " + this.getFileSet() + ", File: " + this.getFile() + ", Class name: " + this.getFullName();
    }
}

