/*
 * Decompiled with CFR 0.152.
 */
package net.sf.rej.files;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import net.sf.rej.files.ClassLocator;
import net.sf.rej.files.FileSet;
import net.sf.rej.java.ClassFile;
import net.sf.rej.java.Disassembler;
import net.sf.rej.util.FileToolkit;
import net.sf.rej.util.ParsingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassIndex {
    private static final Logger logger = Logger.getLogger(ClassIndex.class.getName());
    private boolean upToDate = false;
    private List<FileSet> elements = new ArrayList<FileSet>();
    private HashMap<FileSet, List<ClassLocator>> indices = new HashMap();

    public void addElement(FileSet fs) {
        this.elements.add(fs);
        this.upToDate = false;
    }

    public ClassFile getByFullName(String name) throws IOException {
        this.conditionalUpdate();
        ClassLocator cl = this.getLocator(name);
        if (cl != null) {
            byte[] data = cl.getFileSet().getData(cl.getFile());
            return Disassembler.readClass(data);
        }
        return null;
    }

    public List<ClassLocator> getAll() {
        this.conditionalUpdate();
        ArrayList<ClassLocator> all = new ArrayList<ClassLocator>();
        for (int i = 0; i < this.elements.size(); ++i) {
            FileSet fs = this.elements.get(i);
            List<ClassLocator> locators = this.indices.get(fs);
            all.addAll(locators);
        }
        return all;
    }

    public synchronized void conditionalUpdate() {
        if (!this.upToDate) {
            this.update();
        }
    }

    public void update() {
        try {
            for (int i = 0; i < this.elements.size(); ++i) {
                FileSet fs = this.elements.get(i);
                if (this.indices.containsKey(fs)) continue;
                List<ClassLocator> locators = this.getCachedLocators(fs);
                if (locators == null) {
                    locators = this.createIndexFor(fs);
                    this.saveLocatorsCache(fs, locators);
                }
                this.indices.put(fs, locators);
            }
            this.upToDate = true;
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    private List<ClassLocator> getCachedLocators(FileSet fs) {
        try {
            long checksum = fs.getChecksum();
            File[] files = new File(".").listFiles(new FileFilter(){

                public boolean accept(File pathname) {
                    return pathname.getName().endsWith(".locatorcache");
                }
            });
            for (int i = 0; i < files.length; ++i) {
                try {
                    FileInputStream fis = new FileInputStream(files[i]);
                    ObjectInputStream ois = new ObjectInputStream(fis);
                    byte[] magic = new byte[4];
                    ois.read(magic);
                    if (!"RJLC".equals(new String(magic))) {
                        ois.close();
                        throw new RuntimeException("Bad magic.");
                    }
                    String cacheName = (String)ois.readObject();
                    long cacheChecksum = ois.readLong();
                    if (cacheChecksum == checksum && cacheName.equals(fs.getName())) {
                        logger.fine("Read locators for " + cacheName + " from the cache.");
                        List locators = (List)ois.readObject();
                        for (int j = 0; j < locators.size(); ++j) {
                            ClassLocator cl = (ClassLocator)locators.get(j);
                            cl.setFileSet(fs);
                        }
                        return locators;
                    }
                    ois.close();
                    continue;
                }
                catch (Exception e) {
                    System.out.println("Bad cache file: " + files[i].getAbsolutePath());
                    e.printStackTrace();
                }
            }
        }
        catch (IOException e) {
            System.out.println("Unable to read locator cache.");
            e.printStackTrace();
        }
        return null;
    }

    private void saveLocatorsCache(FileSet fs, List<ClassLocator> locators) {
        try {
            long checksum = fs.getChecksum();
            String name = fs.getName();
            File file = FileToolkit.createNewFile(new File("."), ".locatorcache");
            FileOutputStream fos = new FileOutputStream(file);
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.write("RJLC".getBytes());
            oos.writeObject(name);
            oos.writeLong(checksum);
            oos.writeObject(locators);
            oos.flush();
            oos.close();
        }
        catch (IOException e) {
            logger.warning("Unable to save locator cache.");
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            logger.warning(sw.toString());
        }
    }

    private List<ClassLocator> createIndexFor(FileSet fs) throws IOException {
        ArrayList<ClassLocator> locators = new ArrayList<ClassLocator>();
        List<String> contents = fs.getContentsList();
        for (int i = 0; i < contents.size(); ++i) {
            String file = contents.get(i);
            if (!file.endsWith(".class")) continue;
            try {
                InputStream is = fs.getInputStream(file);
                String className = Disassembler.parseName(is);
                is.close();
                locators.add(new ClassLocator(className, fs, file));
                continue;
            }
            catch (ParsingException pe) {
                logger.warning("Error parsing fileset: " + fs.getName() + " file: " + file);
                StringWriter sw = new StringWriter();
                pe.printStackTrace(new PrintWriter(sw));
                logger.warning(sw.toString());
            }
        }
        return locators;
    }

    public void removeElement(FileSet current) {
        this.elements.remove(current);
        this.indices.remove(current);
    }

    public synchronized ClassLocator getLocator(String className) {
        for (int i = 0; i < this.elements.size(); ++i) {
            FileSet fs = this.elements.get(i);
            List<ClassLocator> locators = this.indices.get(fs);
            for (int j = 0; j < locators.size(); ++j) {
                ClassLocator cl = locators.get(j);
                if (!cl.getFullName().equals(className)) continue;
                return cl;
            }
        }
        return null;
    }

    public List<String> getClassNames(FileSet fs) {
        List<ClassLocator> locators = this.indices.get(fs);
        ArrayList<String> classNames = new ArrayList<String>(locators.size());
        for (ClassLocator locator : locators) {
            classNames.add(locator.getFullName());
        }
        return classNames;
    }

    public void addLocator(FileSet fs, String file) throws IOException {
        if (file.endsWith(".class")) {
            List<ClassLocator> locators = this.indices.get(fs);
            try {
                InputStream is = fs.getInputStream(file);
                String className = Disassembler.parseName(is);
                is.close();
                locators.add(new ClassLocator(className, fs, file));
            }
            catch (ParsingException pe) {
                logger.warning("Error parsing fileset: " + fs.getName() + " file: " + file);
                StringWriter sw = new StringWriter();
                pe.printStackTrace(new PrintWriter(sw));
                logger.warning(sw.toString());
            }
        }
    }

    public void removeLocator(FileSet fs, String file) {
        List<ClassLocator> locators = this.indices.get(fs);
        for (ClassLocator locator : locators) {
            if (!locator.getFile().equals(file)) continue;
            locators.remove(locator);
            break;
        }
    }
}

