/*
 * Decompiled with CFR 0.152.
 */
package net.sf.rej;

import java.util.Set;
import junit.framework.Assert;
import junit.framework.TestCase;
import net.sf.rej.Imports;
import org.junit.Before;
import org.junit.Test;

public class ImportsTest
extends TestCase {
    private Imports imports;

    @Before
    public void setUp() throws Exception {
        this.imports = new Imports("test.home");
    }

    @Test
    public void testHomePackageFuncionality() {
        String classNotInHomePackage = "test.nothome.ClassNotInHome";
        String classInHomePackage = "test.home.ClassInHomePackage";
        this.imports.addType(classInHomePackage);
        this.imports.addType(classNotInHomePackage);
        Set<String> importSet = this.imports.getImports();
        Assert.assertTrue((String)"Create an import for non-home package classes", (boolean)importSet.contains(classNotInHomePackage));
        Assert.assertFalse((String)"Do not create an import for home package classes", (boolean)importSet.contains(classInHomePackage));
    }

    @Test
    public void testAddType() {
        String shortNameForAddedClass = "ClassAdded";
        String shortNameForNotAddedClass = "NotAddedClass";
        String addedClass = "package." + shortNameForAddedClass;
        String notAddedClass = "package." + shortNameForNotAddedClass;
        this.imports.addType(addedClass);
        Set<String> importSet = this.imports.getImports();
        Assert.assertTrue((String)"Create import for class that was added", (boolean)importSet.contains(addedClass));
        Assert.assertFalse((String)"Do not create import for class that was not added", (boolean)importSet.contains(notAddedClass));
        Assert.assertEquals((String)"Short name for added class", (String)shortNameForAddedClass, (String)this.imports.getShortName(addedClass));
        Assert.assertEquals((String)"Long name for not added class", (String)notAddedClass, (String)this.imports.getShortName(notAddedClass));
    }

    @Test
    public void testGetImports() {
        String classA = "ClassA";
        String classB = "packagex.ClassB";
        String classC = "pac.age.ClassC";
        this.imports.addType(classA);
        this.imports.addType(classB);
        this.imports.addType(classC);
        Set<String> set = this.imports.getImports();
        Assert.assertEquals((String)"Import size (one class is in default package)", (int)2, (int)set.size());
        Assert.assertFalse((String)"No import for class A", (boolean)set.contains(classA));
        Assert.assertTrue((String)"Import for class B", (boolean)set.contains(classB));
        Assert.assertTrue((String)"Import for class C", (boolean)set.contains(classC));
    }

    @Test
    public void testGetPackage() {
        Assert.assertEquals((String)"Default package", (String)"", (String)Imports.getPackage("MyClass"));
        Assert.assertEquals((String)"Zero dot package", (String)"package", (String)Imports.getPackage("package.MyClass"));
        Assert.assertEquals((String)"One dot package", (String)"pack.age", (String)Imports.getPackage("pack.age.MyClass"));
    }

    @Test
    public void testGetClassString() {
        Assert.assertEquals((String)"Default package", (String)"MyClass", (String)Imports.getType("MyClass"));
        Assert.assertEquals((String)"Zero dot package", (String)"MyClass", (String)Imports.getType("package.MyClass"));
        Assert.assertEquals((String)"One dot package", (String)"MyClass", (String)Imports.getType("pack.age.MyClass"));
    }

    @Test
    public void testIsInDefaultPackage() {
        Assert.assertTrue((String)"Default package", (boolean)Imports.isInDefaultPackage("MyClass"));
        Assert.assertFalse((String)"Zero dot package", (boolean)Imports.isInDefaultPackage("package.MyClass"));
        Assert.assertFalse((String)"One dot package", (boolean)Imports.isInDefaultPackage("pack.age.MyClass"));
    }

    @Test
    public void testIsInJavaLang() {
        Assert.assertTrue((String)"Package java.lang", (boolean)Imports.isInJavaLang("java.lang.MyClass"));
        Assert.assertFalse((String)"Default package", (boolean)Imports.isInJavaLang("MyClass"));
        Assert.assertFalse((String)"Zero dot package", (boolean)Imports.isInJavaLang("package.MyClass"));
        Assert.assertFalse((String)"One dot package", (boolean)Imports.isInJavaLang("pack.age.MyClass"));
    }

    @Test
    public void testAreInSamePackage() {
        Assert.assertTrue((String)"Same package", (boolean)Imports.areInSamePackage("package.ClassA", "package.ClassB"));
        Assert.assertFalse((String)"Different package", (boolean)Imports.areInSamePackage("packagea.ClassA", "packageb.ClassB"));
        Assert.assertTrue((String)"Same package (no package)", (boolean)Imports.areInSamePackage("ClassA", "ClassB"));
        Assert.assertFalse((String)"Different package", (boolean)Imports.areInSamePackage("ClassA", "package.ClassB"));
        Assert.assertFalse((String)"Different package", (boolean)Imports.areInSamePackage("package.a.ClassA", "package.b.ClassB"));
    }

    @Test
    public void testGetShortName() {
        this.imports.addType("java.lang.String");
        this.imports.addType("package.TypeA");
        this.imports.addType("package.TypeB");
        this.imports.addType("MyClass");
        this.imports.addType("java.util.Date");
        this.imports.addType("java.sql.Date");
        Assert.assertEquals((String)"Class not added", (String)"java.util.List", (String)this.imports.getShortName("java.util.List"));
        Assert.assertEquals((String)"Ambiguous short name", (String)"java.util.Date", (String)this.imports.getShortName("java.util.Date"));
        Assert.assertEquals((String)"Ambiguous short name", (String)"java.sql.Date", (String)this.imports.getShortName("java.sql.Date"));
        Assert.assertEquals((String)"Added class in default package", (String)"MyClass", (String)this.imports.getShortName("MyClass"));
        Assert.assertEquals((String)"Not added class in default package", (String)"MyOtherClass", (String)this.imports.getShortName("MyOtherClass"));
        Assert.assertEquals((String)"Added java.lang", (String)"String", (String)this.imports.getShortName("java.lang.String"));
        Assert.assertEquals((String)"Not added java.lang", (String)"Object", (String)this.imports.getShortName("java.lang.Object"));
        Assert.assertEquals((String)"Two types in same package", (String)"TypeA", (String)this.imports.getShortName("package.TypeA"));
        Assert.assertEquals((String)"Two types in same package", (String)"TypeB", (String)this.imports.getShortName("package.TypeB"));
    }
}

