use Win32::TieRegistry(Delimiter=>"/");
use Win32;
use Win32::TaskScheduler;
use Win32::Lanman;
use Data::Dumper::Simple;
use Win32::GuiTest qw(:ALL);
use Win32::API::Prototype;
use Win32::IPConfig;
use Net::Whois::Raw;
use Digest::SHA;
use Win32::ToolHelp ;
use Win32::GuiTest qw(:ALL);
use Win32::API::Prototype;
use Win32::ToolHelp;
use Win32::IPHelper;
use Win32::EventLog;
use File::Copy;


use Getopt::Std;
use vars qw/ %opt /;


use strict ;

$SIG{'CHLD'} = 'IGNORE'; 
$SIG{'INT'} = \&muere;
$SIG{'QUIT'} = \&muere;
$SIG{'KILL'} = \&muere;
$SIG{'ABRT'} = \&muere;
$SIG{'STOP'} = \&muere;


sub muere
{
	exit 0;
}


my $opt_string = 'NpwndthvsuerAc';
getopts( "$opt_string", \%opt );

if (!%opt) { 
	
	print "RadioGraPhy 2.0\n" ;

	print "\n--- USAGE ---\n\n" ;
	
	print "radiography [options]\n\n";
	
	print "-r (registry keys)\n" ;
	print "-e (explorer registry keys)\n";
	print "-u (System Users)\n";
	print "-s (Startup FILES)\n";
	print "-v (System Services)\n";
	print "-h (Contents of Hosts file)\n";
	print "-t (TaskScheduler list)\n";
	print "-d (System Drivers)\n";
	print "-n (NetBios Shares)\n";
	print "-w (Hidden Windows)\n";
	print "-p (System process)\n";
	print "-N (Network Information)\n";
	
	print "\n-A (all tests)\n";
	
	print "\n-c (Grab evidences)\n";
	
}

## Auxiliary functions 


sub parsekeys {
	
	my @return ;
	
	my $registry = $Registry->{ "@_[0]" } ;
	
	push(@return, "Analyzing: @_[0]\n\n"); 
	
	while ((my $key, my $value) = each(%$registry)){
		
		push(@return, "\n$key\n", "$value\n"); 
		
		if (@_[1] =~ /ana/ && $value) {
			
			$value =~ /\"(.*)\"/ ;
			
			if ($1) {
			
				my @result = &testcymru($1) ;
				push(@return, "@result"); 
			}
			
			else { 
				
				my @result = &testcymru($value) ;
				push(@return, "@result"); 
			
			}
		}
	}
	
	push(@return, "**************************\n\n"); 
	
	return(@return) ;

}

sub parsekeysfixed {
	
	my @return ;
	
	my $registry = $Registry->{ "@_[0]" } ;
	
	push(@return, "Analyzing: @_[0]\n\n");
	
	while ((my $key, my $value) = each(%$registry)){
		
		push(@return, "$key\n\n");
	}
	
	push(@return, "**************************\n\n");
	
	return(@return) ;

}

sub parsecontentkeys {
	
	my @return ;
	
	my $registry = $Registry->{ "@_[0]" } ;
	
	push(@return, "Analyzing: @_[0]\n\n");
	
	push(@return, "$registry\n\n");
	
	push(@return, "**************************\n\n");
	
	return(@return) ;
	
}


sub testcymru {
	
	my @return ;
	
	my $sha = Digest::SHA->new();

	eval { $sha->addfile(@_[0]) } ;
	
	if ($@) {
		
		return("Problem hashing file\n") ;
		
	}

	my $digest = $sha->hexdigest;
	
	my $response ;

	eval { $response = get_whois("$digest.malware.hash.cymru.com", 'hash.cymru.com'); } ;

	if ($@) {
  
		push(@return, "Cannot contact with Cymru service. No report for @_[0]\n");
  
	}

	else {


		if ($response=~ /NO_DATA/) {
  
			push(@return, "--> Cymru Test Result: not a suspicious file\n");

		}

		else {
  
			push(@return, "--> Cymru Test Result: suspicious file\n");
		}
	}
	
	return(@return) ;

}

##############


if ($opt{r} || $opt{A}) {

	## Registry keys 
	
	print "\n\n[***] Registry KEYS\n\n" ;
	
	my $run= "HKEY_LOCAL_MACHINE/Software/Microsoft/Windows/CurrentVersion/Run/";
    
	my $runonce= "HKEY_LOCAL_MACHINE/Software/Microsoft/Windows/CurrentVersion/RunOnce/" ;

	my $runservices= "HKEY_LOCAL_MACHINE/Software/Microsoft/Windows/CurrentVersion/RunServices/";
	
	my $runservicesonce= "HKEY_LOCAL_MACHINE/Software/Microsoft/Windows/CurrentVersion/RunServicesOnce/";
	
	my $localrun= "HKEY_CURRENT_USER/Software/Microsoft/Windows/CurrentVersion/Run/";
	
	my $localrunonce= "HKEY_CURRENT_USER/Software/Microsoft/Windows/CurrentVersion/RunOnce/";
	
	my $command= "HKEY_CLASSES_ROOT/exefile/shell/open/command/";

	my $localcommand= "HKEY_LOCAL_MACHINE/SOFTWARE/Classes/exefile/shell/open/command/";
	
	my $DataBasePath=  "HKEY_LOCAL_MACHINE/SYSTEM/ControlSet001/Services/Tcpip/Parameters/DataBasePath";

	my @result = &parsekeys($run, "ana") ; print @result ;
	my @result = &parsekeys($runonce) ; print @result ;
	my @result = &parsekeys($runservices) ; print @result ;
	my @result = &parsekeys($localrun, "ana") ; print @result ;
	my @result = &parsekeys($localrunonce) ; print @result ;
	my @result = &parsekeys($localrunonce) ; print @result ;
	my @result = &parsekeys($command); print @result ;
	my @result = &parsekeys($localcommand) ; print @result ;
	
	my @result = &parsecontentkeys($DataBasePath) ; print @result ;
	
}

if ($opt{e} || $opt{A}) {
	
	print "\n\n[***] Explorer Registry KEYS\n\n" ;

	my $appinit= "HKEY_LOCAL_MACHINE/SOFTWARE/Microsoft/Windows NT/CurrentVersion/Windows/AppInit_DLLs";

	my $usersearchbar = "HKEY_CURRENT_USER/Software/Microsoft/Internet Explorer/Main/Search Bar";

	my $usersearchpage = "HKEY_CURRENT_USER/Software/Microsoft/Internet Explorer/Main/Search Page";

	my $userSearchAssistant = "HKEY_CURRENT_USER/Software/Microsoft/Internet Explorer/Main/SearchAssistant";

	my $userhomeisp= "HKEY_CURRENT_USER/Software/Microsoft/Internet Explorer/Main/HomeOldSP";

	my $userLocalPage = "HKEY_CURRENT_USER/Software/Microsoft/Internet Explorer/Main/Local Page";

	my $userStartPage= "HKEY_CURRENT_USER/Software/Microsoft/Internet Explorer/Main/Start Page";

	my $localsearchbar= "HKEY_LOCAL_MACHINE/SOFTWARE/Microsoft/Internet Explorer/Main/Search Bar";

	my $localsearchpage = "HKEY_LOCAL_MACHINE/SOFTWARE/Microsoft/Internet Explorer/Main/Search Page";

	my $localSearchAssistant= "HKEY_LOCAL_MACHINE/SOFTWARE/Microsoft/Internet Explorer/Main/SearchAssistant";

	my $localDefaultPageURL = "HKEY_LOCAL_MACHINE/SOFTWARE/Microsoft/Internet Explorer/Main/Default_Page_URL";

	my $localDefaultSearchURL= "HKEY_LOCAL_MACHINE/SOFTWARE/Microsoft/Internet Explorer/Main/Default_Search_URL";

	my $localLocalPage = "HKEY_LOCAL_MACHINE/SOFTWARE/Microsoft/Internet Explorer/Main/Local Page";

	my $proxy = "HKEY_CURRENT_USER/Software/Microsoft/Windows/CurrentVersion/Internet Settings/ProxyServer";

	my $BH0= "HKEY_LOCAL_MACHINE/SOFTWARE/Microsoft/Windows/CurrentVersion/Explorer/Browser Helper Objects/";

	my $ToolBar= "HKEY_LOCAL_MACHINE/SOFTWARE/Microsoft/Internet Explorer/Toolbar/";

	my $ExplorerBar= "HKEY_LOCAL_MACHINE/SOFTWARE/Microsoft/Internet Explorer/Explorer Bars/";

	my @result = &parsecontentkeys($appinit) ; print @result ;
	my @result = &parsecontentkeys($usersearchbar) ; print @result ;
	my @result = &parsecontentkeys($usersearchpage) ; print @result ;
	my @result = &parsecontentkeys($userSearchAssistant) ; print @result ;
	my @result = &parsecontentkeys($userhomeisp) ; print @result ;
	my @result = &parsecontentkeys($userLocalPage) ; print @result ;
	my @result = &parsecontentkeys($userStartPage) ; print @result ;
	my @result = &parsecontentkeys($localsearchbar) ; print @result ;
	my @result = &parsecontentkeys($localsearchpage) ; print @result ;
	my @result = &parsecontentkeys($localSearchAssistant) ; print @result ;
	my @result = &parsecontentkeys($localDefaultPageURL) ; print @result ;
	my @result = &parsecontentkeys($localDefaultSearchURL) ; print @result ;
	my @result = &parsecontentkeys($localLocalPage) ; print @result ;
	my @result = &parsecontentkeys($proxy) ; print @result ;
	
	my @result = &parsekeysfixed($BH0) ; print @result ;
	my @result = &parsekeysfixed($ToolBar); print @result ;
	my @result = &parsekeysfixed($ExplorerBar); print @result ;
	
}

if ($opt{u} || $opt{A}) {

	my @usuarios;

	Win32::Lanman::NetUserEnum("", 0, \@usuarios);
		
	print "\n\n[***] System Users\n\n" ;
	
	
	for my $i ( 0 .. $#usuarios ) {
		
		print "---------------------------\n";
		for my $role ( keys %{ $usuarios[$i] } ) {
			print "$role=$usuarios[$i]{$role}\n";
		}
		print "****************************\n";
	}

	#print Dumper(@usuarios);

}


if ($opt{s} || $opt{A}) {
	
	print "\n\n[***] Startup FILES\n\n" ;
	
	my @filesuser;
	my $userstartup ;

	$userstartup= $Registry->{"HKEY_CURRENT_USER/SOFTWARE/Microsoft/Windows/CurrentVersion/Explorer/Shell Folders/Startup"};

	opendir (DIR, "$userstartup") ;

	@filesuser= (readdir DIR) ;
	closedir DIR ;
	
	print "\nFiles in $userstartup\n" ;
	
	foreach(@filesuser) {
		
		next if ($_ =~ /^\./ || $_=~ /^\.\./) ;
		
		print "\n$_\n" ;
		
		my @result = &testcymru("$userstartup/$_") ; print @result ;
	
	}

	my @filesallusers;
	my $allusersstartup;

	$allusersstartup= $Registry->{"HKEY_LOCAL_MACHINE/SOFTWARE/Microsoft/Windows/CurrentVersion/Explorer/Shell Folders/Common Startup"};

	opendir (DIR, "$allusersstartup") ;

	@filesallusers = (readdir DIR) ;
	closedir DIR ;
	
	print "\nFiles in $allusersstartup\n" ;
	
	foreach(@filesallusers) {
		
		next if ($_ =~ /^\./ || $_=~ /^\.\./) ;
		
		print "\n$_\n" ;
		
		my @result = &testcymru("$allusersstartup/$_") ; print @result ;
	
	}
	
}

if ($opt{v} || $opt{A}) {
	
	my @servicios;

	Win32::Lanman::EnumServicesStatus("", "", &SERVICE_WIN32, &SERVICE_STATE_ALL, \@servicios);

	print "\n\n[***] System Services\n\n" ;
	
	
	for my $i ( 0 .. $#servicios ) {
		
		print "---------------------------\n";
		for my $role ( keys %{ $servicios[$i] } ) {
			print "$role=$servicios[$i]{$role}\n";
		}
		print "****************************\n";
	}

	
}
	
if ($opt{h} || $opt{A}) {
	
	print "\n\n[***] Contents of Hosts file\n\n" ;
	
	my $hostfile ;
	my @contenidohosts;

	$hostfile= "$ENV{windir}\\system32\\drivers\\etc\\hosts" ;

	open (HOSTFILE, $hostfile);

	@contenidohosts = (<HOSTFILE>) ;

	close HOSTFILE ;
	
	foreach(@contenidohosts) {
		
		print "$_\n";
		
	}
	
}


if ($opt{t} || $opt{A}) {
	
	print "\n\n[***] TaskScheduler list\n\n" ;
	
	my $taskmanager = Win32::TaskScheduler->New() ;
	
	my @tasks = $taskmanager->Enum();
	
	foreach(@tasks) {
		
		my $task = $_ ;
		
		$taskmanager->Activate($task) ;
		
		my $aptask = $taskmanager->GetApplicationName() ;
		
		print "Task Name: $task\n" ;
		print "Task Application: $aptask\n" ;
		
		&testcymru($aptask) ;
		
	}
		
}
	
if ($opt{d} || $opt{A}) {	

	print "\n\n[***] System Drivers\n\n" ;
	
	my @drivers;

	Win32::Lanman::EnumServicesStatus("", "", &SERVICE_DRIVER, &SERVICE_STATE_ALL, \@drivers);
	
	for my $i ( 0 .. $#drivers ) {
		
		print "---------------------------\n";
		for my $role ( keys %{ $drivers[$i] } ) {
			print "$role=$drivers[$i]{$role}\n";
		}
		print "****************************\n";
	}
	
}

if ($opt{n} || $opt{A}) {
	
	print "\n\n[***] NetBios Shares\n\n" ;
	
	my @shares;

	Win32::Lanman::NetShareEnum("", \@shares);


	for my $i ( 0 .. $#shares ) {
		
		print "---------------------------\n";
		for my $role ( keys %{ $shares[$i] } ) {
			print "$role=$shares[$i]{$role}\n";
		}
		print "****************************\n";
	}
	
	
}

if ($opt{w} || $opt{A}) {
	
	print "\n\n[***] Hidden Windows\n\n" ;
	
	ApiLink( 'user32.dll', 'DWORD GetWindowThreadProcessId( HWND hWnd, LPDWORD lpdwProcessId )' ) || die;

	for (FindWindowLike()) {
		
		my $hwid = $_ ;
		
		my $pid = pack( "L", 0 );
		my $her = GetWindowThreadProcessId($hwid, $pid ) ;
		my $pidleer = unpack( "L", $pid );
		my @cp = Win32::ToolHelp::GetProcess($pidleer);
		my @pcp = Win32::ToolHelp::GetProcess($cp[5]);
		
		my $text = WMGetText($_) ;
				
		my $class = GetClassName($_);
				
		my $menu = GetMenu($hwid) ;
	
		if (!IsWindowVisible($hwid)) {
		
					
			if ($class eq "IEFrame" || $class eq "ConsoleWindowClass" ) {
				
				my @opcp = Win32::ToolHelp::GetProcess($$);
				
				my @ppcp = Win32::ToolHelp::GetProcess($opcp[5]);
				
				if ($cp[5] == $ppcp[5]) {next ;}
				
				print "Found Hidden Window\n" ;
				
				print "Caption $text\n";
				
				print "Process name & PID: $cp[8] $pidleer\n" ;
				print "Parent Process name & PID: $pcp[8] $cp[5]\n" ;
			}
			
		}
		

		
	}
}
	
if ($opt{p} || $opt{A}) {
	
	print "\n\n[***] System process\n\n" ;
	
	my @ps = Win32::ToolHelp::GetProcesses();
	
	foreach my $p (@ps) {
		
		my @cm ;
		
		if ($$p[1] != 0) {
		
			eval { @cm = Win32::ToolHelp::GetProcessMainModule($$p[1]); } ;
		}
		
		print "\n$$p[1] $$p[8] $cm[8]\n"; 
		
		if ($cm[8]) {
			
			my @result = &testcymru($cm[8]) ; print @result ;
			
		}
	}
	
	print "\n\nSearching for Hidden processes with Unhide\n\n"; 
	
	my $registry = $Registry->{ "HKEY_LOCAL_MACHINE/Software/Wow6432Node" } ;
	
	if ($registry) {
		
		#64 bits
		
		my $unhide = `WinUnhide\WinUnhide64 sys` ;
		
		print "$unhide" ;
	}
	
	else {
		
		my $unhide = `WinUnhide\\WinUnhide sys` ;
		
		print "$unhide" ;
		
	}
	
}


if ($opt{N} || $opt{A}) {
	
	print "\n\n[***] Network Information\n\n" ;
	
	my @TCP_EX_TABLE;
	my $bOrder = 1;

	my $ret = Win32::IPHelper::GetExtendedTcpTable(\@TCP_EX_TABLE, $bOrder);
	
	print "\nTCP Info\n\n" ;
	
	for my $i ( 0 .. $#TCP_EX_TABLE ) {
		
		print "---------------------------\n";
		for my $role ( keys %{ $TCP_EX_TABLE[$i] } ) {
			print "$role=$TCP_EX_TABLE[$i]{$role}\n";
		}
		print "****************************\n";
	}
	
	my @UDP_EX_TABLE;

	my $ret = Win32::IPHelper::GetExtendedUdpTable(\@UDP_EX_TABLE, $bOrder);
	
	print "\n\nUDP Info\n\n" ;

	for my $i ( 0 .. $#UDP_EX_TABLE ) {
		
		print "---------------------------\n";
		for my $role ( keys %{ $UDP_EX_TABLE[$i] } ) {
			print "$role=$UDP_EX_TABLE[$i]{$role}\n";
		}
		print "****************************\n";
	}
	
	
}

if ($opt{c}) {
	
	print "\n\n[***] Catching evidences\n\n" ;
	
	mkdir "Evidences" ;
	mkdir "Evidences\\Eventlog";
	mkdir "Evidences\\Processes";
	
	my $handle=Win32::EventLog->new("Application");

	my $dest="Evidences\\Eventlog\\app.evt";
	$handle->Backup($dest);

	$handle->Close;
	undef $dest;
	
	my $handle=Win32::EventLog->new("System");

	my $dest="Evidences\\Eventlog\\sys.evt";
	$handle->Backup($dest);

	$handle->Close;
	undef $dest;
	
	my $handle=Win32::EventLog->new("Security");

	my $dest="Evidences\\Eventlog\\sec.evt";
	$handle->Backup($dest);

	$handle->Close;
	undef $dest;
	
	my @ps = Win32::ToolHelp::GetProcesses();
	
	foreach my $p (@ps) {
		
		my @cm ;
		
		if ($$p[1] != 0) {
		
			eval { @cm = Win32::ToolHelp::GetProcessMainModule($$p[1]); } ;
		}
		
		if ($cm[8]) {
			
			mkdir "Evidences\\Processes\\$$p[1]";
			copy("$cm[8]","Evidences\\Processes\\$$p[1]\\$$p[8]") or die "Copy failed: $!";
			
		}
	}
	
	
}

exit(0) ;	
