rule Win32_Trojan_Dridex : tc_detection malicious
{
    meta:

        author              = "ReversingLabs"

        source              = "ReversingLabs"
        status              = "RELEASED"
        sharing             = "TLP:WHITE"
        category            = "MALWARE"
        malware             = "DRIDEX"
        description         = "Yara rule that detects Dridex trojan."

        tc_detection_type   = "Trojan"
        tc_detection_name   = "Dridex"
        tc_detection_factor = 5

    strings:

        $resolve_api_wrapper_1 = {
            56 57 8B FA 8B F1 8B CF E8 ?? ?? ?? ?? 85 C0 75 ?? 81 FE ?? ?? ?? ?? 75 ?? 33 C0 5F 
            5E C3 8B CE E8 ?? ?? ?? ?? 85 C0 75 ?? 8B CE E8 ?? ?? ?? ?? 84 C0 74 ?? 8B CE E8 ?? 
            ?? ?? ?? 85 C0 74 ?? 8B D7 ?? ?? ?? ?? E9 
        }

        $resolve_api_wrapper_2 = {
            57 53 8B FA 8B D9 8B CF E8 ?? ?? ?? ?? 85 C0 75 ?? 81 FB ?? ?? ?? ?? 74 ?? 8B CB E8 
            ?? ?? ?? ?? 85 C0 74 ?? 8B C8 8B D7 E8 ?? ?? ?? ?? 5B 5F C3 8B CB E8 ?? ?? ?? ?? 84 
            C0 74 ?? 8B CB E8 ?? ?? ?? ?? 85 C0 75 ?? 33 C0 EB 
        }

        $resolve_api_wrapper_3 = {
            55 8B EC 57 8B 7D ?? 57 E8 ?? ?? ?? ?? 85 C0 75 ?? 56 8B 75 ?? 81 FE ?? ?? ?? ?? 74 
            ?? 56 E8 ?? ?? ?? ?? 85 C0 75 ?? 8B CE E8 ?? ?? ?? ?? 84 C0 74 ?? 56 E8 ?? ?? ?? ?? 
            85 C0 75 ?? 5E 33 C0 5F 5D C2 ?? ?? 57 50 E8 ?? ?? ?? ?? 5E 5F 5D C2 
        }

        $resolve_api_wrapper_4 = {
            55 8B EC FF 75 ?? E8 ?? ?? ?? ?? 85 C0 75 ?? 56 8B 75 ?? 81 FE ?? ?? ?? ?? 74 ?? 56 
            E8 ?? ?? ?? ?? 85 C0 75 ?? 8B CE E8 ?? ?? ?? ?? 84 C0 74 ?? 56 E8 ?? ?? ?? ?? 85 C0 
            74 ?? 5E 89 45 ?? 5D E9 
        }

        $find_first_file_snippet_1 = {
            53 56 8B F1 57 33 DB 32 C9 89 5E ?? 33 FF E8 ?? ?? ?? ?? 83 38 ?? 7C ?? [4-6] BA ?? 
            ?? ?? ?? B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 ?? 8B 4E ?? 57 6A ?? 6A ?? 8D 56 ?? 
            52 53 51 FF D0 
        }

        $find_first_file_snippet_2 = {
            57 53 55 8B E9 33 C9 C7 45 ?? ?? ?? ?? ?? E8 ?? ?? ?? ?? B9 ?? ?? ?? ?? BA ?? ?? ?? 
            ?? 8B 18 E8 ?? ?? ?? ?? 8B C8 85 C9 74 ?? 33 D2 83 FB ?? 6A ?? 5B 8D 7D ?? 0F 4C DA 
            8B C2 53 52 52 57 0F 9D C0 50 FF 75 ?? FF D1 
        }

        $find_first_file_snippet_3 = {
            53 56 8B F1 33 DB 57 32 C9 89 5E ?? E8 ?? ?? ?? ?? BA ?? ?? ?? ?? B9 ?? ?? ?? ?? 8B 
            38 E8 ?? ?? ?? ?? 8B D0 85 D2 74 ?? 6A ?? 33 C0 83 FF ?? 59 0F 4C C8 8D 46 ?? 51 53 
            53 50 33 C0 83 FF ?? 0F 9D C0 50 FF 76 ?? FF D2 
        }

        $find_first_file_snippet_4 = {
            53 56 8B F1 57 33 DB 32 C9 89 5E ?? 33 FF E8 ?? ?? ?? ?? 83 38 ?? 7C ?? 8D 7B ?? 8D 
            5F ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 ?? 8B 4E ?? 57 6A ?? 6A 
            ?? 8D 56 ?? 52 53 51 CC C3 
        }

        $find_first_file_snippet_5 = {
            56 8B F1 32 C9 57 C7 46 ?? ?? ?? ?? ?? E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 
            8B 38 E8 ?? ?? ?? ?? 8B D0 85 D2 74 ?? 33 C0 B9 ?? ?? ?? ?? 83 FF ?? 0F 4C C8 51 50 
            50 8D 46 ?? 50 33 C0 83 FF ?? 0F 9D C0 50 FF 76 ?? FF D2 
        }

    condition:
        uint16(0) == 0x5A4D and
        (
            any of ($resolve_api_wrapper_*) and 
            any of ($find_first_file_snippet_*)
        )
}