rule MALWARE_OneNote_Delivery_Jan23
{
	meta:
		author = "SECUINFRA Falcon Team (@SI_FalconTeam)"
		description = "Detects suspicious Microsoft OneNote files used to deliver Malware"
		reference = "https://twitter.com/James_inthe_box/status/1615421130877329409"
		date = "2023-01-19"
		tlp = "CLEAR"
		hash0 = "18af397a27e58afb901c92f37569d48e3372cf073915723e4e73d44537bcf54d"
		hash1 = "de30f2ba2d8916db5ce398ed580714e2a8e75376f31dc346b0e3c898ee0ae4cf"
		hash2 = "bfc979c0146d792283f825f99772370f6ff294dfb5b1e056943696aee9bc9f7b"
		hash3 = "e0d9f2a72d64108a93e0cfd8066c04ed8eabe2ed43b80b3f589b9b21e7f9a488"
		hash4 = "3f00a56cbf9a0e59309f395a6a0b3457c7675a657b3e091d1a9440bd17963f59"
		yarahub_reference_md5 = "65b3b312dfaf25a72e9171271909357e"
		yarahub_uuid = "1b3f4b6b-9dd4-4080-af23-195078bf3abe"
		yarahub_license = "CC BY 4.0"
		yarahub_rule_matching_tlp = "TLP:WHITE"
		yarahub_rule_sharing_tlp = "TLP:WHITE"
		yarahub_author_twitter = "@SI_FalconTeam"

	strings:
		// HTA
		$hta = "hta:application" nocase
		$script1 = "type=\"text/vbscript\""
		$script2 = "language=\"VBScript\""
		
		// Powershell
		$powershell = "powershell" nocase
		$startProc = "Start-Process -Filepath"
		$webReq = "Invoke-WebRequest -Uri"
		$bitsadmin = "bitsadmin /transfer"
		
		//WScript
		$wscript = "WScript.Shell" nocase
		$autoOpen = "Sub AutoOpen()"
		$root = "GetObject(\"winmgmts:\\.\\root\\cimv2\")"
		$wsfExt = ".wsf" ascii wide
		$vbsExt = ".vbs" ascii wide

		// Batch
		$cmd = "cmd /c" nocase
		$batch = "@echo off"
		$batExt = ".bat" ascii wide
		$delExit = "(goto) 2>nul & del \"%~f0\"..exit /b"

		// PE Files
		$dosString = "!This program cannot be run in DOS mode"
		$exeExt = ".exe" ascii wide
		
		// Image Lure
		$imageFile = "button_click-to-view-document.png" wide
		$click = "click to view document" nocase wide
		
		// Leaked File Paths
		$path1 = "C:\\Users\\My\\OneDrive\\Desktop" wide
		$path2 = "C:\\Users\\Administrator\\Documents\\Dove" wide
		$path3 = "C:\\Users\\julien.galleron\\Downloads" wide
	
	condition:
		uint32be(0x0) == 0xE4525C7B
		and 3 of them
}