// ui/accessibility/mojom/ax_action_data.mojom-shared-internal.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_ACCESSIBILITY_MOJOM_AX_ACTION_DATA_MOJOM_SHARED_INTERNAL_H_
#define UI_ACCESSIBILITY_MOJOM_AX_ACTION_DATA_MOJOM_SHARED_INTERNAL_H_

#include "mojo/public/cpp/bindings/lib/array_internal.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/map_data_internal.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"
#include "ui/accessibility/ax_enums.mojom-shared-internal.h"
#include "ui/accessibility/mojom/ax_tree_id.mojom-shared-internal.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared-internal.h"
#include "mojo/public/cpp/bindings/lib/native_enum_data.h"
#include "mojo/public/interfaces/bindings/native_struct.mojom-shared-internal.h"



namespace mojo {
namespace internal {
class ValidationContext;
}
}
namespace ax {
namespace mojom {
namespace internal {
class AXActionData_Data;

#pragma pack(push, 1)
class  AXActionData_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(AXActionData_Data));
      new (data()) AXActionData_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    AXActionData_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<AXActionData_Data>(index_);
    }
    AXActionData_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t action;
  int32_t target_node_id;
  ::ax::mojom::internal::AXTreeID_Data target_tree_id;
  mojo::internal::Pointer<mojo::internal::String_Data> source_extension_id;
  int32_t request_id;
  int32_t flags;
  int32_t anchor_node_id;
  int32_t anchor_offset;
  int32_t focus_node_id;
  int32_t focus_offset;
  int32_t custom_action_id;
  int32_t hit_test_event_to_fire;
  mojo::internal::Pointer<::gfx::mojom::internal::Rect_Data> target_rect;
  mojo::internal::Pointer<::gfx::mojom::internal::Point_Data> target_point;
  mojo::internal::Pointer<mojo::internal::String_Data> value;
  int32_t horizontal_scroll_alignment;
  int32_t vertical_scroll_alignment;
  int32_t scroll_behavior;
  uint8_t padfinal_[4];

 private:
  AXActionData_Data();
  ~AXActionData_Data() = delete;
};
static_assert(sizeof(AXActionData_Data) == 112,
              "Bad sizeof(AXActionData_Data)");
// Used by AXActionData::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct AXActionData_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  AXActionData_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~AXActionData_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    AXActionData_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    AXActionData_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};

#pragma pack(pop)

}  // namespace internal
}  // namespace mojom
}  // namespace ax

#endif  // UI_ACCESSIBILITY_MOJOM_AX_ACTION_DATA_MOJOM_SHARED_INTERNAL_H_