// third_party/blink/public/mojom/usb/web_usb_service.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_USB_WEB_USB_SERVICE_MOJOM_BLINK_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_USB_WEB_USB_SERVICE_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "third_party/blink/public/mojom/usb/web_usb_service.mojom-shared.h"
#include "third_party/blink/public/mojom/usb/web_usb_service.mojom-blink-forward.h"
#include "services/device/public/mojom/usb_device.mojom-blink.h"
#include "services/device/public/mojom/usb_enumeration_options.mojom-blink.h"
#include "services/device/public/mojom/usb_manager_client.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"


#include "third_party/blink/renderer/platform/platform_export.h"



// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace blink {
namespace mojom {
namespace blink {

class WebUsbServiceProxy;

template <typename ImplRefTraits>
class WebUsbServiceStub;

class WebUsbServiceRequestValidator;
class WebUsbServiceResponseValidator;


class PLATFORM_EXPORT WebUsbService
    : public WebUsbServiceInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = true;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = WebUsbServiceInterfaceBase;
  using Proxy_ = WebUsbServiceProxy;

  template <typename ImplRefTraits>
  using Stub_ = WebUsbServiceStub<ImplRefTraits>;

  using RequestValidator_ = WebUsbServiceRequestValidator;
  using ResponseValidator_ = WebUsbServiceResponseValidator;
  enum MethodMinVersions : uint32_t {
    kGetDevicesMinVersion = 0,
    kGetDeviceMinVersion = 0,
    kGetPermissionMinVersion = 0,
    kSetClientMinVersion = 0,
  };
  virtual ~WebUsbService() {}


  using GetDevicesCallback = base::OnceCallback<void(WTF::Vector<::device::mojom::blink::UsbDeviceInfoPtr>)>;
  
  virtual void GetDevices(GetDevicesCallback callback) = 0;

  
  virtual void GetDevice(const WTF::String& guid, ::mojo::PendingReceiver<::device::mojom::blink::UsbDevice> device_receiver) = 0;


  using GetPermissionCallback = base::OnceCallback<void(::device::mojom::blink::UsbDeviceInfoPtr)>;
  
  virtual void GetPermission(WTF::Vector<::device::mojom::blink::UsbDeviceFilterPtr> device_filters, GetPermissionCallback callback) = 0;

  
  virtual void SetClient(::mojo::PendingAssociatedRemote<::device::mojom::blink::UsbDeviceManagerClient> client) = 0;
};



class PLATFORM_EXPORT WebUsbServiceProxy
    : public WebUsbService {
 public:
  using InterfaceType = WebUsbService;

  explicit WebUsbServiceProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void GetDevices(GetDevicesCallback callback) final;
  
  void GetDevice(const WTF::String& guid, ::mojo::PendingReceiver<::device::mojom::blink::UsbDevice> device_receiver) final;
  
  void GetPermission(WTF::Vector<::device::mojom::blink::UsbDeviceFilterPtr> device_filters, GetPermissionCallback callback) final;
  
  void SetClient(::mojo::PendingAssociatedRemote<::device::mojom::blink::UsbDeviceManagerClient> client) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class PLATFORM_EXPORT WebUsbServiceStubDispatch {
 public:
  static bool Accept(WebUsbService* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      WebUsbService* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<WebUsbService>>
class WebUsbServiceStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  WebUsbServiceStub() {}
  ~WebUsbServiceStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WebUsbServiceStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WebUsbServiceStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class PLATFORM_EXPORT WebUsbServiceRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class PLATFORM_EXPORT WebUsbServiceResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // namespace blink
}  // namespace mojom
}  // namespace blink

namespace mojo {

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_USB_WEB_USB_SERVICE_MOJOM_BLINK_H_