// third_party/blink/public/mojom/tokens/tokens.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_TOKENS_TOKENS_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_TOKENS_TOKENS_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <ostream>
#include <type_traits>
#include <utility>

#include "base/compiler_specific.h"
#include "base/containers/flat_map.h"
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "third_party/blink/public/mojom/tokens/tokens.mojom-shared-internal.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"



#include "base/component_export.h"




namespace blink {
namespace mojom {
class LocalFrameTokenDataView;

class RemoteFrameTokenDataView;

class DedicatedWorkerTokenDataView;

class ServiceWorkerTokenDataView;

class SharedWorkerTokenDataView;

class AnimationWorkletTokenDataView;

class AudioWorkletTokenDataView;

class LayoutWorkletTokenDataView;

class PaintWorkletTokenDataView;

class PortalTokenDataView;

class V8ContextTokenDataView;

class FrameTokenDataView;
class WorkerTokenDataView;
class WorkletTokenDataView;
class ExecutionContextTokenDataView;


}  // namespace mojom
}  // namespace blink

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::LocalFrameTokenDataView> {
  using Data = ::blink::mojom::internal::LocalFrameToken_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::RemoteFrameTokenDataView> {
  using Data = ::blink::mojom::internal::RemoteFrameToken_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::DedicatedWorkerTokenDataView> {
  using Data = ::blink::mojom::internal::DedicatedWorkerToken_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::ServiceWorkerTokenDataView> {
  using Data = ::blink::mojom::internal::ServiceWorkerToken_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::SharedWorkerTokenDataView> {
  using Data = ::blink::mojom::internal::SharedWorkerToken_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::AnimationWorkletTokenDataView> {
  using Data = ::blink::mojom::internal::AnimationWorkletToken_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::AudioWorkletTokenDataView> {
  using Data = ::blink::mojom::internal::AudioWorkletToken_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::LayoutWorkletTokenDataView> {
  using Data = ::blink::mojom::internal::LayoutWorkletToken_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::PaintWorkletTokenDataView> {
  using Data = ::blink::mojom::internal::PaintWorkletToken_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::PortalTokenDataView> {
  using Data = ::blink::mojom::internal::PortalToken_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::V8ContextTokenDataView> {
  using Data = ::blink::mojom::internal::V8ContextToken_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::FrameTokenDataView> {
  using Data = ::blink::mojom::internal::FrameToken_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

template <>
struct MojomTypeTraits<::blink::mojom::WorkerTokenDataView> {
  using Data = ::blink::mojom::internal::WorkerToken_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

template <>
struct MojomTypeTraits<::blink::mojom::WorkletTokenDataView> {
  using Data = ::blink::mojom::internal::WorkletToken_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

template <>
struct MojomTypeTraits<::blink::mojom::ExecutionContextTokenDataView> {
  using Data = ::blink::mojom::internal::ExecutionContextToken_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace blink {
namespace mojom {


class LocalFrameTokenDataView {
 public:
  LocalFrameTokenDataView() {}

  LocalFrameTokenDataView(
      internal::LocalFrameToken_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetValueDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadValue(UserType* output) {
    
    auto* pointer = data_->value.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, context_);
  }
 private:
  internal::LocalFrameToken_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class RemoteFrameTokenDataView {
 public:
  RemoteFrameTokenDataView() {}

  RemoteFrameTokenDataView(
      internal::RemoteFrameToken_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetValueDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadValue(UserType* output) {
    
    auto* pointer = data_->value.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, context_);
  }
 private:
  internal::RemoteFrameToken_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class DedicatedWorkerTokenDataView {
 public:
  DedicatedWorkerTokenDataView() {}

  DedicatedWorkerTokenDataView(
      internal::DedicatedWorkerToken_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetValueDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadValue(UserType* output) {
    
    auto* pointer = data_->value.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, context_);
  }
 private:
  internal::DedicatedWorkerToken_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class ServiceWorkerTokenDataView {
 public:
  ServiceWorkerTokenDataView() {}

  ServiceWorkerTokenDataView(
      internal::ServiceWorkerToken_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetValueDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadValue(UserType* output) {
    
    auto* pointer = data_->value.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, context_);
  }
 private:
  internal::ServiceWorkerToken_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class SharedWorkerTokenDataView {
 public:
  SharedWorkerTokenDataView() {}

  SharedWorkerTokenDataView(
      internal::SharedWorkerToken_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetValueDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadValue(UserType* output) {
    
    auto* pointer = data_->value.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, context_);
  }
 private:
  internal::SharedWorkerToken_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class AnimationWorkletTokenDataView {
 public:
  AnimationWorkletTokenDataView() {}

  AnimationWorkletTokenDataView(
      internal::AnimationWorkletToken_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetValueDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadValue(UserType* output) {
    
    auto* pointer = data_->value.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, context_);
  }
 private:
  internal::AnimationWorkletToken_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class AudioWorkletTokenDataView {
 public:
  AudioWorkletTokenDataView() {}

  AudioWorkletTokenDataView(
      internal::AudioWorkletToken_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetValueDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadValue(UserType* output) {
    
    auto* pointer = data_->value.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, context_);
  }
 private:
  internal::AudioWorkletToken_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class LayoutWorkletTokenDataView {
 public:
  LayoutWorkletTokenDataView() {}

  LayoutWorkletTokenDataView(
      internal::LayoutWorkletToken_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetValueDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadValue(UserType* output) {
    
    auto* pointer = data_->value.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, context_);
  }
 private:
  internal::LayoutWorkletToken_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class PaintWorkletTokenDataView {
 public:
  PaintWorkletTokenDataView() {}

  PaintWorkletTokenDataView(
      internal::PaintWorkletToken_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetValueDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadValue(UserType* output) {
    
    auto* pointer = data_->value.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, context_);
  }
 private:
  internal::PaintWorkletToken_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class PortalTokenDataView {
 public:
  PortalTokenDataView() {}

  PortalTokenDataView(
      internal::PortalToken_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetValueDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadValue(UserType* output) {
    
    auto* pointer = data_->value.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, context_);
  }
 private:
  internal::PortalToken_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class V8ContextTokenDataView {
 public:
  V8ContextTokenDataView() {}

  V8ContextTokenDataView(
      internal::V8ContextToken_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetValueDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadValue(UserType* output) {
    
    auto* pointer = data_->value.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, context_);
  }
 private:
  internal::V8ContextToken_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class FrameTokenDataView {
 public:
  using Tag = internal::FrameToken_Data::FrameToken_Tag;

  FrameTokenDataView() {}

  FrameTokenDataView(
      internal::FrameToken_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_local_frame_token() const { return data_->tag == Tag::LOCAL_FRAME_TOKEN; }
  inline void GetLocalFrameTokenDataView(
      LocalFrameTokenDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadLocalFrameToken(UserType* output) {
    
    DCHECK(is_local_frame_token());
    return mojo::internal::Deserialize<::blink::mojom::LocalFrameTokenDataView>(
        data_->data.f_local_frame_token.Get(), output, context_);
  }
  bool is_remote_frame_token() const { return data_->tag == Tag::REMOTE_FRAME_TOKEN; }
  inline void GetRemoteFrameTokenDataView(
      RemoteFrameTokenDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadRemoteFrameToken(UserType* output) {
    
    DCHECK(is_remote_frame_token());
    return mojo::internal::Deserialize<::blink::mojom::RemoteFrameTokenDataView>(
        data_->data.f_remote_frame_token.Get(), output, context_);
  }

 private:
  internal::FrameToken_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class WorkerTokenDataView {
 public:
  using Tag = internal::WorkerToken_Data::WorkerToken_Tag;

  WorkerTokenDataView() {}

  WorkerTokenDataView(
      internal::WorkerToken_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_dedicated_worker_token() const { return data_->tag == Tag::DEDICATED_WORKER_TOKEN; }
  inline void GetDedicatedWorkerTokenDataView(
      DedicatedWorkerTokenDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadDedicatedWorkerToken(UserType* output) {
    
    DCHECK(is_dedicated_worker_token());
    return mojo::internal::Deserialize<::blink::mojom::DedicatedWorkerTokenDataView>(
        data_->data.f_dedicated_worker_token.Get(), output, context_);
  }
  bool is_service_worker_token() const { return data_->tag == Tag::SERVICE_WORKER_TOKEN; }
  inline void GetServiceWorkerTokenDataView(
      ServiceWorkerTokenDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadServiceWorkerToken(UserType* output) {
    
    DCHECK(is_service_worker_token());
    return mojo::internal::Deserialize<::blink::mojom::ServiceWorkerTokenDataView>(
        data_->data.f_service_worker_token.Get(), output, context_);
  }
  bool is_shared_worker_token() const { return data_->tag == Tag::SHARED_WORKER_TOKEN; }
  inline void GetSharedWorkerTokenDataView(
      SharedWorkerTokenDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadSharedWorkerToken(UserType* output) {
    
    DCHECK(is_shared_worker_token());
    return mojo::internal::Deserialize<::blink::mojom::SharedWorkerTokenDataView>(
        data_->data.f_shared_worker_token.Get(), output, context_);
  }

 private:
  internal::WorkerToken_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class WorkletTokenDataView {
 public:
  using Tag = internal::WorkletToken_Data::WorkletToken_Tag;

  WorkletTokenDataView() {}

  WorkletTokenDataView(
      internal::WorkletToken_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_animation_worklet_token() const { return data_->tag == Tag::ANIMATION_WORKLET_TOKEN; }
  inline void GetAnimationWorkletTokenDataView(
      AnimationWorkletTokenDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadAnimationWorkletToken(UserType* output) {
    
    DCHECK(is_animation_worklet_token());
    return mojo::internal::Deserialize<::blink::mojom::AnimationWorkletTokenDataView>(
        data_->data.f_animation_worklet_token.Get(), output, context_);
  }
  bool is_audio_worklet_token() const { return data_->tag == Tag::AUDIO_WORKLET_TOKEN; }
  inline void GetAudioWorkletTokenDataView(
      AudioWorkletTokenDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadAudioWorkletToken(UserType* output) {
    
    DCHECK(is_audio_worklet_token());
    return mojo::internal::Deserialize<::blink::mojom::AudioWorkletTokenDataView>(
        data_->data.f_audio_worklet_token.Get(), output, context_);
  }
  bool is_layout_worklet_token() const { return data_->tag == Tag::LAYOUT_WORKLET_TOKEN; }
  inline void GetLayoutWorkletTokenDataView(
      LayoutWorkletTokenDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadLayoutWorkletToken(UserType* output) {
    
    DCHECK(is_layout_worklet_token());
    return mojo::internal::Deserialize<::blink::mojom::LayoutWorkletTokenDataView>(
        data_->data.f_layout_worklet_token.Get(), output, context_);
  }
  bool is_paint_worklet_token() const { return data_->tag == Tag::PAINT_WORKLET_TOKEN; }
  inline void GetPaintWorkletTokenDataView(
      PaintWorkletTokenDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadPaintWorkletToken(UserType* output) {
    
    DCHECK(is_paint_worklet_token());
    return mojo::internal::Deserialize<::blink::mojom::PaintWorkletTokenDataView>(
        data_->data.f_paint_worklet_token.Get(), output, context_);
  }

 private:
  internal::WorkletToken_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class ExecutionContextTokenDataView {
 public:
  using Tag = internal::ExecutionContextToken_Data::ExecutionContextToken_Tag;

  ExecutionContextTokenDataView() {}

  ExecutionContextTokenDataView(
      internal::ExecutionContextToken_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_local_frame_token() const { return data_->tag == Tag::LOCAL_FRAME_TOKEN; }
  inline void GetLocalFrameTokenDataView(
      LocalFrameTokenDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadLocalFrameToken(UserType* output) {
    
    DCHECK(is_local_frame_token());
    return mojo::internal::Deserialize<::blink::mojom::LocalFrameTokenDataView>(
        data_->data.f_local_frame_token.Get(), output, context_);
  }
  bool is_dedicated_worker_token() const { return data_->tag == Tag::DEDICATED_WORKER_TOKEN; }
  inline void GetDedicatedWorkerTokenDataView(
      DedicatedWorkerTokenDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadDedicatedWorkerToken(UserType* output) {
    
    DCHECK(is_dedicated_worker_token());
    return mojo::internal::Deserialize<::blink::mojom::DedicatedWorkerTokenDataView>(
        data_->data.f_dedicated_worker_token.Get(), output, context_);
  }
  bool is_service_worker_token() const { return data_->tag == Tag::SERVICE_WORKER_TOKEN; }
  inline void GetServiceWorkerTokenDataView(
      ServiceWorkerTokenDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadServiceWorkerToken(UserType* output) {
    
    DCHECK(is_service_worker_token());
    return mojo::internal::Deserialize<::blink::mojom::ServiceWorkerTokenDataView>(
        data_->data.f_service_worker_token.Get(), output, context_);
  }
  bool is_shared_worker_token() const { return data_->tag == Tag::SHARED_WORKER_TOKEN; }
  inline void GetSharedWorkerTokenDataView(
      SharedWorkerTokenDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadSharedWorkerToken(UserType* output) {
    
    DCHECK(is_shared_worker_token());
    return mojo::internal::Deserialize<::blink::mojom::SharedWorkerTokenDataView>(
        data_->data.f_shared_worker_token.Get(), output, context_);
  }
  bool is_animation_worklet_token() const { return data_->tag == Tag::ANIMATION_WORKLET_TOKEN; }
  inline void GetAnimationWorkletTokenDataView(
      AnimationWorkletTokenDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadAnimationWorkletToken(UserType* output) {
    
    DCHECK(is_animation_worklet_token());
    return mojo::internal::Deserialize<::blink::mojom::AnimationWorkletTokenDataView>(
        data_->data.f_animation_worklet_token.Get(), output, context_);
  }
  bool is_audio_worklet_token() const { return data_->tag == Tag::AUDIO_WORKLET_TOKEN; }
  inline void GetAudioWorkletTokenDataView(
      AudioWorkletTokenDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadAudioWorkletToken(UserType* output) {
    
    DCHECK(is_audio_worklet_token());
    return mojo::internal::Deserialize<::blink::mojom::AudioWorkletTokenDataView>(
        data_->data.f_audio_worklet_token.Get(), output, context_);
  }
  bool is_layout_worklet_token() const { return data_->tag == Tag::LAYOUT_WORKLET_TOKEN; }
  inline void GetLayoutWorkletTokenDataView(
      LayoutWorkletTokenDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadLayoutWorkletToken(UserType* output) {
    
    DCHECK(is_layout_worklet_token());
    return mojo::internal::Deserialize<::blink::mojom::LayoutWorkletTokenDataView>(
        data_->data.f_layout_worklet_token.Get(), output, context_);
  }
  bool is_paint_worklet_token() const { return data_->tag == Tag::PAINT_WORKLET_TOKEN; }
  inline void GetPaintWorkletTokenDataView(
      PaintWorkletTokenDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadPaintWorkletToken(UserType* output) {
    
    DCHECK(is_paint_worklet_token());
    return mojo::internal::Deserialize<::blink::mojom::PaintWorkletTokenDataView>(
        data_->data.f_paint_worklet_token.Get(), output, context_);
  }

 private:
  internal::ExecutionContextToken_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



}  // namespace mojom
}  // namespace blink

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::LocalFrameTokenDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::LocalFrameTokenDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::blink::mojom::internal::LocalFrameToken_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::value(input)) in_value = Traits::value(input);
    typename decltype((*output)->value)::BaseType::BufferWriter
        value_writer;
    mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
        in_value, buffer, &value_writer, context);
    (*output)->value.Set(
        value_writer.is_null() ? nullptr : value_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->value.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null value in LocalFrameToken struct");
  }

  static bool Deserialize(::blink::mojom::internal::LocalFrameToken_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::LocalFrameTokenDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::RemoteFrameTokenDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::RemoteFrameTokenDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::blink::mojom::internal::RemoteFrameToken_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::value(input)) in_value = Traits::value(input);
    typename decltype((*output)->value)::BaseType::BufferWriter
        value_writer;
    mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
        in_value, buffer, &value_writer, context);
    (*output)->value.Set(
        value_writer.is_null() ? nullptr : value_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->value.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null value in RemoteFrameToken struct");
  }

  static bool Deserialize(::blink::mojom::internal::RemoteFrameToken_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::RemoteFrameTokenDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::DedicatedWorkerTokenDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::DedicatedWorkerTokenDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::blink::mojom::internal::DedicatedWorkerToken_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::value(input)) in_value = Traits::value(input);
    typename decltype((*output)->value)::BaseType::BufferWriter
        value_writer;
    mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
        in_value, buffer, &value_writer, context);
    (*output)->value.Set(
        value_writer.is_null() ? nullptr : value_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->value.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null value in DedicatedWorkerToken struct");
  }

  static bool Deserialize(::blink::mojom::internal::DedicatedWorkerToken_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::DedicatedWorkerTokenDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::ServiceWorkerTokenDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::ServiceWorkerTokenDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::blink::mojom::internal::ServiceWorkerToken_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::value(input)) in_value = Traits::value(input);
    typename decltype((*output)->value)::BaseType::BufferWriter
        value_writer;
    mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
        in_value, buffer, &value_writer, context);
    (*output)->value.Set(
        value_writer.is_null() ? nullptr : value_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->value.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null value in ServiceWorkerToken struct");
  }

  static bool Deserialize(::blink::mojom::internal::ServiceWorkerToken_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::ServiceWorkerTokenDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::SharedWorkerTokenDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::SharedWorkerTokenDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::blink::mojom::internal::SharedWorkerToken_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::value(input)) in_value = Traits::value(input);
    typename decltype((*output)->value)::BaseType::BufferWriter
        value_writer;
    mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
        in_value, buffer, &value_writer, context);
    (*output)->value.Set(
        value_writer.is_null() ? nullptr : value_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->value.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null value in SharedWorkerToken struct");
  }

  static bool Deserialize(::blink::mojom::internal::SharedWorkerToken_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::SharedWorkerTokenDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::AnimationWorkletTokenDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::AnimationWorkletTokenDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::blink::mojom::internal::AnimationWorkletToken_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::value(input)) in_value = Traits::value(input);
    typename decltype((*output)->value)::BaseType::BufferWriter
        value_writer;
    mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
        in_value, buffer, &value_writer, context);
    (*output)->value.Set(
        value_writer.is_null() ? nullptr : value_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->value.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null value in AnimationWorkletToken struct");
  }

  static bool Deserialize(::blink::mojom::internal::AnimationWorkletToken_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::AnimationWorkletTokenDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::AudioWorkletTokenDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::AudioWorkletTokenDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::blink::mojom::internal::AudioWorkletToken_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::value(input)) in_value = Traits::value(input);
    typename decltype((*output)->value)::BaseType::BufferWriter
        value_writer;
    mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
        in_value, buffer, &value_writer, context);
    (*output)->value.Set(
        value_writer.is_null() ? nullptr : value_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->value.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null value in AudioWorkletToken struct");
  }

  static bool Deserialize(::blink::mojom::internal::AudioWorkletToken_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::AudioWorkletTokenDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::LayoutWorkletTokenDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::LayoutWorkletTokenDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::blink::mojom::internal::LayoutWorkletToken_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::value(input)) in_value = Traits::value(input);
    typename decltype((*output)->value)::BaseType::BufferWriter
        value_writer;
    mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
        in_value, buffer, &value_writer, context);
    (*output)->value.Set(
        value_writer.is_null() ? nullptr : value_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->value.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null value in LayoutWorkletToken struct");
  }

  static bool Deserialize(::blink::mojom::internal::LayoutWorkletToken_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::LayoutWorkletTokenDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::PaintWorkletTokenDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::PaintWorkletTokenDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::blink::mojom::internal::PaintWorkletToken_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::value(input)) in_value = Traits::value(input);
    typename decltype((*output)->value)::BaseType::BufferWriter
        value_writer;
    mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
        in_value, buffer, &value_writer, context);
    (*output)->value.Set(
        value_writer.is_null() ? nullptr : value_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->value.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null value in PaintWorkletToken struct");
  }

  static bool Deserialize(::blink::mojom::internal::PaintWorkletToken_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::PaintWorkletTokenDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::PortalTokenDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::PortalTokenDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::blink::mojom::internal::PortalToken_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::value(input)) in_value = Traits::value(input);
    typename decltype((*output)->value)::BaseType::BufferWriter
        value_writer;
    mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
        in_value, buffer, &value_writer, context);
    (*output)->value.Set(
        value_writer.is_null() ? nullptr : value_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->value.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null value in PortalToken struct");
  }

  static bool Deserialize(::blink::mojom::internal::PortalToken_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::PortalTokenDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::V8ContextTokenDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::V8ContextTokenDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::blink::mojom::internal::V8ContextToken_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::value(input)) in_value = Traits::value(input);
    typename decltype((*output)->value)::BaseType::BufferWriter
        value_writer;
    mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
        in_value, buffer, &value_writer, context);
    (*output)->value.Set(
        value_writer.is_null() ? nullptr : value_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->value.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null value in V8ContextToken struct");
  }

  static bool Deserialize(::blink::mojom::internal::V8ContextToken_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::V8ContextTokenDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::FrameTokenDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::blink::mojom::FrameTokenDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::blink::mojom::internal::FrameToken_Data::BufferWriter* writer,
                        bool inlined,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
         writer->data()->set_null();
      return;
    }
    if (!inlined)
      writer->Allocate(buffer);

    ::blink::mojom::internal::FrameToken_Data::BufferWriter& result = *writer;
    ALLOW_UNUSED_LOCAL(result);
    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
    result->size = kUnionDataSize;
    result->tag = Traits::GetTag(input);
    switch (result->tag) {
      case ::blink::mojom::FrameTokenDataView::Tag::LOCAL_FRAME_TOKEN: {
        decltype(Traits::local_frame_token(input))
            in_local_frame_token = Traits::local_frame_token(input);
        typename decltype(result->data.f_local_frame_token)::BaseType::BufferWriter
            value_writer;
        mojo::internal::Serialize<::blink::mojom::LocalFrameTokenDataView>(
            in_local_frame_token, buffer, &value_writer, context);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_writer.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null local_frame_token in FrameToken union");
        result->data.f_local_frame_token.Set(
            value_writer.is_null() ? nullptr : value_writer.data());
        break;
      }
      case ::blink::mojom::FrameTokenDataView::Tag::REMOTE_FRAME_TOKEN: {
        decltype(Traits::remote_frame_token(input))
            in_remote_frame_token = Traits::remote_frame_token(input);
        typename decltype(result->data.f_remote_frame_token)::BaseType::BufferWriter
            value_writer;
        mojo::internal::Serialize<::blink::mojom::RemoteFrameTokenDataView>(
            in_remote_frame_token, buffer, &value_writer, context);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_writer.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null remote_frame_token in FrameToken union");
        result->data.f_remote_frame_token.Set(
            value_writer.is_null() ? nullptr : value_writer.data());
        break;
      }
    }
  }

  static bool Deserialize(::blink::mojom::internal::FrameToken_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::FrameTokenDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::WorkerTokenDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::blink::mojom::WorkerTokenDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::blink::mojom::internal::WorkerToken_Data::BufferWriter* writer,
                        bool inlined,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
         writer->data()->set_null();
      return;
    }
    if (!inlined)
      writer->Allocate(buffer);

    ::blink::mojom::internal::WorkerToken_Data::BufferWriter& result = *writer;
    ALLOW_UNUSED_LOCAL(result);
    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
    result->size = kUnionDataSize;
    result->tag = Traits::GetTag(input);
    switch (result->tag) {
      case ::blink::mojom::WorkerTokenDataView::Tag::DEDICATED_WORKER_TOKEN: {
        decltype(Traits::dedicated_worker_token(input))
            in_dedicated_worker_token = Traits::dedicated_worker_token(input);
        typename decltype(result->data.f_dedicated_worker_token)::BaseType::BufferWriter
            value_writer;
        mojo::internal::Serialize<::blink::mojom::DedicatedWorkerTokenDataView>(
            in_dedicated_worker_token, buffer, &value_writer, context);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_writer.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null dedicated_worker_token in WorkerToken union");
        result->data.f_dedicated_worker_token.Set(
            value_writer.is_null() ? nullptr : value_writer.data());
        break;
      }
      case ::blink::mojom::WorkerTokenDataView::Tag::SERVICE_WORKER_TOKEN: {
        decltype(Traits::service_worker_token(input))
            in_service_worker_token = Traits::service_worker_token(input);
        typename decltype(result->data.f_service_worker_token)::BaseType::BufferWriter
            value_writer;
        mojo::internal::Serialize<::blink::mojom::ServiceWorkerTokenDataView>(
            in_service_worker_token, buffer, &value_writer, context);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_writer.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null service_worker_token in WorkerToken union");
        result->data.f_service_worker_token.Set(
            value_writer.is_null() ? nullptr : value_writer.data());
        break;
      }
      case ::blink::mojom::WorkerTokenDataView::Tag::SHARED_WORKER_TOKEN: {
        decltype(Traits::shared_worker_token(input))
            in_shared_worker_token = Traits::shared_worker_token(input);
        typename decltype(result->data.f_shared_worker_token)::BaseType::BufferWriter
            value_writer;
        mojo::internal::Serialize<::blink::mojom::SharedWorkerTokenDataView>(
            in_shared_worker_token, buffer, &value_writer, context);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_writer.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null shared_worker_token in WorkerToken union");
        result->data.f_shared_worker_token.Set(
            value_writer.is_null() ? nullptr : value_writer.data());
        break;
      }
    }
  }

  static bool Deserialize(::blink::mojom::internal::WorkerToken_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::WorkerTokenDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::WorkletTokenDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::blink::mojom::WorkletTokenDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::blink::mojom::internal::WorkletToken_Data::BufferWriter* writer,
                        bool inlined,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
         writer->data()->set_null();
      return;
    }
    if (!inlined)
      writer->Allocate(buffer);

    ::blink::mojom::internal::WorkletToken_Data::BufferWriter& result = *writer;
    ALLOW_UNUSED_LOCAL(result);
    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
    result->size = kUnionDataSize;
    result->tag = Traits::GetTag(input);
    switch (result->tag) {
      case ::blink::mojom::WorkletTokenDataView::Tag::ANIMATION_WORKLET_TOKEN: {
        decltype(Traits::animation_worklet_token(input))
            in_animation_worklet_token = Traits::animation_worklet_token(input);
        typename decltype(result->data.f_animation_worklet_token)::BaseType::BufferWriter
            value_writer;
        mojo::internal::Serialize<::blink::mojom::AnimationWorkletTokenDataView>(
            in_animation_worklet_token, buffer, &value_writer, context);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_writer.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null animation_worklet_token in WorkletToken union");
        result->data.f_animation_worklet_token.Set(
            value_writer.is_null() ? nullptr : value_writer.data());
        break;
      }
      case ::blink::mojom::WorkletTokenDataView::Tag::AUDIO_WORKLET_TOKEN: {
        decltype(Traits::audio_worklet_token(input))
            in_audio_worklet_token = Traits::audio_worklet_token(input);
        typename decltype(result->data.f_audio_worklet_token)::BaseType::BufferWriter
            value_writer;
        mojo::internal::Serialize<::blink::mojom::AudioWorkletTokenDataView>(
            in_audio_worklet_token, buffer, &value_writer, context);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_writer.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null audio_worklet_token in WorkletToken union");
        result->data.f_audio_worklet_token.Set(
            value_writer.is_null() ? nullptr : value_writer.data());
        break;
      }
      case ::blink::mojom::WorkletTokenDataView::Tag::LAYOUT_WORKLET_TOKEN: {
        decltype(Traits::layout_worklet_token(input))
            in_layout_worklet_token = Traits::layout_worklet_token(input);
        typename decltype(result->data.f_layout_worklet_token)::BaseType::BufferWriter
            value_writer;
        mojo::internal::Serialize<::blink::mojom::LayoutWorkletTokenDataView>(
            in_layout_worklet_token, buffer, &value_writer, context);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_writer.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null layout_worklet_token in WorkletToken union");
        result->data.f_layout_worklet_token.Set(
            value_writer.is_null() ? nullptr : value_writer.data());
        break;
      }
      case ::blink::mojom::WorkletTokenDataView::Tag::PAINT_WORKLET_TOKEN: {
        decltype(Traits::paint_worklet_token(input))
            in_paint_worklet_token = Traits::paint_worklet_token(input);
        typename decltype(result->data.f_paint_worklet_token)::BaseType::BufferWriter
            value_writer;
        mojo::internal::Serialize<::blink::mojom::PaintWorkletTokenDataView>(
            in_paint_worklet_token, buffer, &value_writer, context);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_writer.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null paint_worklet_token in WorkletToken union");
        result->data.f_paint_worklet_token.Set(
            value_writer.is_null() ? nullptr : value_writer.data());
        break;
      }
    }
  }

  static bool Deserialize(::blink::mojom::internal::WorkletToken_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::WorkletTokenDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::ExecutionContextTokenDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::blink::mojom::ExecutionContextTokenDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::blink::mojom::internal::ExecutionContextToken_Data::BufferWriter* writer,
                        bool inlined,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
         writer->data()->set_null();
      return;
    }
    if (!inlined)
      writer->Allocate(buffer);

    ::blink::mojom::internal::ExecutionContextToken_Data::BufferWriter& result = *writer;
    ALLOW_UNUSED_LOCAL(result);
    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
    result->size = kUnionDataSize;
    result->tag = Traits::GetTag(input);
    switch (result->tag) {
      case ::blink::mojom::ExecutionContextTokenDataView::Tag::LOCAL_FRAME_TOKEN: {
        decltype(Traits::local_frame_token(input))
            in_local_frame_token = Traits::local_frame_token(input);
        typename decltype(result->data.f_local_frame_token)::BaseType::BufferWriter
            value_writer;
        mojo::internal::Serialize<::blink::mojom::LocalFrameTokenDataView>(
            in_local_frame_token, buffer, &value_writer, context);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_writer.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null local_frame_token in ExecutionContextToken union");
        result->data.f_local_frame_token.Set(
            value_writer.is_null() ? nullptr : value_writer.data());
        break;
      }
      case ::blink::mojom::ExecutionContextTokenDataView::Tag::DEDICATED_WORKER_TOKEN: {
        decltype(Traits::dedicated_worker_token(input))
            in_dedicated_worker_token = Traits::dedicated_worker_token(input);
        typename decltype(result->data.f_dedicated_worker_token)::BaseType::BufferWriter
            value_writer;
        mojo::internal::Serialize<::blink::mojom::DedicatedWorkerTokenDataView>(
            in_dedicated_worker_token, buffer, &value_writer, context);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_writer.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null dedicated_worker_token in ExecutionContextToken union");
        result->data.f_dedicated_worker_token.Set(
            value_writer.is_null() ? nullptr : value_writer.data());
        break;
      }
      case ::blink::mojom::ExecutionContextTokenDataView::Tag::SERVICE_WORKER_TOKEN: {
        decltype(Traits::service_worker_token(input))
            in_service_worker_token = Traits::service_worker_token(input);
        typename decltype(result->data.f_service_worker_token)::BaseType::BufferWriter
            value_writer;
        mojo::internal::Serialize<::blink::mojom::ServiceWorkerTokenDataView>(
            in_service_worker_token, buffer, &value_writer, context);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_writer.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null service_worker_token in ExecutionContextToken union");
        result->data.f_service_worker_token.Set(
            value_writer.is_null() ? nullptr : value_writer.data());
        break;
      }
      case ::blink::mojom::ExecutionContextTokenDataView::Tag::SHARED_WORKER_TOKEN: {
        decltype(Traits::shared_worker_token(input))
            in_shared_worker_token = Traits::shared_worker_token(input);
        typename decltype(result->data.f_shared_worker_token)::BaseType::BufferWriter
            value_writer;
        mojo::internal::Serialize<::blink::mojom::SharedWorkerTokenDataView>(
            in_shared_worker_token, buffer, &value_writer, context);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_writer.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null shared_worker_token in ExecutionContextToken union");
        result->data.f_shared_worker_token.Set(
            value_writer.is_null() ? nullptr : value_writer.data());
        break;
      }
      case ::blink::mojom::ExecutionContextTokenDataView::Tag::ANIMATION_WORKLET_TOKEN: {
        decltype(Traits::animation_worklet_token(input))
            in_animation_worklet_token = Traits::animation_worklet_token(input);
        typename decltype(result->data.f_animation_worklet_token)::BaseType::BufferWriter
            value_writer;
        mojo::internal::Serialize<::blink::mojom::AnimationWorkletTokenDataView>(
            in_animation_worklet_token, buffer, &value_writer, context);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_writer.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null animation_worklet_token in ExecutionContextToken union");
        result->data.f_animation_worklet_token.Set(
            value_writer.is_null() ? nullptr : value_writer.data());
        break;
      }
      case ::blink::mojom::ExecutionContextTokenDataView::Tag::AUDIO_WORKLET_TOKEN: {
        decltype(Traits::audio_worklet_token(input))
            in_audio_worklet_token = Traits::audio_worklet_token(input);
        typename decltype(result->data.f_audio_worklet_token)::BaseType::BufferWriter
            value_writer;
        mojo::internal::Serialize<::blink::mojom::AudioWorkletTokenDataView>(
            in_audio_worklet_token, buffer, &value_writer, context);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_writer.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null audio_worklet_token in ExecutionContextToken union");
        result->data.f_audio_worklet_token.Set(
            value_writer.is_null() ? nullptr : value_writer.data());
        break;
      }
      case ::blink::mojom::ExecutionContextTokenDataView::Tag::LAYOUT_WORKLET_TOKEN: {
        decltype(Traits::layout_worklet_token(input))
            in_layout_worklet_token = Traits::layout_worklet_token(input);
        typename decltype(result->data.f_layout_worklet_token)::BaseType::BufferWriter
            value_writer;
        mojo::internal::Serialize<::blink::mojom::LayoutWorkletTokenDataView>(
            in_layout_worklet_token, buffer, &value_writer, context);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_writer.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null layout_worklet_token in ExecutionContextToken union");
        result->data.f_layout_worklet_token.Set(
            value_writer.is_null() ? nullptr : value_writer.data());
        break;
      }
      case ::blink::mojom::ExecutionContextTokenDataView::Tag::PAINT_WORKLET_TOKEN: {
        decltype(Traits::paint_worklet_token(input))
            in_paint_worklet_token = Traits::paint_worklet_token(input);
        typename decltype(result->data.f_paint_worklet_token)::BaseType::BufferWriter
            value_writer;
        mojo::internal::Serialize<::blink::mojom::PaintWorkletTokenDataView>(
            in_paint_worklet_token, buffer, &value_writer, context);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_writer.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null paint_worklet_token in ExecutionContextToken union");
        result->data.f_paint_worklet_token.Set(
            value_writer.is_null() ? nullptr : value_writer.data());
        break;
      }
    }
  }

  static bool Deserialize(::blink::mojom::internal::ExecutionContextToken_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::ExecutionContextTokenDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink {
namespace mojom {

inline void LocalFrameTokenDataView::GetValueDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->value.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, context_);
}


inline void RemoteFrameTokenDataView::GetValueDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->value.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, context_);
}


inline void DedicatedWorkerTokenDataView::GetValueDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->value.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, context_);
}


inline void ServiceWorkerTokenDataView::GetValueDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->value.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, context_);
}


inline void SharedWorkerTokenDataView::GetValueDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->value.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, context_);
}


inline void AnimationWorkletTokenDataView::GetValueDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->value.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, context_);
}


inline void AudioWorkletTokenDataView::GetValueDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->value.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, context_);
}


inline void LayoutWorkletTokenDataView::GetValueDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->value.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, context_);
}


inline void PaintWorkletTokenDataView::GetValueDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->value.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, context_);
}


inline void PortalTokenDataView::GetValueDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->value.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, context_);
}


inline void V8ContextTokenDataView::GetValueDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->value.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, context_);
}


inline void FrameTokenDataView::GetLocalFrameTokenDataView(
    LocalFrameTokenDataView* output) {
  DCHECK(is_local_frame_token());
  *output = LocalFrameTokenDataView(data_->data.f_local_frame_token.Get(), context_);
}
inline void FrameTokenDataView::GetRemoteFrameTokenDataView(
    RemoteFrameTokenDataView* output) {
  DCHECK(is_remote_frame_token());
  *output = RemoteFrameTokenDataView(data_->data.f_remote_frame_token.Get(), context_);
}

inline void WorkerTokenDataView::GetDedicatedWorkerTokenDataView(
    DedicatedWorkerTokenDataView* output) {
  DCHECK(is_dedicated_worker_token());
  *output = DedicatedWorkerTokenDataView(data_->data.f_dedicated_worker_token.Get(), context_);
}
inline void WorkerTokenDataView::GetServiceWorkerTokenDataView(
    ServiceWorkerTokenDataView* output) {
  DCHECK(is_service_worker_token());
  *output = ServiceWorkerTokenDataView(data_->data.f_service_worker_token.Get(), context_);
}
inline void WorkerTokenDataView::GetSharedWorkerTokenDataView(
    SharedWorkerTokenDataView* output) {
  DCHECK(is_shared_worker_token());
  *output = SharedWorkerTokenDataView(data_->data.f_shared_worker_token.Get(), context_);
}

inline void WorkletTokenDataView::GetAnimationWorkletTokenDataView(
    AnimationWorkletTokenDataView* output) {
  DCHECK(is_animation_worklet_token());
  *output = AnimationWorkletTokenDataView(data_->data.f_animation_worklet_token.Get(), context_);
}
inline void WorkletTokenDataView::GetAudioWorkletTokenDataView(
    AudioWorkletTokenDataView* output) {
  DCHECK(is_audio_worklet_token());
  *output = AudioWorkletTokenDataView(data_->data.f_audio_worklet_token.Get(), context_);
}
inline void WorkletTokenDataView::GetLayoutWorkletTokenDataView(
    LayoutWorkletTokenDataView* output) {
  DCHECK(is_layout_worklet_token());
  *output = LayoutWorkletTokenDataView(data_->data.f_layout_worklet_token.Get(), context_);
}
inline void WorkletTokenDataView::GetPaintWorkletTokenDataView(
    PaintWorkletTokenDataView* output) {
  DCHECK(is_paint_worklet_token());
  *output = PaintWorkletTokenDataView(data_->data.f_paint_worklet_token.Get(), context_);
}

inline void ExecutionContextTokenDataView::GetLocalFrameTokenDataView(
    LocalFrameTokenDataView* output) {
  DCHECK(is_local_frame_token());
  *output = LocalFrameTokenDataView(data_->data.f_local_frame_token.Get(), context_);
}
inline void ExecutionContextTokenDataView::GetDedicatedWorkerTokenDataView(
    DedicatedWorkerTokenDataView* output) {
  DCHECK(is_dedicated_worker_token());
  *output = DedicatedWorkerTokenDataView(data_->data.f_dedicated_worker_token.Get(), context_);
}
inline void ExecutionContextTokenDataView::GetServiceWorkerTokenDataView(
    ServiceWorkerTokenDataView* output) {
  DCHECK(is_service_worker_token());
  *output = ServiceWorkerTokenDataView(data_->data.f_service_worker_token.Get(), context_);
}
inline void ExecutionContextTokenDataView::GetSharedWorkerTokenDataView(
    SharedWorkerTokenDataView* output) {
  DCHECK(is_shared_worker_token());
  *output = SharedWorkerTokenDataView(data_->data.f_shared_worker_token.Get(), context_);
}
inline void ExecutionContextTokenDataView::GetAnimationWorkletTokenDataView(
    AnimationWorkletTokenDataView* output) {
  DCHECK(is_animation_worklet_token());
  *output = AnimationWorkletTokenDataView(data_->data.f_animation_worklet_token.Get(), context_);
}
inline void ExecutionContextTokenDataView::GetAudioWorkletTokenDataView(
    AudioWorkletTokenDataView* output) {
  DCHECK(is_audio_worklet_token());
  *output = AudioWorkletTokenDataView(data_->data.f_audio_worklet_token.Get(), context_);
}
inline void ExecutionContextTokenDataView::GetLayoutWorkletTokenDataView(
    LayoutWorkletTokenDataView* output) {
  DCHECK(is_layout_worklet_token());
  *output = LayoutWorkletTokenDataView(data_->data.f_layout_worklet_token.Get(), context_);
}
inline void ExecutionContextTokenDataView::GetPaintWorkletTokenDataView(
    PaintWorkletTokenDataView* output) {
  DCHECK(is_paint_worklet_token());
  *output = PaintWorkletTokenDataView(data_->data.f_paint_worklet_token.Get(), context_);
}


}  // namespace mojom
}  // namespace blink

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_TOKENS_TOKENS_MOJOM_SHARED_H_