// third_party/blink/public/mojom/screen_enumeration/screen_enumeration.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_SCREEN_ENUMERATION_SCREEN_ENUMERATION_MOJOM_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_SCREEN_ENUMERATION_SCREEN_ENUMERATION_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "third_party/blink/public/mojom/screen_enumeration/screen_enumeration.mojom-shared.h"
#include "third_party/blink/public/mojom/screen_enumeration/screen_enumeration.mojom-forward.h"
#include "ui/display/mojom/display.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"


#include "third_party/blink/public/common/common_export.h"



// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace blink {
namespace mojom {

class ScreenEnumerationProxy;

template <typename ImplRefTraits>
class ScreenEnumerationStub;

class ScreenEnumerationRequestValidator;
class ScreenEnumerationResponseValidator;


class BLINK_COMMON_EXPORT ScreenEnumeration
    : public ScreenEnumerationInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = ScreenEnumerationInterfaceBase;
  using Proxy_ = ScreenEnumerationProxy;

  template <typename ImplRefTraits>
  using Stub_ = ScreenEnumerationStub<ImplRefTraits>;

  using RequestValidator_ = ScreenEnumerationRequestValidator;
  using ResponseValidator_ = ScreenEnumerationResponseValidator;
  enum MethodMinVersions : uint32_t {
    kGetDisplaysMinVersion = 0,
    kHasMultipleDisplaysMinVersion = 0,
  };
  virtual ~ScreenEnumeration() {}


  using GetDisplaysCallback = base::OnceCallback<void(DisplaysPtr)>;
  
  virtual void GetDisplays(GetDisplaysCallback callback) = 0;


  using HasMultipleDisplaysCallback = base::OnceCallback<void(MultipleDisplays)>;
  
  virtual void HasMultipleDisplays(HasMultipleDisplaysCallback callback) = 0;
};



class BLINK_COMMON_EXPORT ScreenEnumerationProxy
    : public ScreenEnumeration {
 public:
  using InterfaceType = ScreenEnumeration;

  explicit ScreenEnumerationProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void GetDisplays(GetDisplaysCallback callback) final;
  
  void HasMultipleDisplays(HasMultipleDisplaysCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class BLINK_COMMON_EXPORT ScreenEnumerationStubDispatch {
 public:
  static bool Accept(ScreenEnumeration* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ScreenEnumeration* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ScreenEnumeration>>
class ScreenEnumerationStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ScreenEnumerationStub() {}
  ~ScreenEnumerationStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ScreenEnumerationStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ScreenEnumerationStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT ScreenEnumerationRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT ScreenEnumerationResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};








class BLINK_COMMON_EXPORT Displays {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Displays, T>::value>;
  using DataView = DisplaysDataView;
  using Data_ = internal::Displays_Data;

  template <typename... Args>
  static DisplaysPtr New(Args&&... args) {
    return DisplaysPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DisplaysPtr From(const U& u) {
    return mojo::TypeConverter<DisplaysPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Displays>::Convert(*this);
  }


  Displays();

  Displays(
      std::vector<::display::Display> displays,
      int64_t internal_id,
      int64_t primary_id);

  ~Displays();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DisplaysPtr>
  DisplaysPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Displays::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Displays::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Displays::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Displays_UnserializedMessageContext<
            UserType, Displays::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<Displays::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return Displays::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Displays_UnserializedMessageContext<
            UserType, Displays::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Displays::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  std::vector<::display::Display> displays;
  
  int64_t internal_id;
  
  int64_t primary_id;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Displays::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Displays::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Displays::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Displays::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
DisplaysPtr Displays::Clone() const {
  return New(
      mojo::Clone(displays),
      mojo::Clone(internal_id),
      mojo::Clone(primary_id)
  );
}

template <typename T, Displays::EnableIfSame<T>*>
bool Displays::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->displays, other_struct.displays))
    return false;
  if (!mojo::Equals(this->internal_id, other_struct.internal_id))
    return false;
  if (!mojo::Equals(this->primary_id, other_struct.primary_id))
    return false;
  return true;
}

template <typename T, Displays::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.displays, rhs.displays))
    return true;
  if (std::less<>{}(rhs.displays, lhs.displays))
    return false;
  if (std::less<>{}(lhs.internal_id, rhs.internal_id))
    return true;
  if (std::less<>{}(rhs.internal_id, lhs.internal_id))
    return false;
  if (std::less<>{}(lhs.primary_id, rhs.primary_id))
    return true;
  if (std::less<>{}(rhs.primary_id, lhs.primary_id))
    return false;
  return false;
}


}  // namespace mojom
}  // namespace blink

namespace mojo {


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::Displays::DataView,
                                         ::blink::mojom::DisplaysPtr> {
  static bool IsNull(const ::blink::mojom::DisplaysPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::DisplaysPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::Displays::displays)& displays(
      const ::blink::mojom::DisplaysPtr& input) {
    return input->displays;
  }

  static decltype(::blink::mojom::Displays::internal_id) internal_id(
      const ::blink::mojom::DisplaysPtr& input) {
    return input->internal_id;
  }

  static decltype(::blink::mojom::Displays::primary_id) primary_id(
      const ::blink::mojom::DisplaysPtr& input) {
    return input->primary_id;
  }

  static bool Read(::blink::mojom::Displays::DataView input, ::blink::mojom::DisplaysPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_SCREEN_ENUMERATION_SCREEN_ENUMERATION_MOJOM_H_