// third_party/blink/public/mojom/input/touch_event.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_INPUT_TOUCH_EVENT_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_INPUT_TOUCH_EVENT_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <ostream>
#include <type_traits>
#include <utility>

#include "base/compiler_specific.h"
#include "base/containers/flat_map.h"
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "third_party/blink/public/mojom/input/touch_event.mojom-shared-internal.h"



#include "base/component_export.h"




namespace blink {
namespace mojom {
class TouchEventConsumersDataView;



}  // namespace mojom
}  // namespace blink

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::TouchEventConsumersDataView> {
  using Data = ::blink::mojom::internal::TouchEventConsumers_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace blink {
namespace mojom {


enum class TouchState : int32_t {
  
  kStateUndefined = 0,
  
  kStateReleased = 1,
  
  kStatePressed = 2,
  
  kStateMoved = 3,
  
  kStateStationary = 4,
  
  kStateCancelled = 5,
  
  kStateMax = 5,
  kMinValue = 0,
  kMaxValue = 5,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, TouchState value);
inline bool IsKnownEnumValue(TouchState value) {
  return internal::TouchState_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class TouchEventConsumersDataView {
 public:
  TouchEventConsumersDataView() {}

  TouchEventConsumersDataView(
      internal::TouchEventConsumers_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool has_touch_event_handlers() const {
    return data_->has_touch_event_handlers;
  }
  bool has_hit_testable_scrollbar() const {
    return data_->has_hit_testable_scrollbar;
  }
 private:
  internal::TouchEventConsumers_Data* data_ = nullptr;
};



}  // namespace mojom
}  // namespace blink

namespace std {

template <>
struct hash<::blink::mojom::TouchState>
    : public mojo::internal::EnumHashImpl<::blink::mojom::TouchState> {};

}  // namespace std

namespace mojo {


template <>
struct EnumTraits<::blink::mojom::TouchState, ::blink::mojom::TouchState> {
  static ::blink::mojom::TouchState ToMojom(::blink::mojom::TouchState input) { return input; }
  static bool FromMojom(::blink::mojom::TouchState input, ::blink::mojom::TouchState* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::TouchState, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::TouchState, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::blink::mojom::TouchState>(input), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::TouchEventConsumersDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::TouchEventConsumersDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::blink::mojom::internal::TouchEventConsumers_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    (*output)->has_touch_event_handlers = Traits::has_touch_event_handlers(input);
    (*output)->has_hit_testable_scrollbar = Traits::has_hit_testable_scrollbar(input);
  }

  static bool Deserialize(::blink::mojom::internal::TouchEventConsumers_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::TouchEventConsumersDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink {
namespace mojom {




}  // namespace mojom
}  // namespace blink

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_INPUT_TOUCH_EVENT_MOJOM_SHARED_H_