// third_party/blink/public/mojom/file_system_access/native_file_system_manager.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_FILE_SYSTEM_ACCESS_NATIVE_FILE_SYSTEM_MANAGER_MOJOM_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_FILE_SYSTEM_ACCESS_NATIVE_FILE_SYSTEM_MANAGER_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "third_party/blink/public/mojom/file_system_access/native_file_system_manager.mojom-shared.h"
#include "third_party/blink/public/mojom/file_system_access/native_file_system_manager.mojom-forward.h"
#include "mojo/public/mojom/base/string16.mojom.h"
#include "third_party/blink/public/mojom/file_system_access/native_file_system_directory_handle.mojom.h"
#include "third_party/blink/public/mojom/file_system_access/native_file_system_file_handle.mojom.h"
#include "third_party/blink/public/mojom/file_system_access/native_file_system_error.mojom.h"
#include "third_party/blink/public/mojom/file_system_access/native_file_system_transfer_token.mojom.h"
#include "third_party/blink/public/mojom/file_system_access/native_file_system_drag_drop_token.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"


#include "third_party/blink/public/common/common_export.h"



// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace blink {
namespace mojom {

class NativeFileSystemManagerProxy;

template <typename ImplRefTraits>
class NativeFileSystemManagerStub;

class NativeFileSystemManagerRequestValidator;
class NativeFileSystemManagerResponseValidator;


class BLINK_COMMON_EXPORT NativeFileSystemManager
    : public NativeFileSystemManagerInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = NativeFileSystemManagerInterfaceBase;
  using Proxy_ = NativeFileSystemManagerProxy;

  template <typename ImplRefTraits>
  using Stub_ = NativeFileSystemManagerStub<ImplRefTraits>;

  using RequestValidator_ = NativeFileSystemManagerRequestValidator;
  using ResponseValidator_ = NativeFileSystemManagerResponseValidator;
  enum MethodMinVersions : uint32_t {
    kGetSandboxedFileSystemMinVersion = 0,
    kChooseEntriesMinVersion = 0,
    kGetFileHandleFromTokenMinVersion = 0,
    kGetDirectoryHandleFromTokenMinVersion = 0,
    kGetEntryFromDragDropTokenMinVersion = 0,
  };
  virtual ~NativeFileSystemManager() {}


  using GetSandboxedFileSystemCallback = base::OnceCallback<void(::blink::mojom::NativeFileSystemErrorPtr, ::mojo::PendingRemote<::blink::mojom::NativeFileSystemDirectoryHandle>)>;
  
  virtual void GetSandboxedFileSystem(GetSandboxedFileSystemCallback callback) = 0;


  using ChooseEntriesCallback = base::OnceCallback<void(::blink::mojom::NativeFileSystemErrorPtr, std::vector<::blink::mojom::NativeFileSystemEntryPtr>)>;
  
  virtual void ChooseEntries(ChooseFileSystemEntryType type, std::vector<ChooseFileSystemEntryAcceptsOptionPtr> accepts, bool include_accepts_all, ChooseEntriesCallback callback) = 0;

  
  virtual void GetFileHandleFromToken(::mojo::PendingRemote<::blink::mojom::NativeFileSystemTransferToken> token, ::mojo::PendingReceiver<::blink::mojom::NativeFileSystemFileHandle> file_handle) = 0;

  
  virtual void GetDirectoryHandleFromToken(::mojo::PendingRemote<::blink::mojom::NativeFileSystemTransferToken> token, ::mojo::PendingReceiver<::blink::mojom::NativeFileSystemDirectoryHandle> directory_handle) = 0;


  using GetEntryFromDragDropTokenCallback = base::OnceCallback<void(::blink::mojom::NativeFileSystemEntryPtr)>;
  
  virtual void GetEntryFromDragDropToken(::mojo::PendingRemote<::blink::mojom::NativeFileSystemDragDropToken> token, GetEntryFromDragDropTokenCallback callback) = 0;
};



class BLINK_COMMON_EXPORT NativeFileSystemManagerProxy
    : public NativeFileSystemManager {
 public:
  using InterfaceType = NativeFileSystemManager;

  explicit NativeFileSystemManagerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void GetSandboxedFileSystem(GetSandboxedFileSystemCallback callback) final;
  
  void ChooseEntries(ChooseFileSystemEntryType type, std::vector<ChooseFileSystemEntryAcceptsOptionPtr> accepts, bool include_accepts_all, ChooseEntriesCallback callback) final;
  
  void GetFileHandleFromToken(::mojo::PendingRemote<::blink::mojom::NativeFileSystemTransferToken> token, ::mojo::PendingReceiver<::blink::mojom::NativeFileSystemFileHandle> file_handle) final;
  
  void GetDirectoryHandleFromToken(::mojo::PendingRemote<::blink::mojom::NativeFileSystemTransferToken> token, ::mojo::PendingReceiver<::blink::mojom::NativeFileSystemDirectoryHandle> directory_handle) final;
  
  void GetEntryFromDragDropToken(::mojo::PendingRemote<::blink::mojom::NativeFileSystemDragDropToken> token, GetEntryFromDragDropTokenCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class BLINK_COMMON_EXPORT NativeFileSystemManagerStubDispatch {
 public:
  static bool Accept(NativeFileSystemManager* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      NativeFileSystemManager* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<NativeFileSystemManager>>
class NativeFileSystemManagerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  NativeFileSystemManagerStub() {}
  ~NativeFileSystemManagerStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return NativeFileSystemManagerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return NativeFileSystemManagerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT NativeFileSystemManagerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT NativeFileSystemManagerResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};








class BLINK_COMMON_EXPORT ChooseFileSystemEntryAcceptsOption {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ChooseFileSystemEntryAcceptsOption, T>::value>;
  using DataView = ChooseFileSystemEntryAcceptsOptionDataView;
  using Data_ = internal::ChooseFileSystemEntryAcceptsOption_Data;

  template <typename... Args>
  static ChooseFileSystemEntryAcceptsOptionPtr New(Args&&... args) {
    return ChooseFileSystemEntryAcceptsOptionPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ChooseFileSystemEntryAcceptsOptionPtr From(const U& u) {
    return mojo::TypeConverter<ChooseFileSystemEntryAcceptsOptionPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ChooseFileSystemEntryAcceptsOption>::Convert(*this);
  }


  ChooseFileSystemEntryAcceptsOption();

  ChooseFileSystemEntryAcceptsOption(
      const ::base::string16& description,
      std::vector<std::string> mime_types,
      std::vector<std::string> extensions);

  ~ChooseFileSystemEntryAcceptsOption();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ChooseFileSystemEntryAcceptsOptionPtr>
  ChooseFileSystemEntryAcceptsOptionPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ChooseFileSystemEntryAcceptsOption::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ChooseFileSystemEntryAcceptsOption::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ChooseFileSystemEntryAcceptsOption::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ChooseFileSystemEntryAcceptsOption_UnserializedMessageContext<
            UserType, ChooseFileSystemEntryAcceptsOption::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<ChooseFileSystemEntryAcceptsOption::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return ChooseFileSystemEntryAcceptsOption::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ChooseFileSystemEntryAcceptsOption_UnserializedMessageContext<
            UserType, ChooseFileSystemEntryAcceptsOption::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ChooseFileSystemEntryAcceptsOption::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ::base::string16 description;
  
  std::vector<std::string> mime_types;
  
  std::vector<std::string> extensions;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ChooseFileSystemEntryAcceptsOption::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ChooseFileSystemEntryAcceptsOption::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ChooseFileSystemEntryAcceptsOption::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ChooseFileSystemEntryAcceptsOption::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
ChooseFileSystemEntryAcceptsOptionPtr ChooseFileSystemEntryAcceptsOption::Clone() const {
  return New(
      mojo::Clone(description),
      mojo::Clone(mime_types),
      mojo::Clone(extensions)
  );
}

template <typename T, ChooseFileSystemEntryAcceptsOption::EnableIfSame<T>*>
bool ChooseFileSystemEntryAcceptsOption::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->description, other_struct.description))
    return false;
  if (!mojo::Equals(this->mime_types, other_struct.mime_types))
    return false;
  if (!mojo::Equals(this->extensions, other_struct.extensions))
    return false;
  return true;
}

template <typename T, ChooseFileSystemEntryAcceptsOption::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.description, rhs.description))
    return true;
  if (std::less<>{}(rhs.description, lhs.description))
    return false;
  if (std::less<>{}(lhs.mime_types, rhs.mime_types))
    return true;
  if (std::less<>{}(rhs.mime_types, lhs.mime_types))
    return false;
  if (std::less<>{}(lhs.extensions, rhs.extensions))
    return true;
  if (std::less<>{}(rhs.extensions, lhs.extensions))
    return false;
  return false;
}


}  // namespace mojom
}  // namespace blink

namespace mojo {


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::ChooseFileSystemEntryAcceptsOption::DataView,
                                         ::blink::mojom::ChooseFileSystemEntryAcceptsOptionPtr> {
  static bool IsNull(const ::blink::mojom::ChooseFileSystemEntryAcceptsOptionPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::ChooseFileSystemEntryAcceptsOptionPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::ChooseFileSystemEntryAcceptsOption::description)& description(
      const ::blink::mojom::ChooseFileSystemEntryAcceptsOptionPtr& input) {
    return input->description;
  }

  static const decltype(::blink::mojom::ChooseFileSystemEntryAcceptsOption::mime_types)& mime_types(
      const ::blink::mojom::ChooseFileSystemEntryAcceptsOptionPtr& input) {
    return input->mime_types;
  }

  static const decltype(::blink::mojom::ChooseFileSystemEntryAcceptsOption::extensions)& extensions(
      const ::blink::mojom::ChooseFileSystemEntryAcceptsOptionPtr& input) {
    return input->extensions;
  }

  static bool Read(::blink::mojom::ChooseFileSystemEntryAcceptsOption::DataView input, ::blink::mojom::ChooseFileSystemEntryAcceptsOptionPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_FILE_SYSTEM_ACCESS_NATIVE_FILE_SYSTEM_MANAGER_MOJOM_H_