// Copyright (c) 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// Generated from template:
//   templates/document_policy_features.cc.tmpl
// and input files:
//   ../../../../src/3rdparty/chromium/third_party/blink/renderer/core/feature_policy/document_policy_features.json5


#include "base/no_destructor.h"
#include "third_party/blink/public/common/feature_policy/document_policy_features.h"
#include "third_party/blink/public/common/feature_policy/policy_value.h"
#include "third_party/blink/public/mojom/feature_policy/policy_value.mojom.h"
#include "third_party/blink/public/mojom/feature_policy/document_policy_feature.mojom.h"


namespace blink {

const DocumentPolicyFeatureInfoMap& GetDocumentPolicyFeatureInfoMap() {
  static const base::NoDestructor<DocumentPolicyFeatureInfoMap> feature_info_map({      {
        mojom::DocumentPolicyFeature::kDefault,
        {
          "*",
          PolicyValue::CreateBool(true)
        }
      },      {
        mojom::DocumentPolicyFeature::kFontDisplay,
        {
          "font-display-late-swap",
          PolicyValue::CreateBool(true)
        }
      },      {
        mojom::DocumentPolicyFeature::kLosslessImagesMaxBpp,
        {
          "lossless-images-max-bpp",
          PolicyValue::CreateMaxPolicyValue(mojom::PolicyValueType::kDecDouble)
        }
      },      {
        mojom::DocumentPolicyFeature::kForceLoadAtTop,
        {
          "force-load-at-top",
          PolicyValue::CreateBool(false)
        }
      },      {
        mojom::DocumentPolicyFeature::kLosslessImagesStrictMaxBpp,
        {
          "lossless-images-strict-max-bpp",
          PolicyValue::CreateMaxPolicyValue(mojom::PolicyValueType::kDecDouble)
        }
      },      {
        mojom::DocumentPolicyFeature::kLossyImagesMaxBpp,
        {
          "lossy-images-max-bpp",
          PolicyValue::CreateMaxPolicyValue(mojom::PolicyValueType::kDecDouble)
        }
      },      {
        mojom::DocumentPolicyFeature::kOversizedImages,
        {
          "oversized-images",
          PolicyValue::CreateMaxPolicyValue(mojom::PolicyValueType::kDecDouble)
        }
      },      {
        mojom::DocumentPolicyFeature::kUnsizedMedia,
        {
          "unsized-media",
          PolicyValue::CreateBool(true)
        }
      },      {
        mojom::DocumentPolicyFeature::kLayoutAnimations,
        {
          "layout-animations",
          PolicyValue::CreateBool(true)
        }
      },      {
        mojom::DocumentPolicyFeature::kDocumentWrite,
        {
          "document-write",
          PolicyValue::CreateBool(true)
        }
      },      {
        mojom::DocumentPolicyFeature::kSyncScript,
        {
          "sync-script",
          PolicyValue::CreateBool(true)
        }
      },  });
  return *feature_info_map;
}

const DocumentPolicyNameFeatureMap& GetDocumentPolicyNameFeatureMap() {
  static const base::NoDestructor<DocumentPolicyNameFeatureMap> name_feature_map([] {
    DocumentPolicyNameFeatureMap map;
    for (const auto& entry : GetDocumentPolicyFeatureInfoMap())
      map.emplace(entry.second.feature_name, entry.first);
    return map;
  }());
  return *name_feature_map;
}

} // namespace blink


