// services/network/public/mojom/cross_origin_opener_policy.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/network/public/mojom/cross_origin_opener_policy.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"

#include "services/network/public/mojom/cross_origin_opener_policy.mojom-params-data.h"
namespace network {
namespace mojom {

std::ostream& operator<<(std::ostream& os, CoopAccessReportType value) {
  switch(value) {
    case CoopAccessReportType::kAccessFromCoopPageToOpener:
      return os << "CoopAccessReportType::kAccessFromCoopPageToOpener";
    case CoopAccessReportType::kAccessFromCoopPageToOpenee:
      return os << "CoopAccessReportType::kAccessFromCoopPageToOpenee";
    case CoopAccessReportType::kAccessFromCoopPageToOther:
      return os << "CoopAccessReportType::kAccessFromCoopPageToOther";
    case CoopAccessReportType::kAccessToCoopPageFromOpener:
      return os << "CoopAccessReportType::kAccessToCoopPageFromOpener";
    case CoopAccessReportType::kAccessToCoopPageFromOpenee:
      return os << "CoopAccessReportType::kAccessToCoopPageFromOpenee";
    case CoopAccessReportType::kAccessToCoopPageFromOther:
      return os << "CoopAccessReportType::kAccessToCoopPageFromOther";
    default:
      return os << "Unknown CoopAccessReportType value: " << static_cast<int32_t>(value);
  }
}

std::ostream& operator<<(std::ostream& os, CrossOriginOpenerPolicyValue value) {
  switch(value) {
    case CrossOriginOpenerPolicyValue::kSameOrigin:
      return os << "CrossOriginOpenerPolicyValue::kSameOrigin";
    case CrossOriginOpenerPolicyValue::kSameOriginAllowPopups:
      return os << "CrossOriginOpenerPolicyValue::kSameOriginAllowPopups";
    case CrossOriginOpenerPolicyValue::kUnsafeNone:
      return os << "CrossOriginOpenerPolicyValue::kUnsafeNone";
    case CrossOriginOpenerPolicyValue::kSameOriginPlusCoep:
      return os << "CrossOriginOpenerPolicyValue::kSameOriginPlusCoep";
    default:
      return os << "Unknown CrossOriginOpenerPolicyValue value: " << static_cast<int32_t>(value);
  }
}

namespace internal {


// static
bool CrossOriginOpenerPolicy_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CrossOriginOpenerPolicy_Data* object = static_cast<const CrossOriginOpenerPolicy_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 32 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }


  if (!::network::mojom::internal::CrossOriginOpenerPolicyValue_Data
        ::Validate(object->value, validation_context))
    return false;

  const mojo::internal::ContainerValidateParams reporting_endpoint_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->reporting_endpoint, validation_context,
                                         &reporting_endpoint_validate_params)) {
    return false;
  }


  if (!::network::mojom::internal::CrossOriginOpenerPolicyValue_Data
        ::Validate(object->report_only_value, validation_context))
    return false;

  const mojo::internal::ContainerValidateParams report_only_reporting_endpoint_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->report_only_reporting_endpoint, validation_context,
                                         &report_only_reporting_endpoint_validate_params)) {
    return false;
  }

  return true;
}

CrossOriginOpenerPolicy_Data::CrossOriginOpenerPolicy_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CrossOriginOpenerPolicyReporter_QueueAccessReport_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CrossOriginOpenerPolicyReporter_QueueAccessReport_Params_Data* object = static_cast<const CrossOriginOpenerPolicyReporter_QueueAccessReport_Params_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 40 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }


  if (!::network::mojom::internal::CoopAccessReportType_Data
        ::Validate(object->report_type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->property, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams property_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->property, validation_context,
                                         &property_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->source_location, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->source_location, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->reported_window_url, 4, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams reported_window_url_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->reported_window_url, validation_context,
                                         &reported_window_url_validate_params)) {
    return false;
  }

  return true;
}

CrossOriginOpenerPolicyReporter_QueueAccessReport_Params_Data::CrossOriginOpenerPolicyReporter_QueueAccessReport_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace network