// services/network/public/mojom/cross_origin_embedder_policy.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/network/public/mojom/cross_origin_embedder_policy.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"

#include "services/network/public/mojom/cross_origin_embedder_policy.mojom-params-data.h"
namespace network {
namespace mojom {

std::ostream& operator<<(std::ostream& os, CrossOriginEmbedderPolicyValue value) {
  switch(value) {
    case CrossOriginEmbedderPolicyValue::kNone:
      return os << "CrossOriginEmbedderPolicyValue::kNone";
    case CrossOriginEmbedderPolicyValue::kRequireCorp:
      return os << "CrossOriginEmbedderPolicyValue::kRequireCorp";
    default:
      return os << "Unknown CrossOriginEmbedderPolicyValue value: " << static_cast<int32_t>(value);
  }
}

namespace internal {


// static
bool CrossOriginEmbedderPolicy_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CrossOriginEmbedderPolicy_Data* object = static_cast<const CrossOriginEmbedderPolicy_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 32 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }


  if (!::network::mojom::internal::CrossOriginEmbedderPolicyValue_Data
        ::Validate(object->value, validation_context))
    return false;

  const mojo::internal::ContainerValidateParams reporting_endpoint_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->reporting_endpoint, validation_context,
                                         &reporting_endpoint_validate_params)) {
    return false;
  }


  if (!::network::mojom::internal::CrossOriginEmbedderPolicyValue_Data
        ::Validate(object->report_only_value, validation_context))
    return false;

  const mojo::internal::ContainerValidateParams report_only_reporting_endpoint_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->report_only_reporting_endpoint, validation_context,
                                         &report_only_reporting_endpoint_validate_params)) {
    return false;
  }

  return true;
}

CrossOriginEmbedderPolicy_Data::CrossOriginEmbedderPolicy_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CrossOriginEmbedderPolicyReporter_QueueCorpViolationReport_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CrossOriginEmbedderPolicyReporter_QueueCorpViolationReport_Params_Data* object = static_cast<const CrossOriginEmbedderPolicyReporter_QueueCorpViolationReport_Params_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 24 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->blocked_url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->blocked_url, validation_context))
    return false;


  if (!::network::mojom::internal::RequestDestination_Data
        ::Validate(object->destination, validation_context))
    return false;

  return true;
}

CrossOriginEmbedderPolicyReporter_QueueCorpViolationReport_Params_Data::CrossOriginEmbedderPolicyReporter_QueueCorpViolationReport_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CrossOriginEmbedderPolicyReporter_Clone_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CrossOriginEmbedderPolicyReporter_Clone_Params_Data* object = static_cast<const CrossOriginEmbedderPolicyReporter_Clone_Params_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 16 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->receiver, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->receiver,
                                                 validation_context)) {
    return false;
  }

  return true;
}

CrossOriginEmbedderPolicyReporter_Clone_Params_Data::CrossOriginEmbedderPolicyReporter_Clone_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace network