// media/mojo/mojom/watch_time_recorder.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_WATCH_TIME_RECORDER_MOJOM_BLINK_H_
#define MEDIA_MOJO_MOJOM_WATCH_TIME_RECORDER_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "media/mojo/mojom/watch_time_recorder.mojom-shared.h"
#include "media/mojo/mojom/watch_time_recorder.mojom-blink-forward.h"
#include "media/mojo/mojom/media_types.mojom-blink.h"
#include "mojo/public/mojom/base/time.mojom-blink.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"


#include "mojo/public/cpp/bindings/lib/native_enum_serialization.h"
#include "mojo/public/cpp/bindings/lib/native_struct_serialization.h"
#include "third_party/blink/public/platform/web_common.h"



// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace media {
namespace mojom {
namespace blink {

class WatchTimeRecorderProxy;

template <typename ImplRefTraits>
class WatchTimeRecorderStub;

class WatchTimeRecorderRequestValidator;


class BLINK_PLATFORM_EXPORT WatchTimeRecorder
    : public WatchTimeRecorderInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = WatchTimeRecorderInterfaceBase;
  using Proxy_ = WatchTimeRecorderProxy;

  template <typename ImplRefTraits>
  using Stub_ = WatchTimeRecorderStub<ImplRefTraits>;

  using RequestValidator_ = WatchTimeRecorderRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kRecordWatchTimeMinVersion = 0,
    kFinalizeWatchTimeMinVersion = 0,
    kOnErrorMinVersion = 0,
    kUpdateSecondaryPropertiesMinVersion = 0,
    kSetAutoplayInitiatedMinVersion = 0,
    kOnDurationChangedMinVersion = 0,
    kUpdateVideoDecodeStatsMinVersion = 0,
    kUpdateUnderflowCountMinVersion = 0,
    kUpdateUnderflowDurationMinVersion = 0,
    kOnCurrentTimestampChangedMinVersion = 0,
  };
  virtual ~WatchTimeRecorder() {}

  
  virtual void RecordWatchTime(::media::mojom::blink::WatchTimeKey key, ::base::TimeDelta watch_time) = 0;

  
  virtual void FinalizeWatchTime(const WTF::Vector<::media::mojom::blink::WatchTimeKey>& watch_time_keys) = 0;

  
  virtual void OnError(::media::mojom::blink::PipelineStatus status) = 0;

  
  virtual void UpdateSecondaryProperties(SecondaryPlaybackPropertiesPtr secondary_properties) = 0;

  
  virtual void SetAutoplayInitiated(bool value) = 0;

  
  virtual void OnDurationChanged(::base::TimeDelta duration) = 0;

  
  virtual void UpdateVideoDecodeStats(uint32_t frames_decoded, uint32_t frames_dropped) = 0;

  
  virtual void UpdateUnderflowCount(int32_t total_count) = 0;

  
  virtual void UpdateUnderflowDuration(int32_t total_completed_count, ::base::TimeDelta total_duration) = 0;

  
  virtual void OnCurrentTimestampChanged(::base::TimeDelta last_timestamp) = 0;
};



class BLINK_PLATFORM_EXPORT WatchTimeRecorderProxy
    : public WatchTimeRecorder {
 public:
  using InterfaceType = WatchTimeRecorder;

  explicit WatchTimeRecorderProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void RecordWatchTime(::media::mojom::blink::WatchTimeKey key, ::base::TimeDelta watch_time) final;
  
  void FinalizeWatchTime(const WTF::Vector<::media::mojom::blink::WatchTimeKey>& watch_time_keys) final;
  
  void OnError(::media::mojom::blink::PipelineStatus status) final;
  
  void UpdateSecondaryProperties(SecondaryPlaybackPropertiesPtr secondary_properties) final;
  
  void SetAutoplayInitiated(bool value) final;
  
  void OnDurationChanged(::base::TimeDelta duration) final;
  
  void UpdateVideoDecodeStats(uint32_t frames_decoded, uint32_t frames_dropped) final;
  
  void UpdateUnderflowCount(int32_t total_count) final;
  
  void UpdateUnderflowDuration(int32_t total_completed_count, ::base::TimeDelta total_duration) final;
  
  void OnCurrentTimestampChanged(::base::TimeDelta last_timestamp) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class BLINK_PLATFORM_EXPORT WatchTimeRecorderStubDispatch {
 public:
  static bool Accept(WatchTimeRecorder* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      WatchTimeRecorder* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<WatchTimeRecorder>>
class WatchTimeRecorderStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  WatchTimeRecorderStub() {}
  ~WatchTimeRecorderStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WatchTimeRecorderStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WatchTimeRecorderStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_PLATFORM_EXPORT WatchTimeRecorderRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};









class BLINK_PLATFORM_EXPORT PlaybackProperties {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PlaybackProperties, T>::value>;
  using DataView = PlaybackPropertiesDataView;
  using Data_ = internal::PlaybackProperties_Data;

  template <typename... Args>
  static PlaybackPropertiesPtr New(Args&&... args) {
    return PlaybackPropertiesPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PlaybackPropertiesPtr From(const U& u) {
    return mojo::TypeConverter<PlaybackPropertiesPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PlaybackProperties>::Convert(*this);
  }


  PlaybackProperties();

  PlaybackProperties(
      bool has_audio,
      bool has_video,
      bool is_background,
      bool is_muted,
      bool is_mse,
      bool is_eme,
      bool is_embedded_media_experience);

  ~PlaybackProperties();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PlaybackPropertiesPtr>
  PlaybackPropertiesPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PlaybackProperties::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;
  size_t Hash(size_t seed) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PlaybackProperties::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PlaybackProperties::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PlaybackProperties_UnserializedMessageContext<
            UserType, PlaybackProperties::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<PlaybackProperties::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return PlaybackProperties::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PlaybackProperties_UnserializedMessageContext<
            UserType, PlaybackProperties::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PlaybackProperties::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  bool has_audio;
  
  bool has_video;
  
  bool is_background;
  
  bool is_muted;
  
  bool is_mse;
  
  bool is_eme;
  
  bool is_embedded_media_experience;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PlaybackProperties::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PlaybackProperties::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PlaybackProperties::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PlaybackProperties::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT SecondaryPlaybackProperties {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SecondaryPlaybackProperties, T>::value>;
  using DataView = SecondaryPlaybackPropertiesDataView;
  using Data_ = internal::SecondaryPlaybackProperties_Data;

  template <typename... Args>
  static SecondaryPlaybackPropertiesPtr New(Args&&... args) {
    return SecondaryPlaybackPropertiesPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SecondaryPlaybackPropertiesPtr From(const U& u) {
    return mojo::TypeConverter<SecondaryPlaybackPropertiesPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SecondaryPlaybackProperties>::Convert(*this);
  }


  SecondaryPlaybackProperties();

  SecondaryPlaybackProperties(
      ::media::mojom::blink::AudioCodec audio_codec,
      ::media::mojom::blink::VideoCodec video_codec,
      ::media::mojom::blink::AudioCodecProfile audio_codec_profile,
      ::media::mojom::blink::VideoCodecProfile video_codec_profile,
      const WTF::String& audio_decoder_name,
      const WTF::String& video_decoder_name,
      ::media::mojom::blink::EncryptionScheme audio_encryption_scheme,
      ::media::mojom::blink::EncryptionScheme video_encryption_scheme,
      const ::gfx::Size& natural_size);

  ~SecondaryPlaybackProperties();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SecondaryPlaybackPropertiesPtr>
  SecondaryPlaybackPropertiesPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SecondaryPlaybackProperties::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SecondaryPlaybackProperties::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SecondaryPlaybackProperties::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SecondaryPlaybackProperties_UnserializedMessageContext<
            UserType, SecondaryPlaybackProperties::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<SecondaryPlaybackProperties::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return SecondaryPlaybackProperties::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SecondaryPlaybackProperties_UnserializedMessageContext<
            UserType, SecondaryPlaybackProperties::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SecondaryPlaybackProperties::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ::media::mojom::blink::AudioCodec audio_codec;
  
  ::media::mojom::blink::VideoCodec video_codec;
  
  ::media::mojom::blink::AudioCodecProfile audio_codec_profile;
  
  ::media::mojom::blink::VideoCodecProfile video_codec_profile;
  
  WTF::String audio_decoder_name;
  
  WTF::String video_decoder_name;
  
  ::media::mojom::blink::EncryptionScheme audio_encryption_scheme;
  
  ::media::mojom::blink::EncryptionScheme video_encryption_scheme;
  
  ::gfx::Size natural_size;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SecondaryPlaybackProperties::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SecondaryPlaybackProperties::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SecondaryPlaybackProperties::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SecondaryPlaybackProperties::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
PlaybackPropertiesPtr PlaybackProperties::Clone() const {
  return New(
      mojo::Clone(has_audio),
      mojo::Clone(has_video),
      mojo::Clone(is_background),
      mojo::Clone(is_muted),
      mojo::Clone(is_mse),
      mojo::Clone(is_eme),
      mojo::Clone(is_embedded_media_experience)
  );
}

template <typename T, PlaybackProperties::EnableIfSame<T>*>
bool PlaybackProperties::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->has_audio, other_struct.has_audio))
    return false;
  if (!mojo::Equals(this->has_video, other_struct.has_video))
    return false;
  if (!mojo::Equals(this->is_background, other_struct.is_background))
    return false;
  if (!mojo::Equals(this->is_muted, other_struct.is_muted))
    return false;
  if (!mojo::Equals(this->is_mse, other_struct.is_mse))
    return false;
  if (!mojo::Equals(this->is_eme, other_struct.is_eme))
    return false;
  if (!mojo::Equals(this->is_embedded_media_experience, other_struct.is_embedded_media_experience))
    return false;
  return true;
}

template <typename T, PlaybackProperties::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.has_audio, rhs.has_audio))
    return true;
  if (std::less<>{}(rhs.has_audio, lhs.has_audio))
    return false;
  if (std::less<>{}(lhs.has_video, rhs.has_video))
    return true;
  if (std::less<>{}(rhs.has_video, lhs.has_video))
    return false;
  if (std::less<>{}(lhs.is_background, rhs.is_background))
    return true;
  if (std::less<>{}(rhs.is_background, lhs.is_background))
    return false;
  if (std::less<>{}(lhs.is_muted, rhs.is_muted))
    return true;
  if (std::less<>{}(rhs.is_muted, lhs.is_muted))
    return false;
  if (std::less<>{}(lhs.is_mse, rhs.is_mse))
    return true;
  if (std::less<>{}(rhs.is_mse, lhs.is_mse))
    return false;
  if (std::less<>{}(lhs.is_eme, rhs.is_eme))
    return true;
  if (std::less<>{}(rhs.is_eme, lhs.is_eme))
    return false;
  if (std::less<>{}(lhs.is_embedded_media_experience, rhs.is_embedded_media_experience))
    return true;
  if (std::less<>{}(rhs.is_embedded_media_experience, lhs.is_embedded_media_experience))
    return false;
  return false;
}
template <typename StructPtrType>
SecondaryPlaybackPropertiesPtr SecondaryPlaybackProperties::Clone() const {
  return New(
      mojo::Clone(audio_codec),
      mojo::Clone(video_codec),
      mojo::Clone(audio_codec_profile),
      mojo::Clone(video_codec_profile),
      mojo::Clone(audio_decoder_name),
      mojo::Clone(video_decoder_name),
      mojo::Clone(audio_encryption_scheme),
      mojo::Clone(video_encryption_scheme),
      mojo::Clone(natural_size)
  );
}

template <typename T, SecondaryPlaybackProperties::EnableIfSame<T>*>
bool SecondaryPlaybackProperties::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->audio_codec, other_struct.audio_codec))
    return false;
  if (!mojo::Equals(this->video_codec, other_struct.video_codec))
    return false;
  if (!mojo::Equals(this->audio_codec_profile, other_struct.audio_codec_profile))
    return false;
  if (!mojo::Equals(this->video_codec_profile, other_struct.video_codec_profile))
    return false;
  if (!mojo::Equals(this->audio_decoder_name, other_struct.audio_decoder_name))
    return false;
  if (!mojo::Equals(this->video_decoder_name, other_struct.video_decoder_name))
    return false;
  if (!mojo::Equals(this->audio_encryption_scheme, other_struct.audio_encryption_scheme))
    return false;
  if (!mojo::Equals(this->video_encryption_scheme, other_struct.video_encryption_scheme))
    return false;
  if (!mojo::Equals(this->natural_size, other_struct.natural_size))
    return false;
  return true;
}

template <typename T, SecondaryPlaybackProperties::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.audio_codec, rhs.audio_codec))
    return true;
  if (std::less<>{}(rhs.audio_codec, lhs.audio_codec))
    return false;
  if (std::less<>{}(lhs.video_codec, rhs.video_codec))
    return true;
  if (std::less<>{}(rhs.video_codec, lhs.video_codec))
    return false;
  if (std::less<>{}(lhs.audio_codec_profile, rhs.audio_codec_profile))
    return true;
  if (std::less<>{}(rhs.audio_codec_profile, lhs.audio_codec_profile))
    return false;
  if (std::less<>{}(lhs.video_codec_profile, rhs.video_codec_profile))
    return true;
  if (std::less<>{}(rhs.video_codec_profile, lhs.video_codec_profile))
    return false;
  if (std::less<>{}(lhs.audio_decoder_name, rhs.audio_decoder_name))
    return true;
  if (std::less<>{}(rhs.audio_decoder_name, lhs.audio_decoder_name))
    return false;
  if (std::less<>{}(lhs.video_decoder_name, rhs.video_decoder_name))
    return true;
  if (std::less<>{}(rhs.video_decoder_name, lhs.video_decoder_name))
    return false;
  if (std::less<>{}(lhs.audio_encryption_scheme, rhs.audio_encryption_scheme))
    return true;
  if (std::less<>{}(rhs.audio_encryption_scheme, lhs.audio_encryption_scheme))
    return false;
  if (std::less<>{}(lhs.video_encryption_scheme, rhs.video_encryption_scheme))
    return true;
  if (std::less<>{}(rhs.video_encryption_scheme, lhs.video_encryption_scheme))
    return false;
  if (std::less<>{}(lhs.natural_size, rhs.natural_size))
    return true;
  if (std::less<>{}(rhs.natural_size, lhs.natural_size))
    return false;
  return false;
}


}  // namespace blink
}  // namespace mojom
}  // namespace media

namespace mojo {


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::media::mojom::blink::PlaybackProperties::DataView,
                                         ::media::mojom::blink::PlaybackPropertiesPtr> {
  static bool IsNull(const ::media::mojom::blink::PlaybackPropertiesPtr& input) { return !input; }
  static void SetToNull(::media::mojom::blink::PlaybackPropertiesPtr* output) { output->reset(); }

  static decltype(::media::mojom::blink::PlaybackProperties::has_audio) has_audio(
      const ::media::mojom::blink::PlaybackPropertiesPtr& input) {
    return input->has_audio;
  }

  static decltype(::media::mojom::blink::PlaybackProperties::has_video) has_video(
      const ::media::mojom::blink::PlaybackPropertiesPtr& input) {
    return input->has_video;
  }

  static decltype(::media::mojom::blink::PlaybackProperties::is_background) is_background(
      const ::media::mojom::blink::PlaybackPropertiesPtr& input) {
    return input->is_background;
  }

  static decltype(::media::mojom::blink::PlaybackProperties::is_muted) is_muted(
      const ::media::mojom::blink::PlaybackPropertiesPtr& input) {
    return input->is_muted;
  }

  static decltype(::media::mojom::blink::PlaybackProperties::is_mse) is_mse(
      const ::media::mojom::blink::PlaybackPropertiesPtr& input) {
    return input->is_mse;
  }

  static decltype(::media::mojom::blink::PlaybackProperties::is_eme) is_eme(
      const ::media::mojom::blink::PlaybackPropertiesPtr& input) {
    return input->is_eme;
  }

  static decltype(::media::mojom::blink::PlaybackProperties::is_embedded_media_experience) is_embedded_media_experience(
      const ::media::mojom::blink::PlaybackPropertiesPtr& input) {
    return input->is_embedded_media_experience;
  }

  static bool Read(::media::mojom::blink::PlaybackProperties::DataView input, ::media::mojom::blink::PlaybackPropertiesPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::media::mojom::blink::SecondaryPlaybackProperties::DataView,
                                         ::media::mojom::blink::SecondaryPlaybackPropertiesPtr> {
  static bool IsNull(const ::media::mojom::blink::SecondaryPlaybackPropertiesPtr& input) { return !input; }
  static void SetToNull(::media::mojom::blink::SecondaryPlaybackPropertiesPtr* output) { output->reset(); }

  static decltype(::media::mojom::blink::SecondaryPlaybackProperties::audio_codec) audio_codec(
      const ::media::mojom::blink::SecondaryPlaybackPropertiesPtr& input) {
    return input->audio_codec;
  }

  static decltype(::media::mojom::blink::SecondaryPlaybackProperties::video_codec) video_codec(
      const ::media::mojom::blink::SecondaryPlaybackPropertiesPtr& input) {
    return input->video_codec;
  }

  static decltype(::media::mojom::blink::SecondaryPlaybackProperties::audio_codec_profile) audio_codec_profile(
      const ::media::mojom::blink::SecondaryPlaybackPropertiesPtr& input) {
    return input->audio_codec_profile;
  }

  static decltype(::media::mojom::blink::SecondaryPlaybackProperties::video_codec_profile) video_codec_profile(
      const ::media::mojom::blink::SecondaryPlaybackPropertiesPtr& input) {
    return input->video_codec_profile;
  }

  static const decltype(::media::mojom::blink::SecondaryPlaybackProperties::audio_decoder_name)& audio_decoder_name(
      const ::media::mojom::blink::SecondaryPlaybackPropertiesPtr& input) {
    return input->audio_decoder_name;
  }

  static const decltype(::media::mojom::blink::SecondaryPlaybackProperties::video_decoder_name)& video_decoder_name(
      const ::media::mojom::blink::SecondaryPlaybackPropertiesPtr& input) {
    return input->video_decoder_name;
  }

  static decltype(::media::mojom::blink::SecondaryPlaybackProperties::audio_encryption_scheme) audio_encryption_scheme(
      const ::media::mojom::blink::SecondaryPlaybackPropertiesPtr& input) {
    return input->audio_encryption_scheme;
  }

  static decltype(::media::mojom::blink::SecondaryPlaybackProperties::video_encryption_scheme) video_encryption_scheme(
      const ::media::mojom::blink::SecondaryPlaybackPropertiesPtr& input) {
    return input->video_encryption_scheme;
  }

  static const decltype(::media::mojom::blink::SecondaryPlaybackProperties::natural_size)& natural_size(
      const ::media::mojom::blink::SecondaryPlaybackPropertiesPtr& input) {
    return input->natural_size;
  }

  static bool Read(::media::mojom::blink::SecondaryPlaybackProperties::DataView input, ::media::mojom::blink::SecondaryPlaybackPropertiesPtr* output);
};

}  // namespace mojo

#endif  // MEDIA_MOJO_MOJOM_WATCH_TIME_RECORDER_MOJOM_BLINK_H_